# Immunization - COVID Dose 1 - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Immunization - COVID Dose 1**

## Example Immunization: Immunization - COVID Dose 1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Immunization](StructureDefinition-au-core-immunization.md)

**status**: Completed

**vaccineCode**: Pfizer Comirnaty

**patient**: [Mrs. Anne Mary Bennelong(official) Female, DoB: 1968-10-11 ( Medical record number)](Patient-bennelong-anne.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); serviceType = COVID-19 vaccination service; period = 2021-06-17 09:20:00+1000 --> 2021-06-17 09:35:00+1000](Encounter-covid-admin-1.md)

**occurrence**: 2021-06-17

**recorded**: 2021-06-17

**primarySource**: true

**location**: [Location Tindal Building](Location-bobrester-medical-center.md)

**manufacturer**: Pfizer Australia Ltd

**lotNumber**: 200000000P

**site**: Left upper arm



## Resource Content

```json
{
  "resourceType" : "Immunization",
  "id" : "covid-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization"
    ]
  },
  "status" : "completed",
  "vaccineCode" : {
    "coding" : [
      {
        "system" : "https://www.humanservices.gov.au/organisations/health-professionals/enablers/air-vaccine-code-formats",
        "code" : "COMIRN"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "1525011000168107",
        "display" : "Comirnaty"
      }
    ],
    "text" : "Pfizer Comirnaty"
  },
  "patient" : {
    "reference" : "Patient/bennelong-anne"
  },
  "encounter" : {
    "reference" : "Encounter/covid-admin-1"
  },
  "occurrenceDateTime" : "2021-06-17",
  "recorded" : "2021-06-17",
  "primarySource" : true,
  "location" : {
    "reference" : "Location/bobrester-medical-center"
  },
  "manufacturer" : {
    "display" : "Pfizer Australia Ltd"
  },
  "lotNumber" : "200000000P",
  "site" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "368208006",
        "display" : "Structure of left upper arm"
      }
    ],
    "text" : "Left upper arm"
  }
}

```
