# HealthcareService - CoreStrength Physiotherapy - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **HealthcareService - CoreStrength Physiotherapy**

## Example HealthcareService: HealthcareService - CoreStrength Physiotherapy

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core HealthcareService](StructureDefinition-au-core-healthcareservice.md)

**type**: Physiotherapy service

**name**: CoreStrength Physiotherapy

**telecom**: ph: 0755504444(Work), [reception@corestrength.example.org.](mailto:reception@corestrength.example.org.)



## Resource Content

```json
{
  "resourceType" : "HealthcareService",
  "id" : "physiotherapy",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-healthcareservice"
    ]
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "722140001",
          "display" : "Physiotherapy service"
        }
      ]
    }
  ],
  "name" : "CoreStrength Physiotherapy",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0755504444",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "reception@corestrength.example.org.",
      "use" : "work"
    }
  ]
}

```
