# Encounter - Discharge - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Encounter - Discharge**

## Example Encounter: Encounter - Discharge

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Encounter](StructureDefinition-au-core-encounter.md)

**status**: Finished

**class**: [ActCode: EMER](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-EMER) (emergency)

**subject**: [Ronny Lawrence Irvine Male, DoB: ( DVA Number: QX827261)](Patient-ronny-irvine.md)

**period**: 2023-02-20 06:15:00+1000 --> 2023-02-20 18:19:00+1000

### Locations

| | |
| :--- | :--- |
| - | **Location** |
| * | [Location Murrabit Public Hospital](Location-murrabit-hospital.md) |

**serviceProvider**: [Organization Murrabit Public Hospital](Organization-murrabit-hospital.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "discharge-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter"
    ]
  },
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "EMER",
    "display" : "emergency"
  },
  "subject" : {
    "reference" : "Patient/ronny-irvine"
  },
  "period" : {
    "start" : "2023-02-20T06:15:00+10:00",
    "end" : "2023-02-20T18:19:00+10:00"
  },
  "location" : [
    {
      "location" : {
        "reference" : "Location/murrabit-hospital"
      }
    }
  ],
  "serviceProvider" : {
    "reference" : "Organization/murrabit-hospital"
  }
}

```
