# Condition - Data suppressed for category and code - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Condition - Data suppressed for category and code**

## Example Condition: Condition - Data suppressed for category and code

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Condition](StructureDefinition-au-core-condition.md)

**clinicalStatus**: Active

**category**: Masked

**code**: Masked

**subject**: [Anne Bennelong](Patient-bennelong-anne.md)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "condition-masked",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-condition"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
          "code" : "masked"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
        "code" : "masked"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/bennelong-anne",
    "display" : "Anne Bennelong"
  }
}

```
