# Condition - Chronic Kidney Disease - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Condition - Chronic Kidney Disease**

## Example Condition: Condition - Chronic Kidney Disease

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Condition](StructureDefinition-au-core-condition.md)

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Problem

**code**: Chronic kidney disease

**subject**: [Ronny Lawrence Irvine Male, DoB: ( DVA Number: QX827261)](Patient-ronny-irvine.md)

**onset**: 52 years (Details: UCUM codea = 'a')

**recordedDate**: 2018-12-01

### Evidences

| | |
| :--- | :--- |
| - | **Detail** |
| * | [Patient receives regular dialysis](Procedure-dialysis.md) |



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "ckd",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-condition"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ],
    "text" : "Active"
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
          "code" : "problem-list-item",
          "display" : "Problem List Item"
        }
      ],
      "text" : "Problem"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "709044004",
        "display" : "Chronic kidney disease"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/ronny-irvine"
  },
  "onsetAge" : {
    "value" : 52,
    "unit" : "years",
    "system" : "http://unitsofmeasure.org",
    "code" : "a"
  },
  "recordedDate" : "2018-12-01",
  "evidence" : [
    {
      "detail" : [
        {
          "reference" : "Procedure/dialysis",
          "display" : "Patient receives regular dialysis"
        }
      ]
    }
  ]
}

```
