# AllergyIntolerance - Penicillin allergy - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AllergyIntolerance - Penicillin allergy**

## Example AllergyIntolerance: AllergyIntolerance - Penicillin allergy

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md)

**clinicalStatus**: Active

**criticality**: High Risk

**code**: Penicillin

**patient**: [Deangelo HOWE Male, DoB: 1975-06-21 ( IHI: Austalian Healthcare Identifier - Individual#8003608000311621)](Patient-howe-deangelo.md)

**recordedDate**: 1999-08-25

**note**: 

> 

The criticality is high due to a documented episode of hives following penicillin administration.


### Reactions

| | |
| :--- | :--- |
| - | **Manifestation** |
| * | Hives |



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "penicillin",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "criticality" : "high",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "764146007",
        "display" : "Penicillin"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/howe-deangelo"
  },
  "recordedDate" : "1999-08-25",
  "note" : [
    {
      "text" : "The criticality is high due to a documented episode of hives following penicillin administration."
    }
  ],
  "reaction" : [
    {
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "247472004",
              "display" : "Hives"
            }
          ]
        }
      ]
    }
  ]
}

```
