# Sex and Gender - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Guidance**](guidance.md)
* **Sex and Gender**

## Sex and Gender

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This page addresses how sex and gender related concepts can be structured in FHIR and conformant to AU Core.

AU Core places **Must Support** on some concepts and inherits sex and gender related elements localised in AU Base, which has considered and adopted the logical data element models provided by [HL7 International’s Cross Paradigm Implementation Guide: Gender Harmony - Sex and Gender Representation, Edition 1 specification (Gender Harmony IG)](https://hl7.org/xprod/ig/uv/gender-harmony/informative1/).

The table below provides an overview of the sex and gender concepts that are included in AU Core by definition, or by inheritance from AU Base.

**Legend:**

![](green_checkmark.png) **Supported**: The sex or gender related concept is marked as **Must Support**.

![](orange_checkmark.png) **Localised**: The sex or gender related concept is localised for use in an Australian context but is not marked as **Must Support**.

![](blue_checkmark.png) **Not Localised**: The sex or gender related concept is relevant and not yet localised for use in an Australian context.

![](minus_symbol.png) **Not Applicable**: This sex or gender related concept is not applicable for use with this resource type.

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [AU CorePatient](StructureDefinition-au-core-patient.md) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Practitioner](StructureDefinition-au-core-practitioner.md) | ![](blue_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) |
| [AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md) | ![](blue_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) |
| [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) |
| [AU Core Procedure](StructureDefinition-au-core-procedure.md) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) |

### Administrative Gender (Patient.gender)

AU Core supports the exchange of Administrative Gender, i.e. the basic `Patient.gender` property, as a **Must Support** element in [AU Core Patient](StructureDefinition-au-core-patient.md). As per AU Base, the `Patient.gender` value **SHALL** be regarded as a Recorded Sex or Gender. AU Core adopts without change, the implementation guidance defined in the [Administrative Gender (Patient.gender)](https://hl7.org.au/fhir/6.0.0/sexgender.html#administrative-gender-patientgender) section of the AU Base [Sex and Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html) page.

### Name to Use (NtU)

AU Core supports the exchange of the Name to Use data element (as defined in the [HL7 Gender Harmony IG](https://hl7.org/xprod/ig/uv/gender-harmony/informative1/)), `name.use` is a **Must Support** element in [AU Core Patient](StructureDefinition-au-core-patient.md) and [AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md). It is important to note that, `name.period` is not a **Must Support** element. AU Core adopts without change, the implementation guidance defined in the [Name to Use (NtU)](https://hl7.org.au/fhir/6.0.0/sexgender.html#name-to-use-ntu) section of the AU Base [Sex and Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html) page.

### Pronouns​

AU Core supports the exchange of the Pronouns data element (as defined in the [HL7 Gender Harmony IG](https://hl7.org/xprod/ig/uv/gender-harmony/informative1/)), the [Individual Pronouns](http://hl7.org/fhir/StructureDefinition/individual-pronouns) extension is a **Must Support** element in [AU Core Patient](StructureDefinition-au-core-patient.md), with the value element of the extension constrained to be [Australian Pronouns](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/australian-pronouns-1) ([extensible](http://hl7.org/fhir/R4/terminologies.html#extensible)). AU Core adopts without change, the implementation guidance defined in the [Pronouns](https://hl7.org.au/fhir/6.0.0/sexgender.html#pronouns) section of the AU Base [Sex and Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html) page.

### Gender Identity (GI)

AU Core supports the exchange of the Gender Identity data element (as defined in the [HL7 Gender Harmony IG](https://hl7.org/xprod/ig/uv/gender-harmony/informative1/)), the [Individual Gender Identity](http://hl7.org/fhir/StructureDefinition/individual-genderIdentity) extension is a **Must Support** element in [AU Core Patient](StructureDefinition-au-core-patient.md), with the value element of the extension constrained to be [Gender Identity Response](https://healthterminologies.gov.au/fhir/ValueSet/gender-identity-response-1) ([extensible](http://hl7.org/fhir/R4/terminologies.html#extensible)). AU Core adopts without change, the implementation guidance defined in the [Gender Identity (GI)](https://hl7.org.au/fhir/6.0.0/sexgender.html#gender-identity-gi) section of the AU Base [Sex and Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html) page.

### Recorded Sex or Gender

In AU Core, Recorded Sex or Gender is not **Must Support**. See the implementation guidance defined in the [Recorded Sex or Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html#recorded-sex-or-gender) section of the AU Base [Sex and Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html) page for more information.

### Sex Assigned at Birth

Implementers are advised that [AU Core Sex Assigned At Birth](StructureDefinition-au-core-rsg-sexassignedab.md) is under consideration for *Must Support* in AU Core. Input is welcome, please see [FHIR-44857](https://jira.hl7.org/browse/FHIR-44857).

In AU Core, Sex Assigned at Birth is profiled as [AU Core Sex Assigned At Birth](StructureDefinition-au-core-rsg-sexassignedab.md). While elements within AU Core Sex Assigned at Birth are **Must Support**, usage of the profile is not **Must Support** in [AU Core Patient](StructureDefinition-au-core-patient.md). That profile provides an implementation of the guidance in the [Sex Assigned at Birth](https://hl7.org.au/fhir/6.0.0/sexgender.html#sex-assigned-at-birth) section of the AU Base [Sex and Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html) page.

### Sex Parameter for Clinical Use (SPCU)

In AU Core, SPCU is not **Must Support**. See the implementation guidance defined in the [Sex Parameter for Clinical Use (SPCU)](https://hl7.org.au/fhir/6.0.0/sexgender.html#sex-parameter-for-clinical-use-spcu) section of the AU Base [Sex and Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html) page for more information.

