# Profiles and Extensions - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* **Profiles and Extensions**

## Profiles and Extensions

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Profiles

The following profiles have been defined for this implementation guide.

#### AllergyIntolerance

* [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md)

#### Condition

* [AU Core Condition](StructureDefinition-au-core-condition.md)

#### Encounter

* [AU Core Encounter](StructureDefinition-au-core-encounter.md)

#### HealthcareService

* [AU Core HealthcareService](StructureDefinition-au-core-healthcareservice.md)

#### Immunization

* [AU Core Immunization](StructureDefinition-au-core-immunization.md)

#### Location

* [AU Core Location](StructureDefinition-au-core-location.md)

#### Medication

* [AU Core Medication](StructureDefinition-au-core-medication.md)

#### MedicationRequest

* [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md)

#### MedicationStatement

* [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md)

#### Observation

* [AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md)
* [AU Core Body Height](StructureDefinition-au-core-bodyheight.md)
* [AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md)
* [AU Core Body Weight](StructureDefinition-au-core-bodyweight.md)
* [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md)
* [AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md)
* [AU Core Heart Rate](StructureDefinition-au-core-heartrate.md)
* [AU Core Respiration Rate](StructureDefinition-au-core-resprate.md)
* [AU Core Smoking Status](StructureDefinition-au-core-smokingstatus.md)
* [AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md)

#### Organization

* [AU Core Organization](StructureDefinition-au-core-organization.md)

#### Patient

* [AU Core Patient](StructureDefinition-au-core-patient.md)

#### Practitioner

* [AU Core Practitioner](StructureDefinition-au-core-practitioner.md)

#### PractitionerRole

* [AU Core PractitionerRole](StructureDefinition-au-core-practitionerrole.md)

#### Procedure

* [AU Core Procedure](StructureDefinition-au-core-procedure.md)

#### RelatedPerson

* [AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md)

#### Extension

* [AU Core Sex Assigned At Birth](StructureDefinition-au-core-rsg-sexassignedab.md)

### Extensions

All extensions used in this guide are defined in the FHIR Extensions Pack or [AU Base](https://hl7.org.au/fhir/6.0.0/profiles-and-extensions.html#extensions).

The following extensions are marked with **Must Support** in this implementation guide:

* [Australian Indigenous Status](https://hl7.org.au/fhir/6.0.0/StructureDefinition-indigenous-status.html) in [AU Core Patient](StructureDefinition-au-core-patient.md)
* [Individual Pronouns](http://hl7.org/fhir/StructureDefinition/individual-pronouns) in [AU Core Patient](StructureDefinition-au-core-patient.md)
* [Individual Gender Identity](http://hl7.org/fhir/StructureDefinition/individual-genderIdentity) in [AU Core Patient](StructureDefinition-au-core-patient.md)

