# hl7.fhir.au.core#2.0.0: AU Core Implementation Guide

## Pages

* [Home](index.md)
* [AU Core Responder](ActorDefinition-au-core-actor-responder.md)
* [AU Core Responder - Testing](ActorDefinition-au-core-actor-responder-testing.md)
* [Declaring Conformance](declaring-conformance.md)
* [Security and Privacy](security.md)
* [AU Core Requester - XML Representation](ActorDefinition-au-core-actor-requester.xml.md)
* [Guidance](guidance.md)
* [Profiles and Extensions](profiles-and-extensions.md)
* [AU Variance Statement](variance.md)
* [AU Core Responder - XML Representation](ActorDefinition-au-core-actor-responder.xml.md)
* [AU Core Requester - JSON Representation](ActorDefinition-au-core-actor-requester.json.md)
* [Support](support.md)
* [Future of AU Core](future.md)
* [AUCDI](aucdi.md)
* [Downloads](downloads.md)
* [Conformance](conformance.md)
* [Search Parameters](search-parameters.md)
* [License and Legal](license.md)
* [Change Log](changes.md)
* [AU Core Requester](ActorDefinition-au-core-actor-requester.md)
* [Terminology](terminology.md)
* [Artefacts Summary](artifacts.md)
* [AU Core Requester - Testing](ActorDefinition-au-core-actor-requester-testing.md)
* [AU Core Requester - TTL Representation](ActorDefinition-au-core-actor-requester.ttl.md)
* [Actor Definitions](actors.md)
* [Comparison With Other National and International IGs](comparison.md)
* [AU Core Responder - TTL Representation](ActorDefinition-au-core-actor-responder.ttl.md)
* [AU Core Responder - JSON Representation](ActorDefinition-au-core-actor-responder.json.md)
* [Examples](examples.md)
* [FHIR Artefacts](fhirartefacts.md)
* [Capability Statements](capability-statements.md)
* [](ActorDefinition-au-core-actor-responder.change.history.md)
* [Sex and Gender](sex-and-gender.md)
* [Relationship With Other IGs](relationship.md)
* [General Guidance](general-guidance.md)
* [Medicine Information](medicine-information.md)
* [](ActorDefinition-au-core-actor-requester.change.history.md)
* [General Requirements](general-requirements.md)

## Resources

### Resource Profiles

* [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md)
* [AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md)
* [AU Core Body Height](StructureDefinition-au-core-bodyheight.md)
* [AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md)
* [AU Core Body Weight](StructureDefinition-au-core-bodyweight.md)
* [AU Core Condition](StructureDefinition-au-core-condition.md)
* [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md)
* [AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md)
* [AU Core Encounter](StructureDefinition-au-core-encounter.md)
* [AU Core HealthcareService](StructureDefinition-au-core-healthcareservice.md)
* [AU Core Heart Rate](StructureDefinition-au-core-heartrate.md)
* [AU Core Immunization](StructureDefinition-au-core-immunization.md)
* [AU Core Location](StructureDefinition-au-core-location.md)
* [AU Core Medication](StructureDefinition-au-core-medication.md)
* [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md)
* [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md)
* [AU Core Organization](StructureDefinition-au-core-organization.md)
* [AU Core Patient](StructureDefinition-au-core-patient.md)
* [AU Core Practitioner](StructureDefinition-au-core-practitioner.md)
* [AU Core PractitionerRole](StructureDefinition-au-core-practitionerrole.md)
* [AU Core Procedure](StructureDefinition-au-core-procedure.md)
* [AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md)
* [AU Core Respiration Rate](StructureDefinition-au-core-resprate.md)
* [AU Core Smoking Status](StructureDefinition-au-core-smokingstatus.md)
* [AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md)

### Extensions

* [AU Core Sex Assigned At Birth](StructureDefinition-au-core-rsg-sexassignedab.md)

### Basics

* [au-core-actor-requester](Basic-au-core-actor-requester.md)
* [au-core-actor-responder](Basic-au-core-actor-responder.md)

### CapabilityStatements

* [AU Core Requester CapabilityStatement](CapabilityStatement-au-core-requester.md)
* [AU Core Responder CapabilityStatement](CapabilityStatement-au-core-responder.md)

### ImplementationGuides

* [AU Core Implementation Guide](index.md)

### SearchParameters

* [AUCoreClinicalPatient](SearchParameter-au-core-clinical-patient.md)
* [AUCorePractitionerRolePractitioner](SearchParameter-au-core-practitionerrole-practitioner.md)

### Examples

* [lactose (AllergyIntolerance)](AllergyIntolerance-lactose.md)
* [noneknown (AllergyIntolerance)](AllergyIntolerance-noneknown.md)
* [penicillin (AllergyIntolerance)](AllergyIntolerance-penicillin.md)
* [ckd (Condition)](Condition-ckd.md)
* [condition-masked (Condition)](Condition-condition-masked.md)
* [noknown (Condition)](Condition-noknown.md)
* [uti (Condition)](Condition-uti.md)
* [covid-admin-1 (Encounter)](Encounter-covid-admin-1.md)
* [discharge-1 (Encounter)](Encounter-discharge-1.md)
* [telehealth (Encounter)](Encounter-telehealth.md)
* [Murrabit Crisis Hotline (HealthcareService)](HealthcareService-murrabit-crisis-hotline.md)
* [CoreStrength Physiotherapy (HealthcareService)](HealthcareService-physiotherapy.md)
* [covid-1 (Immunization)](Immunization-covid-1.md)
* [zoster-notgiven (Immunization)](Immunization-zoster-notgiven.md)
* [Tindal Building (Location)](Location-bobrester-medical-center.md)
* [Murrabit Public Hospital (Location)](Location-murrabit-hospital.md)
* [Patient's home (Location)](Location-patient-home.md)
* [1active-ingredient (Medication)](Medication-1active-ingredient.md)
* [2active-ingredients (Medication)](Medication-2active-ingredients.md)
* [simvastatin (Medication)](Medication-simvastatin.md)
* [paracetamol-codeine (MedicationRequest)](MedicationRequest-paracetamol-codeine.md)
* [reaptan (MedicationRequest)](MedicationRequest-reaptan.md)
* [simvastatin (MedicationRequest)](MedicationRequest-simvastatin.md)
* [active-bisoprolol (MedicationStatement)](MedicationStatement-active-bisoprolol.md)
* [completed-bactrim (MedicationStatement)](MedicationStatement-completed-bactrim.md)
* [completed-chloramphenicol (MedicationStatement)](MedicationStatement-completed-chloramphenicol.md)
* [previous-use-diflucan (MedicationStatement)](MedicationStatement-previous-use-diflucan.md)
* [bloodpressure-1 (Observation)](Observation-bloodpressure-1.md)
* [bloodpressure-data-absent (Observation)](Observation-bloodpressure-data-absent.md)
* [bodyheight-1 (Observation)](Observation-bodyheight-1.md)
* [bodytemp-1 (Observation)](Observation-bodytemp-1.md)
* [bodyweight-1 (Observation)](Observation-bodyweight-1.md)
* [hearing-threshold-1 (Observation)](Observation-hearing-threshold-1.md)
* [heartrate-1 (Observation)](Observation-heartrate-1.md)
* [lipid-hdl-1 (Observation)](Observation-lipid-hdl-1.md)
* [lipid-ldl-1 (Observation)](Observation-lipid-ldl-1.md)
* [lipid-total-chol-1 (Observation)](Observation-lipid-total-chol-1.md)
* [lipid-triglyceride-1 (Observation)](Observation-lipid-triglyceride-1.md)
* [observation-masked (Observation)](Observation-observation-masked.md)
* [pathresult-covid-1 (Observation)](Observation-pathresult-covid-1.md)
* [pulserate-1 (Observation)](Observation-pulserate-1.md)
* [resprate-1 (Observation)](Observation-resprate-1.md)
* [smokingstatus-current-smoker (Observation)](Observation-smokingstatus-current-smoker.md)
* [waistcircum-1 (Observation)](Observation-waistcircum-1.md)
* [Bobrester Medical Center (Organization)](Organization-bobrester-medical-center.md)
* [Mitchells Hill Audiology (Organization)](Organization-mitchells-hill-audiology.md)
* [Murrabit Public Hospital (Organization)](Organization-murrabit-hospital.md)
* [banks-mia-leanne (Patient)](Patient-banks-mia-leanne.md)
* [bennelong-anne (Patient)](Patient-bennelong-anne.md)
* [howe-deangelo (Patient)](Patient-howe-deangelo.md)
* [ronny-irvine (Patient)](Patient-ronny-irvine.md)
* [wang-li (Patient)](Patient-wang-li.md)
* [bobrester-bob (Practitioner)](Practitioner-bobrester-bob.md)
* [chau-fryer (Practitioner)](Practitioner-chau-fryer.md)
* [darleen-mackay (Practitioner)](Practitioner-darleen-mackay.md)
* [sallie-sutherland (Practitioner)](Practitioner-sallie-sutherland.md)
* [bobrester-bob-gp (PractitionerRole)](PractitionerRole-bobrester-bob-gp.md)
* [cardiologist-sallie-sutherland (PractitionerRole)](PractitionerRole-cardiologist-sallie-sutherland.md)
* [nephrologist-darleen-mackay (PractitionerRole)](PractitionerRole-nephrologist-darleen-mackay.md)
* [surgeon-chau-fryer (PractitionerRole)](PractitionerRole-surgeon-chau-fryer.md)
* [dialysis (Procedure)](Procedure-dialysis.md)
* [stentinsertion (Procedure)](Procedure-stentinsertion.md)
* [banks-mia-leanne-father (RelatedPerson)](RelatedPerson-banks-mia-leanne-father.md)
* [wang-li-friend (RelatedPerson)](RelatedPerson-wang-li-friend.md)
* [nasoswab (Specimen)](Specimen-nasoswab.md)
