# Examples - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Examples**

## Examples

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

The following examples are published with this guide and all are available as a downloadable zip file [here](downloads.md#examples).

These example instances show what data produced and consumed by systems conforming with this implementation guide might look like. Every effort has been made to ensure that the examples are correct and useful, but they are not a normative part of the specification nor are they fully representative of real world examples.

In addition to the examples defined in this implementation, synthetic (realistic but not real) test data for developers and testers that conforms to HL7 Australia FHIR implementation guides is maintained in the [HL7 AU FHIR Test Data](https://github.com/hl7au/au-fhir-test-data) repository.

### AllergyIntolerance

* [AllergyIntolerance - Lactose intolerance](AllergyIntolerance-lactose.md)

* [AllergyIntolerance - No known allergy](AllergyIntolerance-noneknown.md)

* [AllergyIntolerance - Penicillin allergy](AllergyIntolerance-penicillin.md)

### Condition

* [Condition - Chronic Kidney Disease](Condition-ckd.md)

* [Condition - Data suppressed for category and code](Condition-condition-masked.md)

* [Condition - No known condition](Condition-noknown.md)

* [Condition - Urinary tract infection](Condition-uti.md)

### Encounter

* [Encounter - COVID 19 Vaccine Administration Dose 1](Encounter-covid-admin-1.md)

* [Encounter - Discharge](Encounter-discharge-1.md)

* [Encounter - telehealth](Encounter-telehealth.md)

### HealthcareService

* [HealthcareService - Murrabit Crisis Hotline](HealthcareService-murrabit-crisis-hotline.md)

* [HealthcareService - CoreStrength Physiotherapy](HealthcareService-physiotherapy.md)

### Immunization

* [Immunization - COVID Dose 1](Immunization-covid-1.md)

* [Immunization - Administration of Zoster vaccination refused](Immunization-zoster-notgiven.md)

### Location

* [Location - Tindal Building](Location-bobrester-medical-center.md)

* [Location - Murrabit Public Hospital](Location-murrabit-hospital.md)

* [Location - Patient home](Location-patient-home.md)

### Medication

* [Medication - Branded pack with one active ingredient](Medication-1active-ingredient.md)

* [Medication - Product with two active ingredients](Medication-2active-ingredients.md)

* [Medication - Simvastatin 40 MG Disintegrating Oral Tablet](Medication-simvastatin.md)

### MedicationRequest

* [MedicationRequest - prescription, paracetamol 500 mg + codeine phosphate hemihydrate 30 mg](MedicationRequest-paracetamol-codeine.md)

* [MedicationRequest - active prescription, Reaptan](MedicationRequest-reaptan.md)

* [MedicationRequest - active prescription, Simvastatin](MedicationRequest-simvastatin.md)

### MedicationStatement

* [MedicationStatement - active use of Bisoprolol 2.5mg](MedicationStatement-active-bisoprolol.md)

* [MedicationStatement - completed use of Bactrim DS](MedicationStatement-completed-bactrim.md)

* [MedicationStatement - completed use of Chloramphenicol 1% eye ointment](MedicationStatement-completed-chloramphenicol.md)

* [MedicationStatement - patient has taken Diflucan in the past but is not taking it any more](MedicationStatement-previous-use-diflucan.md)

### Observation

* [Observation - Blood Pressure (systolic and diastolic)](Observation-bloodpressure-1.md)

* [Observation - Blood Pressure (data absent for diastolic)](Observation-bloodpressure-data-absent.md)

* [Observation - Height](Observation-bodyheight-1.md)

* [Observation - Temperature](Observation-bodytemp-1.md)

* [Observation - Body weight](Observation-bodyweight-1.md)

* [Observation - Hearing threshold Ear (left) 500 Hz](Observation-hearing-threshold-1.md)

* [Observation - Heart rate](Observation-heartrate-1.md)

* [Observation - HDL](Observation-lipid-hdl-1.md)

* [Observation - LDL](Observation-lipid-ldl-1.md)

* [Observation - Total Cholesterol/HDL ratio](Observation-lipid-total-chol-1.md)

* [Observation - Triglyceride](Observation-lipid-triglyceride-1.md)

* [Observation - Data suppressed for category, code, effective[x] and value[x]](Observation-observation-masked.md)

* [Observation - COVID Pathology Result (Not detected)](Observation-pathresult-covid-1.md)

* [Observation - Pulse rate](Observation-pulserate-1.md)

* [Observation - Respiration rate](Observation-resprate-1.md)

* [Observation - Current smoker](Observation-smokingstatus-current-smoker.md)

* [Observation - Waist Circumference](Observation-waistcircum-1.md)

### Organization

* [Organization - Bobrester Medical Centre](Organization-bobrester-medical-center.md)

* [Organization - Mitchells Hill Audiology](Organization-mitchells-hill-audiology.md)

* [Organization - Murrabit Public Hospital](Organization-murrabit-hospital.md)

### Patient

* [Patient - Mia Leanne Banks](Patient-banks-mia-leanne.md)

* [Patient - Mrs. Anne Bennelong](Patient-bennelong-anne.md)

* [Patient - Deangelo HOWE](Patient-howe-deangelo.md)

* [Patient - Ronny Lawrence Irvine](Patient-ronny-irvine.md)

* [Patient - Mr. Li Wang](Patient-wang-li.md)

### Practitioner

* [Practitioner - Dr. Bob Bobrester](Practitioner-bobrester-bob.md)

* [Practitioner - Dr. Chau FRYER](Practitioner-chau-fryer.md)

* [Practitioner - Darleen MACKAY](Practitioner-darleen-mackay.md)

* [Practitioner - Dr. Sallie Sutherland](Practitioner-sallie-sutherland.md)

### PractitionerRole

* [PractitionerRole - General practitioner](PractitionerRole-bobrester-bob-gp.md)

* [PractitionerRole - Cardiologist](PractitionerRole-cardiologist-sallie-sutherland.md)

* [PractitionerRole - Nephrologist](PractitionerRole-nephrologist-darleen-mackay.md)

* [PractitionerRole - Surgeon](PractitionerRole-surgeon-chau-fryer.md)

### Procedure

* [Procedure - Dialysis](Procedure-dialysis.md)

* [Procedure - Stent insertion](Procedure-stentinsertion.md)

### RelatedPerson

* [RelatedPerson - Father of Mia Leanne Banks](RelatedPerson-banks-mia-leanne-father.md)

* [RelatedPerson - Friend of Mr. Li Wang](RelatedPerson-wang-li-friend.md)

### Specimen

* [Specimen - Naso swab (COVID test)](Specimen-nasoswab.md)

### Extensions

* Sex Assigned at Birth: [Patient - Mia Leanne Banks](Patient-banks-mia-leanne.md)
* Individual Pronouns: [Patient - Mia Leanne Banks](Patient-banks-mia-leanne.md)
* Individual Gender Identity: [Patient - Mia Leanne Banks](Patient-banks-mia-leanne.md)

### Missing Data

* [Patient - Mr. Ronny Irvine (missing data for birth date)](Patient-ronny-irvine.md)
* [MedicationRequest - prescription, paracetamol 500 mg + codeine phosphate hemihydrate 30 mg (missing data for status and requester)](MedicationRequest-paracetamol-codeine.md)

### Suppressed Data

* [Condition - Data suppressed for category and code](Condition-condition-masked.md)
* [Observation - Data suppressed for category, code and effectiveDate](Observation-observation-masked.md)

