# Downloads - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Support**](support.md)
* **Downloads**

## Downloads

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Downloadable Copy of Entire Specification

A downloadable version of the entire implementation guide as a website is available so it can be hosted locally.

It is not recommended to view locally without hosting, but you can extract the files and open the index.html file in a web browser. This will provide access to the table of contents, introduction, and navigation links to different sections of the implementation guide.

* [Downloadable Copy](full-ig.zip)

### Package File

The following package file includes an NPM package file used by many of the FHIR tools. It contains all the value sets, profiles, extensions, list of pages and urls in the IG, etc defined as part of this version of the Implementation Guides. This file should be the first choice whenever generating any implementation artefacts since it contains all of the rules about what makes the profiles valid. Implementers will still need to be familiar with the content of the specification and profiles that apply in order to make a conformant implementation:

* [R4 Package](package.tgz)
* [R4B Package](package.r4b.tgz)

See the overview on [validating FHIR profiles and resources](http://hl7.org/fhir/R4/validation.html) for more information about validating profiles and how to use these artefacts.

### Examples

All examples included in this implementation guide are available for download:

* [XML](examples.xml.zip)
* [JSON](examples.json.zip)
* [TTL](examples.ttl.zip)

### Consolidated CSV and Excel File Representations of Profiles

All the profile information for the AU Core Implementation Guide in a single CSV or Excel file, which may be helpful to testers and analysts to review element properties across profiles in a single table:

* [CSV(compressed folder)](csvs.zip)
* [Excel(compressed folder)](excels.zip)

### Implementation Guide Details

The following link to the ImplementationGuide resource defines the technical details of this publication, including dependencies and publishing parameters:

* [XML](ImplementationGuide-hl7.fhir.au.core.xml)
* [JSON](ImplementationGuide-hl7.fhir.au.core.json)
* [TTL](ImplementationGuide-hl7.fhir.au.core.ttl)

### OpenAPI (a.k.a., Swagger) Definition Files

The following [OpenAPI](https://www.openapis.org/) files are generated from the AU Core CapabilityStatements:

* [AU Core Responder](au-core-responder.openapi.json)
* [AU Core Requester](au-core-requester.openapi.json)

