# Comparison With Other National and International IGs - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Guidance**](guidance.md)
* **Comparison With Other National and International IGs**

## Comparison With Other National and International IGs

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

AU Core aligns to, and leverages, international standards and other national standards, in particular:

* [International Patient Access 1.1.0](https://hl7.org/fhir/uv/ipa/STU1.1/)
* [International Patient Summary Implementation Guide 2.0.0](https://hl7.org/fhir/uv/ips/STU2/)
* [US Core Implementation Guide 8.0.0](https://hl7.org/fhir/us/core/STU8/)

Relationships between AU Core, AUCDI, and the above key implementation guides is described in [Relationship with other IGs](relationship.md).

International Patient Access (IPA) and International Patient Summary (IPS) are specifically referenced, as many of the profiles defined in AU Core are expected in future to be adopted in Australian localisations of these international standards.

Corresponding profiles, conformance requirements, and capability statements included in the key FHIR implementation guides were reviewed and considered during AU Core's development to ensure alignment, and to facilitate adoption of, this standard.

The below comparison evaluates AU Core conformance requirements with the key implementation guides identifying where compliance with AU Core satisfies the expectations established by the referenced implementation guide.

### Profile Comparison

As part of profile comparison, the requirements, constraints, and standards specified in a particular FHIR profile are evaluated. These requirements can include mandatory elements, **Must Support** elements, cardinality constraints, data types, terminology bindings, usage rules, extensions, and rules on missing or suppressed data.

The table below provides a profile only comparison from AU Core to profiles in key implementation guides. Compliance in the reverse direction is not guaranteed, i.e. a resource that is compliant with an IPA profile **MAY NOT** be compliant with AU Core.

The comparison considers **SHALL** and **SHOULD** requirements. **MAY** requirements are not compared.

**Legend:**

![](green_checkmark.png) **Compliant**: An AU Core compliant resource meets all requirements of the compared profile.

![](orange_checkmark.png) **Additional requirements**: An AU Core compliant resource is compatible, but additional changes may be needed to meet all requirements of the compared profile. Where additional requirements are identified, more information is provided in the sections below.

![](cross_red_circle.png) **Incompatible**: An AU Core compliant resource is incompatible with the compared profile. A resource cannot be compliant to both. Where incompatible requirements are identified, more information is provided in the sections below.

![](minus_symbol.png) **No equivalent profile**: No equivalent profile for comparison.

| | | | |
| :--- | :--- | :--- | :--- |
| [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md) | ![](green_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Body Height](StructureDefinition-au-core-bodyheight.md) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Body Weight](StructureDefinition-au-core-bodyweight.md) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Condition](StructureDefinition-au-core-condition.md) | ![](green_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md) | ![](green_checkmark.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) |
| [AU Core Encounter](StructureDefinition-au-core-encounter.md) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) |
| [AU Core HealthcareService](StructureDefinition-au-core-healthcareservice.md) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) |
| [AU Core Heart Rate](StructureDefinition-au-core-heartrate.md) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Immunization](StructureDefinition-au-core-immunization.md) | ![](green_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Location](StructureDefinition-au-core-location.md) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) |
| [AU Core Medication](StructureDefinition-au-core-medication.md) | ![](green_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) |
| [AU Core Organization](StructureDefinition-au-core-organization.md) | ![](minus_symbol.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | ![](green_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Patient](StructureDefinition-au-core-patient.md) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Practitioner](StructureDefinition-au-core-practitioner.md) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core PractitionerRole](StructureDefinition-au-core-practitionerrole.md) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Procedure](StructureDefinition-au-core-procedure.md) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](green_checkmark.png) |
| [AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) |
| [AU Core Respiration Rate](StructureDefinition-au-core-resprate.md) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Smoking Status](StructureDefinition-au-core-smokingstatus.md) | ![](green_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) |
| [AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) |

#### IPA Profile Additional Requirements

The following IPA profile(s) contain additional requirements. Implementers are advised to note that some code changes may be required to support these profiles.

| | | | |
| :--- | :--- | :--- | :--- |
| [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md) | [IPA-MedicationRequest](https://hl7.org/fhir/uv/ipa/STU1.1//StructureDefinition-ipa-medicationrequest.html) | MedicationRequest.reported[x] | Element flagged as*Must Support*in IPA. |
| [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | [IPA-MedicationStatement](https://hl7.org/fhir/uv/ipa/STU1.1//StructureDefinition-ipa-medicationstatement.html) | MedicationStatement.statusReason | Element flagged as*Must Support*in IPA. |
| MedicationStatement.context | Element flagged as*Must Support*in IPA. | | |
| MedicationStatement.informationSource | Element flagged as*Must Support*in IPA. | | |
| [AU Core Patient](StructureDefinition-au-core-patient.md) | [IPA-Patient](https://hl7.org/fhir/uv/ipa/STU1.1//StructureDefinition-ipa-patient.html) | Patient.identifier | IPA requires all identifiers to have value (1..1), and at least one of system, type or assigner (ipa-pat-1). |
| Patient.identifier.value | Element flagged as*Must Support*in IPA. | | |
| Patient.name.text | Sub-element SHOULD be present (ipa-pat-3). | | |
| Patient.active | Element SHOULD be present if Patient.link is present (ipa-pat-4). Element flagged as*Must Support*in IPA. | | |
| Patient.link | Element flagged as*Must Support*in IPA. | | |
| [AU Core Practitioner](StructureDefinition-au-core-practitioner.md) | [IPA-Practitioner](https://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-practitioner.html) | Practitioner.name.text | Sub-element SHOULD be present (ipa-pract-1). |

##### Missing Data

AU Core compliant resources are compliant with IPA requirements for Missing Data.

##### Suppressed Data

IPA does not include requirements for Suppressed Data.

##### Additional Profiles

This version of AU Core has no equivalent profile for the following IPA profiles:

* IPA-DocumentReference

#### IPS Profile Additional Requirements

The following IPS profile(s) contain additional requirements. Implementers are advised to note that some code changes may be required to support these profiles.

| | | | |
| :--- | :--- | :--- | :--- |
| [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md) | [AllergyIntolerance (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-AllergyIntolerance-uv-ips.html) | AllergyIntolerance.patient.reference | IPS requires minimum of 1. Element flagged as*Must Support*in IPS. |
| AllergyIntolerance.type | Element flagged as*Must Support*in IPS. | | |
| AllergyIntolerance.clinicalStatus | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. | | |
| AllergyIntolerance.code | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. | | |
| AllergyIntolerance.reaction.manifestation | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. | | |
| [AU Core Condition](StructureDefinition-au-core-condition.md) | [Condition (IPS)](https://hl7.org/fhir/uv/ips/2024Sep/StructureDefinition-Condition-uv-ips.html) | Condition.subject.reference | IPS requires minimum of 1. Element flagged as*Must Support*in IPS. |
| Condition.clinicalStatus | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. | | |
| Condition.verificationStatus | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. | | |
| Condition.category | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. | | |
| Condition.severity | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. | | |
| Condition.code | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. | | |
| [AU Core Immunization](StructureDefinition-au-core-immunization.md) | [Immunization (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Immunization-uv-ips.html) | Immunization.vaccineCode | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. |
| Immunization.patient.reference | IPS requires minimum of 1. Element flagged as*Must Support*in IPS. | | |
| [AU Core Medication](StructureDefinition-au-core-medication.md) | [Medication (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Medication-uv-ips.html) | Medication.code | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. |
| Medication.form | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. Element flagged as*Must Support*in IPS. | | |
| Medication.ingredient | Element flagged as*Must Support*in IPS. | | |
| Medication.ingredient.item[x] | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. Element flagged as*Must Support*in IPS. | | |
| Medication.ingredient.strength | Element flagged as*Must Support*in IPS. | | |
| [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md) | [MedicationRequest (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-MedicationRequest-uv-ips.html) | MedicationRequest.subject.reference | IPS requires minimum of 1. Element flagged as*Must Support*in IPS. |
| MedicationRequest.medication[x] | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. | | |
| MedicationRequest.doNotPerform | IPS requires value 'false'. | | |
| MedicationRequest.dosageInstruction.timing | Element flagged as*Must Support*in IPS. | | |
| [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | [MedicationStatement (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-MedicationStatement-uv-ips.html) | MedicationStatement.medication[x] | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. |
| MedicationStatement.subject.reference | IPS requires minimum of 1. Element flagged as*Must Support*in IPS. | | |
| MedicationStatement.effective[x] | IPS requires minimum of 1. Type choice dateTime is flagged as*Must Support*in IPS. | | |
| MedicationStatement.dosage.timing | Element flagged as*Must Support*in IPS. | | |
| [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | [Observation Results - Laboratory/Pathology (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-results-laboratory-pathology-uv-ips.html) | Observation.status | IPS requires value from[Results Status Codes - IPS](https://hl7.org/fhir/uv/ips/STU2/ValueSet-results-status-uv-ips.html). |
| Observation.subject.reference | IPS requires minimum of 1. Element flagged as*Must Support*in IPS. | | |
| Observation.effective[x] | IPS prohibits types Timing and instant. Type dateTime is flagged as*Must Support*in IPS. | | |
| Observation.performer | IPS requires minimum of 1. | | |
| Observation.category | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. | | |
| Observation.code | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. | | |
| Observation.value[x] | Types string, Quantity and CodeableConceptIPS are flagged as*Must Support*in IPS. IPS preferred additional binding to[Results Coded Values Laboratory/Pathology - IPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-results-laboratory-pathology-uv-ips.html). | | |
| [AU Core Patient](StructureDefinition-au-core-patient.md) | [Patient (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Patient-uv-ips.html) | Patient.name | IPS does not allow Data Absent Reason extension (ips-pat-1). |
| Patient.generalPractitioner | Element flagged as*Must Support*in IPS. | | |
| [AU Core Practitioner](StructureDefinition-au-core-practitioner.md) | [Practitioner (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Practitioner-uv-ips.html) | Practitioner.telecom | Element flagged as*Must Support*in IPS. |
| Practitioner.address | Element flagged as*Must Support*in IPS. | | |
| [AU Core Procedure](StructureDefinition-au-core-procedure.md) | [Procedure (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Procedure-uv-ips.html) | Procedure.code | Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. |
| Procedure.subject.reference | IPS requires minimum of 1. Element flagged as*Must Support*in IPS. | | |
| Procedure.performed[x] | IPS requires minimum of 1. | | |
| [AU Core Smoking Status](StructureDefinition-au-core-smokingstatus.md) | [Observation Social History - Tobacco Use (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-tobaccouse-uv-ips.html) | Observation.subject.reference | IPS requires minimum of 1. Element flagged as*Must Support*in IPS. |
| Observation.code | IPS requires LOINC code 72166-2. Sub-elements of[CodeableConceptIPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-CodeableConcept-uv-ips.html)are flagged as*Must Support*. | | |
| Observation.component | Element prohibited in IPS. | | |

##### Missing Data

AU Core compliant resources are compliant with IPS requirements for Missing Data.

##### Suppressed Data

IPS does not include requirements for Suppressed Data.

##### Additional Profiles 

This version of AU Core has no equivalent profile for the following IPS profiles:

* Bundle (IPS)
* Composition (IPS)
* Device (IPS)
* Device - Performer or Observer (IPS)
* DeviceUseStatement (IPS)
* DiagnosticReport (IPS)
* Flag - Alert (IPS)
* ImagingStudy (IPS)
* Observation Pregnancy - Expected Delivery Date (IPS)
* Observation Pregnancy - Outcome (IPS)
* Observation Pregnancy- Status (IPS)
* Observation Results - Radiology (IPS)
* Observation Social History - Alcohol Use (IPS)
* Specimen (IPS)

#### US Core Profile Additional Requirements

The following US Core profile(s) contain additional requirements. Implementers are advised to note that some code changes may be required to support these profiles.

| | | | |
| :--- | :--- | :--- | :--- |
| [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md) | [US Core AllergyIntolerance Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-allergyintolerance.html) | AllergyIntolerance.code | US Core extensible binding to[Common substances for allergy and intolerance documentation including refutations](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1186.8/expansion). |
| AllergyIntolerance.manifestation | US Core extensible binding to[SNOMED CT Clinical Findings](https://hl7.org/fhir/R4/valueset-clinical-findings.html). | | |
| [AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md) | [US Core Blood Pressure Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-blood-pressure.html) | Observation.performer | Element flagged as*Must Support*in US Core. |
| Observation.code | US Core extensible binding to[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion). | | |
| Observation.value[x] | Type choice Quantity is flagged as*Must Support*in US Core. | | |
| [AU Core Body Height](StructureDefinition-au-core-bodyheight.md) | [US Core Body Height Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-body-height.html) | Observation.performer | Element flagged as*Must Support*in US Core. |
| Observation.code | US Core extensible binding to[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion). | | |
| Observation.component.code | US Core extensible binding to[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion). | | |
| Observation.component.value[x] | Type choice Quantity is flagged as*Must Support*in US Core. | | |
| [AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md) | [US Core Body Temperature Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-body-temperature.html) | Observation.performer | Element flagged as*Must Support*in US Core. |
| Observation.code | US Core extensible binding to[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion). | | |
| Observation.component.code | US Core extensible binding to[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion). | | |
| Observation.component.value[x] | Type choice Quantity is flagged as*Must Support*in US Core. | | |
| [AU Core Body Weight](StructureDefinition-au-core-bodyweight.md) | [US Core Body Weight Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-body-weight.html) | Observation.performer | Element flagged as*Must Support*in US Core. |
| Observation.code | US Core extensible binding to[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion). | | |
| Observation.component.code | US Core extensible binding to[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion). | | |
| Observation.component.value[x] | Type choice Quantity is flagged as*Must Support*in US Core. | | |
| [AU Core Condition](StructureDefinition-au-core-condition.md) | [US Core Condition Problems and Health Concerns Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-condition-problems-health-concerns.html) | Condition.category | US Core requires category of 'problem-list-item' or 'health-concern'. |
| Condition.meta | Element flagged as*Must Support*in US Core. | | |
| Condition.meta.lastUpdated | Sub-element flagged as*Must Support*in US Core. | | |
| Condition.assertedDate | Element flagged as*Must Support*in US Core. | | |
| Condition.abatement[x] | Type choice dateTime is flagged as*Must Support*in US Core. | | |
| Condition.recordedDate | Element flagged as*Must Support*in US Core. | | |
| [US Core Condition Encounter Diagnosis Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-condition-encounter-diagnosis.html) | Condition.encounter | Element flagged as*Must Support*in US Core. | |
| Condition.recordedDate | Element flagged as*Must Support*in US Core. | | |
| [AU Core Diagnostic Result Observation](StructureDefinition-au-core-allergyintolerance.md) | [US Core Observation Clinical Result Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-observation-clinical-result.html) | Observation.code | US Core extensible binding to[LOINC Codes](https://hl7.org/fhir/R4/valueset-observation-codes.html). |
| Observation.value[x] | US Core requires UCUM for coded quantity units (us-core-3). Type choices Quantity, CodeableConcept and string are flagged as*Must Support*in US Core. | | |
| Observation.encounter | Element flagged as*Must Support*in US Core. | | |
| Observation.effective[x] | Type choice dateTime is flagged as*Must Support*in US Core. | | |
| Observation.performer | Reference target Practitioner is flagged as*Must Support*in US Core. | | |
| [AU Core Encounter](StructureDefinition-au-core-encounter.md) | [US Core Encounter Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-encounter.html) | Encounter.type | US Core requires minimum of 1. Element flagged as*Must Support*in US Core. US Core extensible binding to[Encounter Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.23/expansion). |
| Encounter.meta | Element flagged as*Must Support*in US Core. | | |
| Encounter.meta.lastUpdated | Sub-element flagged as*Must Support*in US Core. | | |
| Encounter.identifier | US Core requires all identifiers to have system and value. Element flagged as*Must Support*in US Core. | | |
| Encounter.identifier.system | Sub-element flagged as*Must Support*in US Core. | | |
| Encounter.identifier.value | Sub-element flagged as*Must Support*in US Core. | | |
| Encounter.participant.period | Element flagged as*Must Support*in US Core. | | |
| Encounter.hospitalization | Element flagged as*Must Support*in US Core. | | |
| Encounter.hospitalization.dischargeDisposition | Element flagged as*Must Support*in US Core. | | |
| [AU Core Heart Rate](StructureDefinition-au-core-heartrate.md) | [US Core Heart Rate Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-heart-rate.html) | Observation.code | US Core extensible binding to[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion). |
| Observation.performer | Element flagged as*Must Support*in US Core. | | |
| Observation.component.code | US Core extensible binding to[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion). | | |
| Observation.component.value[x] | Sub-element flagged as*Must Support*in US Core. | | |
| [AU Core Immunization](StructureDefinition-au-core-immunization.md) | [US Core Immunization Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-immunization.html) | Immunization.vaccineCode | US Core extensible binding to[CVX Vaccines Administered Vaccine Set](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1010.6/expansion). |
| Immunization.statusReason | Element flagged as*Must Support*in US Core. | | |
| Immunization.encounter | Element flagged as*Must Support*in US Core. | | |
| Immunization.location | Element flagged as*Must Support*in US Core. | | |
| Immunization.performer | Element flagged as*Must Support*in US Core. | | |
| Immunization.performer.actor | Element flagged as*Must Support*in US Core. Reference target Practitioner is flagged as*Must Support*in US Core. | | |
| [AU Core Location](StructureDefinition-au-core-location.md) | [US Core Location Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-location.html) | Location.name | US Core requires minimum of 1. |
| Location.identifier | Element flagged as*Must Support*in US Core. | | |
| Location.status | Element flagged as*Must Support*in US Core. | | |
| Location.type | US Core extensible additional bindings to[Healthcare Service Location Type Combined](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.31/expansion)and[CMS Place of Service Codes (POS)](https://terminology.hl7.org/6.4.0/ValueSet-CMSPlaceOfServiceCodes.html). | | |
| Location.type.coding | US Core requires minimum of 1 and each coding to have system and code. Sub-element flagged as*Must Support*in US Core. | | |
| Location.type.coding.system | Sub-element flagged as*Must Support*in US Core. | | |
| Location.type.coding.code | Sub-element flagged as*Must Support*in US Core. | | |
| Location.telecom | Element flagged as*Must Support*in US Core. | | |
| Location.address.line | Sub-element flagged as*Must Support*in US Core. | | |
| Location.address.city | Sub-element flagged as*Must Support*in US Core. | | |
| Location.address.state | US Core extensible binding to[USPS Two Letter Alphabetic Codes](http://terminology.hl7.org/ValueSet/USPS-State). Sub-element flagged as*Must Support*in US Core. | | |
| Location.address.postalCode | Sub-element flagged as*Must Support*in US Core. | | |
| [AU Core Medication](StructureDefinition-au-core-medication.md) | [US Core Medication Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-medication.html) | Medication.code | US Core extensible binding to[Medication Clinical Drug](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1010.4/expansion). |
| [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md) | [US Core MedicationRequest Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-medicationrequest.html) | MedicationRequest.medicationCodeableConcept | US Core extensible binding to[Medication Clinical Drug](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1010.4/expansion). |
| MedicationRequest.category | Element flagged as*Must Support*in US Core. | | |
| MedicationRequest.reported[x] | Type choice boolean and reference target Practitioner are flagged as*Must Support*in US Core. Element flagged as*Must Support*in US Core. | | |
| MedicationRequest.requester | Reference target Practitioner is flagged as*Must Support*in US Core. | | |
| MedicationRequest.reasonCode | US Core extensible binding to[US Core Condition Codes](https://www.hl7.org/fhir/us/core/ValueSet-us-core-condition-code.html). | | |
| MedicationRequest.dosageInstruction.timing | Sub-element flagged as*Must Support*in US Core. | | |
| MedicationRequest.dosageInstruction.route | US Core extensible binding to[Route of Administration of Therapeutic Agents](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.22/expansion). Sub-element flagged as*Must Support*in US Core. | | |
| MedicationRequest.dosageInstruction.doseAndRate | Sub-element flagged as*Must Support*in US Core. | | |
| MedicationRequest.dosageInstruction.doseAndRate.dose[x] | Type choice Quantity is flagged as*Must Support*in US Core. Sub-element flagged as*Must Support*in US Core. | | |
| MedicationRequest.dispenseRequest | Element flagged as*Must Support*in US Core. | | |
| MedicationRequest.dispenseRequest.numberOfRepeatsAllowed | Element flagged as*Must Support*in US Core. | | |
| MedicationRequest.dispenseRequest.quantity | Element flagged as*Must Support*in US Core. | | |
| [AU Core Organization](StructureDefinition-au-core-organization.md) | [US Core Organization Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-organization.html) | Organization.active | US Core requires minimum of 1. Element flagged as*Must Support*in US Core. |
| Organization.identifier | Sub-elements flagged as*Must Support*in US Core. | | |
| Organization.address.line | US Core allows maximum of 4. Sub-element flagged as*Must Support*in US Core. | | |
| Organization.address.city | Sub-element flagged as*Must Support*in US Core. | | |
| Organization.address.state | US Core extensible binding to[USPS Two Letter Alphabetic Codes](http://terminology.hl7.org/ValueSet/USPS-State). Sub-element flagged as*Must Support*in US Core. | | |
| Organization.address.postalCode | Sub-element flagged as*Must Support*in US Core. | | |
| Organization.address.country | Sub-element flagged as*Must Support*in US Core. | | |
| [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | [US Core Laboratory Result Observation Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-observation-lab.html) | Observation.code | US Core extensible binding to[US Core Laboratory Test Codes](https://hl7.org/fhir/us/core/STU8/ValueSet-us-core-laboratory-test-codes.html). |
| Observation.referenceRange | US Core requires UCUM for coded quantity units (us-core-22). | | |
| Observation.meta | Element flagged as*Must Support*in US Core. | | |
| Observation.meta.lastUpdated | Sub-element flagged as*Must Support*in US Core. | | |
| Observation.encounter | Element flagged as*Must Support*in US Core. | | |
| Observation.performer | Reference target Practitioner is flagged as*Must Support*in US Core. | | |
| Observation.effective | Type choice dateTime flagged as*Must Support*in US Core. | | |
| Observation.value[x] | US Core requires UCUM for coded quantity units (us-core-3). Type choices Quantity, CodeableConcept and string are flagged as*Must Support*in US Core. | | |
| [AU Core Patient](StructureDefinition-au-core-patient.md) | [US Core Patient Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-patient.html) | Patient.identifier | US Core requires all identifiers to have system and value. |
| Patient.identifier.system | Sub-element flagged as*Must Support*in US Core. | | |
| Patient.identifier.value | Sub-element flagged as*Must Support*in US Core. | | |
| Patient.name | US Core requires all name to have family or given or Data Absent Reason extension (us-core-6). | | |
| Patient.telecom | US Core requires all telecom to have system and value. | | |
| Patient.address.line | Sub-element flagged as*Must Support*in US Core. | | |
| Patient.address.city | Sub-element flagged as*Must Support*in US Core. | | |
| Patient.address.state | US Core extensible binding to[USPS Two Letter Alphabetic Codes](https://terminology.hl7.org/6.4.0/ValueSet-USPS-State.html). Sub-element flagged as*Must Support*in US Core. | | |
| Patient.address.postalCode | Sub-element flagged as*Must Support*in US Core. | | |
| [AU Core Practitioner](StructureDefinition-au-core-practitioner.md) | [US Core Practitioner Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-practitioner.html) | Practitioner.identifier | US Core requires minimum of 1, and all identifiers to have system and value. |
| Practitioner.identifier.system | Sub-element flagged as*Must Support*in US Core. | | |
| Practitioner.identifier.value | Sub-element flagged as*Must Support*in US Core. | | |
| Practitioner.telecom | Element flagged as*Must Support*in US Core. | | |
| Practitioner.telecom.system | Sub-element flagged as*Must Support*in US Core. | | |
| Practitioner.telecom.value | Sub-element flagged as*Must Support*in US Core. | | |
| Practitioner.address | Element flagged as*Must Support*in US Core. | | |
| Practitioner.address.line | US Core allows maximum of 4. Sub-element flagged as*Must Support*in US Core. | | |
| Practitioner.address.city | Sub-element flagged as*Must Support*in US Core. | | |
| Practitioner.address.state | US Core extensible binding to[USPS Two Letter Alphabetic Codes](http://terminology.hl7.org/ValueSet/USPS-State). Sub-element flagged as*Must Support*in US Core. | | |
| Practitioner.address.postalCode | Sub-element flagged as*Must Support*in US Core. | | |
| Practitioner.address.country | Sub-element flagged as*Must Support*in US Core. | | |
| [AU Core PractitionerRole](StructureDefinition-au-core-practitionerrole.md) | [US Core PractitionerRole Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-practitionerrole.html) | PractitionerRole.telecom, PractitionerRole.endpoint | US Core requires telecom or endpoint to be present (pd-1). |
| PractitionerRole.location | Element flagged as*Must Support*in US Core. | | |
| PractitionerRole.telecom | US Core requires all telecom to have system and value. | | |
| PractitionerRole.endpoint | Element flagged as*Must Support*in US Core. | | |
| PractitionerRole.code | US Core extensible binding to[Care Team Member Function](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1099.30/expansion). | | |
| PractitionerRole.specialty | US Core extensible binding to[Healthcare Provider Taxonomy](https://vsac.nlm.nih.gov/valueset/2.16.840.1.114222.4.11.1066/expansion). | | |
| [AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md) | [US Core RelatedPerson Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-relatedperson.html) | RelatedPerson.active | US Core requires minimum of 1. Element flagged as*Must Support*in US Core. |
| [AU Core Respiration Rate](StructureDefinition-au-core-resprate.md) | [US Core Respiratory Rate Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-respiratory-rate.html) | Observation.code | US Core extensible binding to[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion). |
| Observation.performer | Element flagged as*Must Support*in US Core. | | |
| Observation.component.code | US Core extensible binding to[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion). | | |
| Observation.component.value[x] | Sub-element flagged as*Must Support*in US Core. | | |
| [AU Core Smoking Status](StructureDefinition-au-core-smokingstatus.md) | [US Core Smoking Status Observation Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-smokingstatus.html) | Observation.status | US Core requires status of 'final' or 'entered-in-error'. |
| Observation.code | US Core extensible binding to[Smoking Status Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.6/expansion). | | |
| Observation.performer | Element flagged as*Must Support*in US Core. Reference target Practitioner is flagged as*Must Support*in US Core. | | |
| Observation.value[x] | US core requires minimum of 1. | | |
| Observation.value[x]:valueCodeableConcept | US Core extensible binding to[Smoking status comprehensive](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.3/expansion). | | |
| Observation.value[x]:valueQuantity | This US Core profile supports capture of tobacco smoking consumption as well as smoking status; AU Core does not. An instantiation of Tobacco smoking consumption is considered an 'additional profile' not an additional requirement. | | |
| [AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md) | [US Core Vital Signs Profile](https://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-simple-observation.html) | Observation.performer | Element flagged as*Must Support*in US Core. |
| Observation.code | US Core extensible binding to[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion). | | |
| Observation.component.value[x] | Type choice Quantity is flagged as*Must Support*in US Core. | | |
| Observation.component.code | US Core extensible binding to[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion). | | |

##### Missing Data

AU Core compliant resources are compliant with US Core requirements for Missing Data.

##### Suppressed Data

AU Core compliant resources are compliant with US Core requirements for Suppressed Data.

##### Additional Profiles 

This version of AU Core has no equivalent profile for the following US Core profiles:

* US Core CarePlan Profile
* US Core CareTeam Profile
* US Core Coverage Profile
* US Core Implantable Device Profile
* US Core DiagnosticReport Profile for Laboratory Results Reporting Profile
* US Core DiagnosticReport Profile for Report and Note Exchange Profile
* US Core ADI DocumentReference Profile
* US Core DocumentReference Profile
* US Core Goal Profile
* US Core MedicationDispense Profile
* US Core Average Blood Pressure Profile
* US Core BMI Profile
* US Core Care Experience Preference Profile
* US Core Observation ADI Document Profile
* US Core Observation Occupation Profile
* US Core Observation Pregnancy Intent Profile
* US Core Observation Pregnancy Status Profile
* US Core Observation Screening Assessment Profile
* US Core Observation Sexual Orientation Profile
* US Core Pediatric BMI for Age Observation Profile
* US Core Pediatric Head Occipital Frontal Circumference Percentile Profile
* US Core Pediatric Weight for Height Observation Profile
* US Core Pulse Oximetry Profile
* US Core Simple Observation Profile
* US Core Treatment Intervention Preference Profile
* US Core Provenance Profile
* US Core QuestionnaireResponse Profile
* US Core ServiceRequest Profile
* US Core Specimen Profile

### Capability Statement Comparison

As part of the comparison, both system and resource level capabilities are compared, including FHIR version, supported formats and guides, conformance expectations, RESTful interactions, security, resource types and profiles, search parameters, reference handling, and operations.

#### CapabilityStatement Mapping

AU Core defines capability statements that describe the conformance requirements and expectations of a corresponding AU Core system actor:

* AU Core Requester - a system that creates and initiates a data access request to retrieve core digital health and administrative information
* AU Core Responder - a system that receives and responds to data access requests from AU Core Requesters

The table below provides a mapping of AU Core capability statements to capability statements in IPA, IPS, or US Core. A capability statement is considered mapped where the corresponding actor serves a similar role and purpose.

**Legend:**

![](minus_symbol.png) **No similar capability statement**: No similar actor in terms of role and purpose is defined.

| | | | |
| :--- | :--- | :--- | :--- |
| [AU Core Requester](CapabilityStatement-au-core-requester.md) | [IPA Client](https://hl7.org/fhir/uv/ipa/STU1.1/CapabilityStatement-ipa-client.html) | ![](minus_symbol.png) | [US Core Client](https://hl7.org/fhir/us/core/STU8/CapabilityStatement-us-core-client.html) |
| [AU Core Responder](CapabilityStatement-au-core-responder.md) | [IPA Server](https://hl7.org/fhir/uv/ipa/STU1.1/CapabilityStatement-ipa-server.html) | ![](minus_symbol.png)1([IPS Server](https://hl7.org/fhir/uv/ips/STU2/CapabilityStatement-ips-server.html)) | [US Core Server](https://hl7.org/fhir/us/core/STU8/CapabilityStatement-us-core-server.html) |

**1The IPS Server CapabilityStatement is not directly comparable as the role and purpose is inexact; the IPS server actor overlaps with the AU Core Responder actor, but actors cover additional meaning.**

#### CapabilityStatement Comparison

The table below provides a capability statements comparison from AU Core to those in key implementation guides. Compliance in the reverse direction is not guaranteed, i.e. a system conforming to the IPA Client CapabilityStatement **MAY NOT** meet the conformance requirements of the AU Core Requester CapabilityStatement.

The comparison considers **SHALL** and **SHOULD** requirements. **MAY** requirements are not compared.

**Legend:**

![](green_checkmark.png) **Compliant**: A system conforming to an AU Core CapabilityStatement requirements meets all of the equivalent requirements of the compared capability statement.

![](orange_checkmark.png) **Additional requirements**: A system conforming to an AU Core CapabilityStatement requirement is compatible with the compared capability statement but may require additional functionality to meet its stricter or broader requirements. Where additional requirements are identified, more information is provided in the sections below.

![](cross_red_circle.png) **Incompatible**: A system conforming to an AU Core CapabilityStatement is incompatible with the compared capability statement. A system cannot be compliant to both. Where incompatible requirements are identified, more information is provided in the sections below.

![](minus_symbol.png) **No equivalent capability statement or resource type**: No equivalent CapabilityStatement mapped for comparison or no equivalent support for that resource type.

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| **IPA 1.1.0** | **IPS 2.0.0** | **US Core 8.0.0** | **IPA 1.1.0** | **IPS 2.0.0** | **US Core 8.0.0** | | |
| FHIR RESTful Capabilities (system wide) | FHIR version | ![](green_checkmark.png) | ![](minus_symbol.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) |
| Supported formats | ![](green_checkmark.png) | ![](minus_symbol.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | |
| Supported patch formats | ![](green_checkmark.png) | ![](minus_symbol.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | |
| Supported implementation guides | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | |
| FHIR capabilities | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | |
| FHIR resource support | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | |
| System wide interactions | ![](green_checkmark.png) | ![](minus_symbol.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | |
| Security | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | |
| Capabilities by Resource/Profile | AllergyIntolerance | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) |
| Condition | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | |
| DiagnosticReport | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | |
| DocumentReference | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | |
| Encounter | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | |
| HealthcareService | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | |
| Immunization | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | |
| Location | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | |
| Medication | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | |
| MedicationRequest | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | |
| MedicationStatement | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) | |
| Observation | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | |
| Organization | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | |
| Patient | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | |
| Practitioner | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | |
| PractitionerRole | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | |
| Procedure | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | |
| RelatedPerson | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | |
| Specimen | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | |

#### IPA CapabilityStatement Additional Requirements

A system conforming to an AU Core CapabilityStatement aligns with IPA CapabilityStatements but will require additional functionality to meet its stricter or broader requirements. The table below identifies additional requirements included in IPA CapabilityStatements. Implementers are advised to note that some code changes may be required to ensure full compliance.

**Legend:**

![](arrow_up.png) **Stronger**: The CapabilityStatement strengthens a conformance requirement that is present in the AU Core CapabilityStatement (e.g. **SHOULD** to **SHALL**).

![](plus_sign.png) **New**: The CapabilityStatement includes a conformance requirement that is NOT present in the mapped AU Core CapabilityStatement.

| | | |
| :--- | :--- | :--- |
| Supported implementation guides | ![](arrow_up.png)**SHALL**support[http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch](http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch). | ![](arrow_up.png)**SHALL**support[http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch](http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch). |
| FHIR capabilities | ![](plus_sign.png)**SHOULD**specify the patient id when performing searches on other resources. |  |
| FHIR resource support | ![](arrow_up.png)**SHALL**support the IPA conformance expectations for the Patient profile and for each IPA resource type they support, see additional requirements below. | ![](arrow_up.png)**SHALL**support the IPA conformance expectations for the Patient profile and for each IPA resource type they support, see additional requirements below. |
| Security | ![](arrow_up.png)**SHALL**follow[FHIR Security](https://hl7.org/fhir/R4/security.html)requirements. | ![](arrow_up.png)**SHALL**follow[FHIR Security](https://hl7.org/fhir/R4/security.html)requirements. |
| ![](arrow_up.png)**SHOULD**follow the security best practices outlined in[FHIR Security](https://hl7.org/fhir/R4/security.html)and elsewhere. | ![](arrow_up.png)**SHOULD**follow the security best practices outlined in[FHIR Security](https://hl7.org/fhir/R4/security.html)and elsewhere. | |
| ![](plus_sign.png)**SHALL**handle scope-based authorisation failures gracefully. | ![](plus_sign.png)**SHALL**handle scope-based authorisation failures gracefully. | |
| AllergyIntolerance | ![](arrow_up.png)**SHALL**handle:`AllergyIntolerance.clinicalStatus`,`AllergyIntolerance.verificationStatus`, and`AllergyIntolerance.code`. | ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). |
| ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | | |
| Condition | ![](arrow_up.png)**SHALL**handle:`Condition.clinicalStatus`,`Condition.verificationStatus`, and`Condition.code`. | ![](arrow_up.png)**SHOULD**populate:`Condition.code.coding.display`and/or`Condition.code.text`. |
| ![](plus_sign.png)**SHALL NOT**treat all Condition resources as entries in the current problem list. | ![](plus_sign.png)**SHOULD**avoid leaving`Condition.clinicalStatus`and`Condition.verificationStatus`missing. | |
| ![](plus_sign.png)**SHALL**correctly process and display`Condition.clinicalStatus`and`Condition.verificationStatus`. | ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | |
| ![](plus_sign.png)**SHALL**continue to function safely when some expected search parameters are not supported. | | |
| ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | | |
| DocumentReference | ![](plus_sign.png)**SHALL**meet the requirements of the IPA-DocumentReference profile. | ![](plus_sign.png)**SHALL**meet the requirements of the IPA-DocumentReference profile. |
| ![](plus_sign.png)**SHALL**support`read`and`search-type`interactions. | ![](plus_sign.png)**SHALL**support`read`and`search-type`interactions. | |
| ![](plus_sign.png)**SHALL**support the`patient`search parameter. | ![](plus_sign.png)**SHALL**support`_id`,`patient`,`patient+category`,`patient+category+date`, and`patient+type`search parameters and search parameter combinations. | |
| ![](plus_sign.png)**SHALL**handle:`DocumentReference.status`,`DocumentReference.type`,`DocumentReference.subject`,`DocumentReference.content`,`DocumentReference.content.attachment`,`DocumentReference.content.attachment.contentType`,`DocumentReference.content.attachment.data`,`DocumentReference.content.attachment.url`,`DocumentReference.format`,`DocumentReference.context`,`DocumentReference.context.encounter`, and`DocumentReference.context.period`. | ![](plus_sign.png)**SHALL**populate-if-known:`DocumentReference.status`,`DocumentReference.type`,`DocumentReference.category`,`DocumentReference.subject`,`DocumentReference.date`,`DocumentReference.author`,`DocumentReference.content`,`DocumentReference.content.attachment`,`DocumentReference.content.attachment.contentType`,`DocumentReference.content.attachment.data`,`DocumentReference.content.attachment.url`,`DocumentReference.format`,`DocumentReference.context`,`DocumentReference.context.encounter`, and`DocumentReference.context.period`. | |
| ![](plus_sign.png)**SHOULD**handle:`DocumentReference.category`and`DocumentReference.author`. | ![](plus_sign.png)**SHALL**support`$docref`operation. | |
| ![](plus_sign.png)**SHOULD**support`_id`,`patient+category`,`patient+category+date`,`patient+type`,`patient+contenttype`,`patient+status`,`patient+type+date`, and`patient+type+period`search parameter combinations. | ![](plus_sign.png)**SHOULD**support`patient+contenttype`,`patient+status`,`patient+type+date`, and`patient+type+period`search parameters and search parameters combinations. | |
| ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | |
| ![](plus_sign.png)**SHOULD**support`$docref`operation. | | |
| Immunization | ![](arrow_up.png)**SHALL**meet the requirements of the IPA-Immunization profile which has additional requirements, see[IPA profile additional requirements](#ipa-profile-additional-requirements). | ![](arrow_up.png)**SHALL**meet the requirements of the IPA-Immunization profile which has additional requirements, see[IPA profile additional requirements](#ipa-profile-additional-requirements). |
| ![](arrow_up.png)**SHALL**handle:`Immunization.status`,`Immunization.vaccineCode`,`Immunization.patient`and`Immunization.occurence[x]`. | | |
| ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | | |
| Medication | ![](arrow_up.png)**SHALL**handle`Medication.code`. | ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). |
| ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | | |
| MedicationRequest | ![](arrow_up.png)**SHALL**meet the requirements of the IPA-MedicationRequest profile which has additional requirements, see[IPA profile additional requirements](#ipa-profile-additional-requirements). | ![](arrow_up.png)**SHALL**meet the requirements of the IPA-MedicationRequest profile which has additional requirements, see[IPA profile additional requirements](#ipa-profile-additional-requirements). |
| ![](plus_sign.png)**SHALL**query both MedicationRequest and MedicationStatement when fetching patient Medication information. | ![](plus_sign.png)**SHOULD**use codings at the level of a clinical drug. | |
| ![](arrow_up.png)**SHALL**handle:`MedicationRequest.status`,`MedicationRequest.doNotPerform`,`MedicationRequest.medication[x]`,`MedicationRequest.subject`,`MedicationRequest.requester`,`MedicationRequest.dosageInstruction`, and`MedicationRequest.dosageInstruction.text`. | ![](plus_sign.png)**SHOULD**populate`MedicationRequest.doNotPerform`. | |
| ![](arrow_up.png)**SHOULD**handle`MedicationRequest.reported[x]`. | ![](plus_sign.png)**SHALL**populate-if-known`MedicationRequest.reported[x]`. | |
| ![](arrow_up.png)**SHOULD**support`category`and`code`search parameters. | ![](arrow_up.png)**SHOULD**support`category`and`code`search parameters. | |
| ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | |
| MedicationStatement | ![](arrow_up.png)**SHALL**meet the requirements of the IPA-MedicationStatement profile which has additional requirements, see[IPA profile additional requirements](#ipa-profile-additional-requirements). | ![](arrow_up.png)**SHALL**meet the requirements of the IPA-MedicationStatement profile which has additional requirements, see[IPA profile additional requirements](#ipa-profile-additional-requirements). |
| ![](plus_sign.png)**SHALL**query both MedicationRequest and MedicationStatement when fetching patient Medication information. | ![](plus_sign.png)**SHALL**populate-if-known:`MedicationStatement.context`and`MedicationStatement.informationSource`. | |
| ![](arrow_up.png)**SHALL**handle:`MedicationStatement.status`,`MedicationStatement.medication[x]`, and`MedicationStatement.subject`. | ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | |
| ![](arrow_up.png)**SHOULD**handle:`MedicationStatement.effective[x]`,`MedicationStatement.dosage`, and`MedicationStatement.dosage.text`. | | |
| ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | | |
| Observation | ![](arrow_up.png)**SHALL**support`patient`search parameter. | ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). |
| ![](arrow_up.png)**SHALL**handle:`Observation.status`,`Observation.code`,`Observation.subject`,`Observation.effective[x]`,`Observation.value[x]`, and`Observation.dataAbsentReason`. | | |
| ![](arrow_up.png)**SHOULD**handle`Observation.category`. | | |
| ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | | |
| Patient | ![](arrow_up.png)**SHALL**meet the requirements of the IPA-Patient profile which has additional requirements, see[IPA profile additional requirements](#ipa-profile-additional-requirements). | ![](arrow_up.png)**SHALL**meet the requirements of the IPA-Patient profile which has additional requirements, see[IPA profile additional requirements](#ipa-profile-additional-requirements). |
| ![](plus_sign.png)**SHALL**be able to follow`Patient.link`to other Patient resources and understand direction of the link. | ![](plus_sign.png)**SHALL**use`Patient.link`cross-link multiple Patient resources for the same person in search Bundles. | |
| ![](plus_sign.png)**SHALL**understand the`Patient.link.type`code. | ![](plus_sign.png)**SHALL**populate-if-known`Patient.identifier.value`,`Patient.active`, and`Patient.link`. | |
| ![](plus_sign.png)**SHALL**be aware of the linked Patient's`active`flag and that inactive patients may have relevant information. | ![](plus_sign.png)**SHALL**have no more than one Patient with a status of active = "true" for the same patient on the server. | |
| ![](plus_sign.png)**SHALL**support`Patient.link`processing. | ![](arrow_up.png)**SHALL**explain`Patient.identifier`. | |
| ![](arrow_up.png)**SHALL**handle:`Patient.identifier`,`Patient.gender`,`Patient.birthDate`, and`Patient.link`. | ![](arrow_up.png)**SHOULD**support`given`,`birthdate`, and`gender`search parameters. | |
| ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | |
| ![](arrow_up.png)**SHOULD**support`given`,`birthdate`, and`gender`search parameters. | | |
| Practitioner | ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). |
| PractitionerRole | ![](arrow_up.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). | ![](plus_sign.png)Conformance level**SHOULD**/**MAY**for`_revinclude=Provenance:target`is under discussion, see[FHIR-50351](https://jira.hl7.org/browse/FHIR-50351). |

#### IPS CapabilityStatement Additional Requirements

A system conforming to an AU Core CapabilityStatement aligns with IPS CapabilityStatement but will require additional functionality to meet its stricter or broader requirements. The table below identifies additional requirements included in IPS CapabilityStatements. Implementers are advised to note that some code changes may be required to ensure full compliance.

**Legend:**

![](arrow_up.png) **Stronger**: The CapabilityStatement strengthens a conformance requirement that is present in the AU Core CapabilityStatement (e.g. **SHOULD** to **SHALL**).

![](plus_sign.png) **New**: The CapabilityStatement includes a conformance requirement that is NOT present in the mapped AU Core CapabilityStatement.

| | |
| :--- | :--- |
| Bundle | ![](plus_sign.png)**SHALL**support Bundle resource. |
| ![](plus_sign.png)**SHALL**support Bundle (IPS) profile. | |
| Composition | ![](plus_sign.png)**SHALL**support Composition resource. |
| ![](plus_sign.png)**SHALL**support Composition (IPS) profile. | |
| Patient | ![](arrow_up.png)**SHALL**support Patient (IPS) profile which has additional requirements, see[IPS profile additional requirements](#ips-profile-additional-requirements). |
| ![](plus_sign.png)**SHOULD**support`$summary`operation. | |
| AllergyIntolerance | ![](arrow_up.png)**SHOULD**support AllergyIntolerance (IPS) profile which has additional requirements, see[IPS profile additional requirements](#ips-profile-additional-requirements). IPS sets this profile as a supported profile for the AllergyIntolerance resource, we interpret this as a conformance expectation of**SHOULD**. |
| Condition | ![](arrow_up.png)**SHOULD**support Condition (IPS) profile which has additional requirements, see[IPS profile additional requirements](#ips-profile-additional-requirements). IPS sets this profile as a supported profile for the Condition resource, we interpret this as a conformance expectation of**SHOULD**. |
| MedicationRequest | ![](arrow_up.png)**SHOULD**support MedicationRequest (IPS) profile which has additional requirements, see[IPS profile additional requirements](#ips-profile-additional-requirements). IPS sets this profile as a supported profile for the MedicationRequest resource, we interpret this as a conformance expectation of**SHOULD**. |

#### US Core CapabilityStatement Additional Requirements

A system conforming to an AU Core CapabilityStatement aligns with US Core CapabilityStatements but will require additional functionality to meet its stricter or broader requirements. The table below identifies additional requirements included in US Core CapabilityStatements. Implementers are advised to note that some code changes may be required to ensure full compliance.

**Legend:**

![](arrow_up.png) **Stronger**: The CapabilityStatement strengthens a conformance requirement that is present in the AU Core CapabilityStatement (e.g. **SHOULD** to **SHALL**).

![](plus_sign.png) **New**: The CapabilityStatement includes a conformance requirement that is NOT present in the maped AU Core CapabilityStatement.

**2Servers certified under the 21st Century Cures Act for accessing patient data apply additional requirements including requirements to support ALL resources defined in this capability statement with resource conformance SHALL. These additional requirements are excluded from comparison, i.e. with the exception of the Patient resource, resource conformance SHALL is considered SHOULD.**

| | | |
| :--- | :--- | :--- |
| FHIR resource support | ![](arrow_up.png)**SHALL**support fetching and querying of one or more US Core profile(s), using the supported RESTful interactions and search parameters declared in the US Core Server CapabilityStatement, see additional requirements below. | ![](arrow_up.png)**SHALL**support US Core Patient profile and at least one additional resource profile from the list of US Core Profiles and all*Must Support*US Core Profiles and resources it references, see additional requirements below. |
| Security | ![](plus_sign.png)**SHALL**establish a risk analysis and management regime conforming with HIPAA security regulatory requirements. | ![](plus_sign.png)**SHALL**establish a risk analysis and management regime conforming with HIPAA security regulatory requirements. |
| ![](plus_sign.png)**SHALL**use a single time source for audit and logging. The selected time service**SHOULD**be documented in the Business Associate Agreement when available. | ![](plus_sign.png)**SHALL**use a single time source for audit and logging. The selected time service**SHOULD**be documented in the Business Associate Agreement when available. | |
| ![](plus_sign.png)**SHALL**maintain audit logs of transactions. | ![](plus_sign.png)**SHALL**maintain audit logs of transactions. | |
| ![](arrow_up.png)**SHALL**conform to FHIR Communications Security requirements. | ![](arrow_up.png)**SHALL**conform to FHIR Communications Security requirements. | |
| ![](arrow_up.png)**SHALL**support SMART App Launch version 2.0.0. | ![](arrow_up.png)**SHALL**support SMART App Launch version 2.0.0. | |
| ![](plus_sign.png)**SHALL**implement consent according to local, institutional, and legal policy. | ![](plus_sign.png)**SHALL**implement consent according to local, institutional, and legal policy. | |
| ![](plus_sign.png)**SHOULD**define risk management and security/privacy controls in a Business Associate Agreement (BAA) when available. | ![](plus_sign.png)**SHOULD**define risk management and security/privacy controls in a Business Associate Agreement (BAA) when available.. | |
| ![](plus_sign.png)**SHOULD**provide Provenance statements using the US Core Provenance Profile. | ![](plus_sign.png)**SHOULD**provide Provenance statements using the US Core Provenance Profile. | |
| AllergyIntolerance | ![](arrow_up.png)**SHALL**support the US Core AllergyIntolerance Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). | ![](arrow_up.png)**SHALL**support the US Core AllergyIntolerance Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). |
| ![](plus_sign.png)**SHOULD**support`_revinclude: Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude: Provenance:target`. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| CarePlan | ![](plus_sign.png)**SHOULD**support CarePlan resource. | ![](plus_sign.png)**SHOULD**2support CarePlan resource. |
| ![](plus_sign.png)**SHALL**support US Core CarePlan Profile. | ![](plus_sign.png)**SHALL**support US Core CarePlan Profile. | |
| ![](plus_sign.png)**SHALL**support`read`and`search-type`interactions. | ![](plus_sign.png)**SHALL**support`read`and`search-type`interactions. | |
| ![](plus_sign.png)**SHALL**support`patient+category`search parameter combination. | ![](plus_sign.png)**SHALL**support`patient+category`search parameter combination. | |
| ![](plus_sign.png)**SHALL**be capable of fetching a CarePlan resource using:`GET [base]/CarePlan/[id]`. | ![](plus_sign.png)**SHALL**be capable of returning a CarePlan resource using:`GET [base]/CarePlan/[id]`. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**support`patient+ category +status`,`patient+category+status+date`, and`patient+category+date`search parameter combinations. | ![](plus_sign.png)**SHOULD**support`patient+ category +status`,`patient+category+status+date`, and`patient+category+date`search parameter combinations. | |
| CareTeam | ![](plus_sign.png)**SHOULD**support CareTeam resource. | ![](plus_sign.png)**SHOULD**2support CareTeam resource. |
| ![](plus_sign.png)**SHALL**support US Core CareTeam Profile. | ![](plus_sign.png)**SHALL**support US Core CareTeam Profile. | |
| ![](plus_sign.png)**SHALL**support`read`and`search-type`interactions. | ![](plus_sign.png)**SHALL**support`read`and`search-type`interactions. | |
| ![](plus_sign.png)**SHALL**support`patient+category`search parameter combination. | ![](plus_sign.png)**SHALL**support`patient+category`search parameter combination. | |
| ![](plus_sign.png)**SHALL**be capable of fetching a CareTeam resource using:`GET [base]/CareTeam/[id]`. | ![](plus_sign.png)**SHALL**be capable of returning a CareTeam resource using:`GET [base]/CareTeam/[id]`. | |
| ![](plus_sign.png)**SHALL**support references to US Core Practitioner Profile, US Core PractitionerRole Profile, US Core Patient Profile, and US Core RelatedPerson Profile. | ![](plus_sign.png)**SHALL**support references to at least one of US Core Practitioner Profile or US Core PractitionerRole Profile. | |
| ![](plus_sign.png)**SHOULD**reference US Core PractitionerRole Profile instead of US Core Practitioner Profile. | | |
| ![](plus_sign.png)**SHALL**provide implementation-specific guidance for accessing provider location and contact information if only US Core Practitioner Profile is supported. | | |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](plus_sign.png)**SHALL**support`patient+status`search parameter combination. | ![](plus_sign.png)**SHALL**support`patient+status`search parameter combination. | |
| ![](plus_sign.png)**SHOULD**support`_include`parameters`CareTeam:participant:PractitionerRole`,`CareTeam:participant:Practitioner`,`CareTeam:participant:Patient`, and`CareTeam:participant:RelatedPerson`. | ![](plus_sign.png)**SHOULD**support`_include`parameters`CareTeam:participant:PractitionerRole`,`CareTeam:participant:Practitioner`,`CareTeam:participant:Patient`, and`CareTeam:participant:RelatedPerson`. | |
| ![](plus_sign.png)**SHOULD**support`role`and`patient+role `search parameters and search parameter combinations. | ![](plus_sign.png)**SHOULD**support`role`and`patient+role `search parameters and search parameter combinations. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| Condition | ![](arrow_up.png)**SHALL**support US Core Condition Encounter Diagnosis Profile and US Core Condition Problems and Health Concerns Profile which have additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). | ![](arrow_up.png)**SHALL**support both US Core Condition Encounter Diagnosis Profile and US Core Condition Problems and Health Concerns Profile which have additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). |
| ![](plus_sign.png)**SHALL**support`assertedDate Extension`or`Condition.recordedDate`elements. | ![](plus_sign.png)**SHALL**support`Condition.recordedDate`elements and at least one of the`assertedDate Extension`and`Condition.onsetDateTime`. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude: Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude: Provenance:target`. | |
| ![](plus_sign.png)**SHOULD**support`patient+abatement-date`,`patient+asserted-date`,`patient+category+encounter`,`patient+_lastUpdated`, and`patient+recorded-date`search parameters combination. | ![](plus_sign.png)**SHOULD**support`patient+abatement-date`,`patient+asserted-date`,`patient+category+encounter`,`patient+_lastUpdated`, and`patient+recorded-date`search parameters combination. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)When`Condition.category`is a "problems-list-item", the`Condition.clinicalStatus`**SHOULD**be present. | ![](plus_sign.png)When`Condition.category`is a "problems-list-item", the`Condition.clinicalStatus`**SHOULD**be present. | |
| ![](plus_sign.png)**SHOULD**reference encounter in`Condition.encounter`when category is "encounter-diagnosis". | ![](plus_sign.png)**SHOULD**reference encounter in`Condition.encounter`when category is "encounter-diagnosis". | |
| ![](plus_sign.png)**SHOULD**update`Condition.meta.lastUpdated`to reflect new problems and health concerns, and changes in clinical status or verification status. | ![](plus_sign.png)**SHOULD**update`Condition.meta.lastUpdated`to reflect new problems and health concerns, and changes in clinical status or verification status. | |
| Coverage | ![](plus_sign.png)**SHOULD**support Coverage resource. | ![](plus_sign.png)**SHOULD**2support Coverage resource. |
| ![](plus_sign.png)**SHALL**support US Core Coverage Profile. | ![](plus_sign.png)**SHALL**support US Core Coverage Profile. | |
| ![](plus_sign.png)**SHALL**support`read`and`search-type`interactions. | ![](plus_sign.png)**SHALL**support`read`and`search-type`interactions. | |
| ![](plus_sign.png)**SHALL**be capable of fetching a Coverage resource using:`GET [base]/Coverage/[id]`. | ![](plus_sign.png)**SHALL**be capable of returning a Coverage resource using:`GET [base]/Coverage/[id]`. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude: Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude: Provenance:target`. | |
| ![](plus_sign.png)**SHALL**support`patient`search parameter. | ![](plus_sign.png)**SHALL**support`patient`search parameter. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| Device | ![](plus_sign.png)**SHOULD**support Device resource. | ![](plus_sign.png)**SHOULD**2support Device resource. |
| ![](plus_sign.png)**SHALL**support US Core Implantable Device Profile. | ![](plus_sign.png)**SHALL**support US Core Implantable Device Profile. | |
| ![](plus_sign.png)**SHALL**support`read`and`search-type`interactions. | ![](plus_sign.png)**SHALL**support`read`and`search-type`interactions. | |
| ![](plus_sign.png)**SHALL**be capable of fetching a Device resource using:`GET [base]/Device/[id]`. | ![](plus_sign.png)**SHALL**be capable of returning a Device resource using:`GET [base]/Device/[id]`. | |
| ![](plus_sign.png)**SHALL**represent the UDI code in`Device.udiCarrier.carrierHRF`when UDI information is available. | ![](plus_sign.png)**SHALL**represent the UDI code in`Device.udiCarrier.carrierHRF`when UDI information is available. | |
| ![](plus_sign.png)**SHALL**represent all UDI-PI elements present in the UDI code using the corresponding elements in the US Core Implantable Device Profile. | ![](plus_sign.png)**SHALL**represent all UDI-PI elements present in the UDI code using the corresponding elements in the US Core Implantable Device Profile. | |
| ![](plus_sign.png)**SHALL**support`patient`search parameter. | ![](plus_sign.png)**SHALL**support`patient`search parameter. | |
| ![](plus_sign.png)**SHOULD**include`Device.manufacturer`and/or`Device.model`when UDI is not present but manufacturer or model information is available. | ![](plus_sign.png)**SHOULD**include`Device.manufacturer`and/or`Device.model`when UDI is not present but manufacturer or model information is available. | |
| ![](plus_sign.png)**SHOULD**support querying implantable devices by`Device.type`. | | |
| ![](plus_sign.png)**SHOULD**support`_revinclude: Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude: Provenance:target`. | |
| ![](plus_sign.png)**SHOULD**support`patient+status`and`patient+type`search parameter combinations. | ![](plus_sign.png)**SHOULD**support`patient+status`and`patient+type`search parameter combinations. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| DiagnosticReport | ![](arrow_up.png)**SHALL**support US Core DiagnosticReport Profile for Laboratory Results Reporting and US Core DiagnosticReport Profile for Report and Note Exchange profiles. | ![](arrow_up.png)**SHALL**support US Core DiagnosticReport Profile for Laboratory Results Reporting and US Core DiagnosticReport Profile for Report and Note Exchange profiles. |
| ![](plus_sign.png)**SHALL**be capable of fetching a DiagnosticReport resource using:`GET [base]/DiagnosticReport/[id]`. | ![](plus_sign.png)**SHALL**be capable of returning a DiagnosticReport resource using:`GET [base]/DiagnosticReport/[id]`. | |
| ![](plus_sign.png)**SHALL**support`read`and`search-type`interactions. | ![](plus_sign.png)**SHALL**support`read`and`search-type`interactions. | |
| ![](plus_sign.png)**SHALL**support`create`for the US Core DiagnosticReport Profile for Report and Note exchange profile. | ![](plus_sign.png)**SHALL**support`create`for the US Core DiagnosticReport Profile for Report and Note exchange profile. | |
| ![](plus_sign.png)**SHALL**support`patient`,`patient+code`,`patient+category`, and`patient+category+date`search parameter and search parameter combinations. | ![](plus_sign.png)**SHALL**support`patient`,`patient+code`,`patient+category`, and`patient+category+date`search parameter and search parameter combinations. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**support`patient+code+date`,`patient+status`, and`patient+category+_lastUpdated`search parameter combinations. | ![](plus_sign.png)**SHOULD**support`patient+code+date`,`patient+status`, and`patient+category+_lastUpdated`search parameter combinations. | |
| ![](plus_sign.png)**SHOULD**use`DiagnosticReport.media.link`to suppport links to images | ![](plus_sign.png)**SHOULD**use`DiagnosticReport.media.link`to suppport links to images | |
| ![](plus_sign.png)**SHOULD**use`DiagnosticReport.imagingStudy`to reference DICOM imaging studies. | ![](plus_sign.png)**SHOULD**use`DiagnosticReport.imagingStudy`to reference DICOM imaging studies. | |
| ![](plus_sign.png)**SHOULD**update`DiagnosticReport.meta.lastUpdated`to reflect new laboratory reports, and changes in the status of laboratory report. | ![](plus_sign.png)**SHOULD**update`DiagnosticReport.meta.lastUpdated`to reflect new laboratory reports, and changes in the status of laboratory report. | |
| DocumentReference | ![](plus_sign.png)**SHALL**support US Core DocumentReference Profile and US Core ADI DocumentReference Profile. | ![](plus_sign.png)**SHALL**support US Core DocumentReference Profile. |
| ![](plus_sign.png)**SHALL**support at minimum the ten[Common Clinical Notes](https://hl7.org/fhir/us/core/ValueSet-us-core-clinical-note-type.html)in the DocumentReference.type. | ![](plus_sign.png)**SHALL**support at minimum the ten[Common Clinical Notes](https://hl7.org/fhir/us/core/ValueSet-us-core-clinical-note-type.html)in the DocumentReference.type. | |
| ![](plus_sign.png)**SHALL**support both`DocumentReference.content.attachment.url`and`DocumentReference.content.attachment.data`. | ![](plus_sign.png)**SHALL**support at least one of`DocumentReference.content.attachment.url`and`DocumentReference.content.attachment.data`. | |
| ![](plus_sign.png)If there are multiple`DocumentReference.content`repetitions, these**SHALL**represent the same document in different formats or attachment metadata, and**SHALL NOT**represent different document versions. | ![](plus_sign.png)If there are multiple`DocumentReference.content`repetitions, these**SHALL**represent the same document in different formats or attachment metadata, and**SHALL NOT**represent different document versions. | |
| ![](plus_sign.png)**SHALL**be capable of handling a responsible organisation, either direclty in`DocumentReference.custodian`or via`Provenance.agent.who`or`Provenance.agent.onBehalfOf`. | ![](plus_sign.png)**SHALL**ansure that the responsible organisation is present either in`DocumentReference.custodian`or accesible via`Provenance.agent.who`or`Provenance.agent.onBehalfOf`. | |
| ![](plus_sign.png)**SHALL**be capable of fetching a DocumentReference resource using:`GET [base]/DocumentReference/[id]`. | ![](plus_sign.png)**SHALL**be capable of returning a DocumentReference resource using:`GET [base]/DocumentReference/[id]`. | |
| ![](plus_sign.png)**SHALL**support`create`,`read`and`search-type`interactions. | ![](plus_sign.png)**SHALL**support`create`,`read`and`search-type`interactions. | |
| ![](plus_sign.png)**SHALL**support`_id`,`patient`,`patient+type`,`patient+category`, and`patient+category+date`search parameters and search parameter combinations. | ![](plus_sign.png)**SHALL**support`_id`,`patient`,`patient+type`,`patient+category`, and`patient+category+date`search parameters and search parameter combinations. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**support`$docref`operation. | ![](plus_sign.png)**SHALL**support`$docref`operation. | |
| ![](plus_sign.png)**SHOULD**be capable of transacting the`$docref`operation. | ![](plus_sign.png)**SHALL**be capable of responding to a`$docref`operation. | |
| ![](plus_sign.png)**SHOULD**be capable of receiving at least a reference to a CCD document. | ![](plus_sign.png)**SHALL**return at least a reference to a CCD document, if available. | |
| ![](plus_sign.png)**SHOULD**be capable of receiving included resources returned in the operation response. | ![](plus_sign.png)**SHOULD**document what resources (if any) are returned as included resources. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](plus_sign.png)**SHOULD**support`patient+type+period`and`patient+status`search parameter combinations. | ![](plus_sign.png)**SHOULD**support`patient+type+period`and`patient+status`search parameter combinations. | |
| ![](plus_sign.png)If a`period`parameter is supplied to the`$docref`operation,**SHOULD**return references to documents within the specified date range; if not supplied,**SHALL**return the most recent or current document(s). | | |
| Encounter | ![](arrow_up.png)**SHALL**support the US Core Encounter profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). | ![](arrow_up.png)**SHALL**support the US Core Encounter profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). |
| ![](plus_sign.png)**SHALL**support`_id`search parameter. | ![](plus_sign.png)**SHALL**support`_id`search parameter. | |
| ![](plus_sign.png)**SHALL**support both`Encounter.location.location`and`Encounter.serviceProvider`. | ![](plus_sign.png)**SHALL**support at least one of`Encounter.location.location`and`Encounter.serviceProvider`. | |
| ![](plus_sign.png)**SHOULD**support`identifier`,`patient+type`,`patient+_lastUpdated`, and`patient+discharge-disposition`search parameters and search parameter combinations. | ![](plus_sign.png)**SHOULD**support`identifier`,`patient+type`,`patient+_lastUpdated`, and`patient+discharge-disposition`search parameters and search parameter combinations. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**conform to US Core Observation profile if`Encounter.reasonReference`points to an Observation. | ![](plus_sign.png)**SHOULD**conform to US Core Observation profile if`Encounter.reasonReference`points to an Observation. | |
| ![](plus_sign.png)**SHOULD**be capable of representing the event facility or location directly when it differs from the location referenced in`Encounter.location`. | ![](plus_sign.png)**SHOULD**be capable of representing the event facility or location directly when it differs from the location referenced in`Encounter.location`. | |
| ![](plus_sign.png)**SHOULD**update Encounter.meta.lastUpdated to reflect new encounters and changes in the status of encounters. | ![](plus_sign.png)**SHOULD**update Encounter.meta.lastUpdated to reflect new encounters, and changes in the status of encounters. | |
| Endpoint | ![](plus_sign.png)**SHOULD**support Endpoint resource. | ![](plus_sign.png)**SHOULD**2support Endpoint resource. |
| ![](plus_sign.png)**SHOULD**support`read`and`vread`interactions. | ![](plus_sign.png)**SHOULD**support`read`and`vread`interactions. | |
| ![](plus_sign.png)**SHOULD**be capable of fetching an Endpoint resource using`GET [base]/Endpoint/[id]`. | ![](plus_sign.png)**SHOULD**be capable of returning an Endpoint resource using`GET [base]/Endpoint/[id]`. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| Goal | ![](plus_sign.png)**SHOULD**support Goal resource. | ![](plus_sign.png)**SHOULD**2support Goal resource. |
| ![](plus_sign.png)**SHALL**support US Core Goal Profile. | ![](plus_sign.png)**SHALL**support US Core Goal Profile. | |
| ![](plus_sign.png)**SHALL**support`search-type`and`read`interactions. | ![](plus_sign.png)**SHALL**support`search-type`and`read`interactions. | |
| ![](plus_sign.png)**SHALL**support both`Goal.startDate`and`Goal.endDate`. | ![](plus_sign.png)**SHALL**support at least one of`Goal.startDate`and`Goal.endDate`. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**be capable of fetching a Goal resource using`GET [base]/Goal/[id]`. | ![](plus_sign.png)**SHOULD**be capable of returning a Goal resource using`GET [base]/Goal/[id]`. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](plus_sign.png)**SHALL**support`patient`search parameter. | ![](plus_sign.png)**SHALL**support`patient`search parameter. | |
| ![](plus_sign.png)**SHOULD**support`patient+lifecycle-status`,`patient+description`and`patient+target-date`search parameter combinations. | ![](plus_sign.png)**SHOULD**support`patient+lifecycle-status`,`patient+description`and`patient+target-date`search parameter combinations. | |
| HealthcareService | ![](plus_sign.png)**SHOULD**support`vread`interaction. | ![](plus_sign.png)**SHOULD**support`vread`interaction. |
| Immunization | ![](arrow_up.png)**SHALL**support the US Core Immunization Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). | ![](arrow_up.png)**SHALL**support the US Core Immunization Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**support NDC vaccine codes as additional codes to CVX vaccine codes, which are required based on the ASTP U.S. Core Data for Interoperability (USCDI) requirements. | ![](plus_sign.png)**SHOULD**support NDC vaccine codes as additional codes to CVX vaccine codes, which are required based on the ASTP U.S. Core Data for Interoperability (USCDI) requirements. | |
| Location | ![](arrow_up.png)**SHALL**support the US Core Location Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). | ![](arrow_up.png)**SHALL**support the US Core Location Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). |
| ![](arrow_up.png)**SHALL**support the`address`search parameter. | ![](arrow_up.png)**SHALL**support the`address`search parameter. | |
| ![](plus_sign.png)**SHOULD**support the`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support the`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**format`Location.address.line`and`Location.address.city`according to the Project US@ Technical Specification for Patient Addresses Final Version 1.0. | ![](plus_sign.png)**SHOULD**format`Location.address.line`and`Location.address.city`according to the Project US@ Technical Specification for Patient Addresses Final Version 1.0. | |
| Media | ![](plus_sign.png)**SHOULD**support Media resource. | ![](plus_sign.png)**SHOULD**2support Media resource. |
| ![](plus_sign.png)**SHOULD**support`read`and`vread`interactions. | ![](plus_sign.png)**SHOULD**support`read`and`vread`interactions. | |
| ![](plus_sign.png)**SHOULD**be capable of fetching a Media resource using`GET [base]/Media/[id]`. | ![](plus_sign.png)**SHOULD**be capable of returning a Media resource using`GET [base]/Media/[id]`. | |
| Medication | ![](arrow_up.png)**SHALL**support the US Core Medication Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). | ![](arrow_up.png)**SHALL**support the US Core Medication Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). |
| ![](plus_sign.png)**SHOULD**support the`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support the`vread`and`history-instance`interactions. | |
| MedicationDispense | ![](plus_sign.png)**SHOULD**support MedicationDispense resource. | ![](plus_sign.png)**SHOULD**2support MedicationDispense resource. |
| ![](plus_sign.png)**SHALL**support US Core MedicationDispense Profile. | ![](plus_sign.png)**SHALL**support US Core MedicationDispense Profile. | |
| ![](plus_sign.png)**SHALL**support`search-type`and`read`interactions. | ![](plus_sign.png)**SHALL**support`search-type`and`read`interactions. | |
| ![](plus_sign.png)**SHALL**support`patient`search parameter. | ![](plus_sign.png)**SHALL**support`patient`search parameter. | |
| ![](plus_sign.png)**SHALL**support representing medication using a code and using a reference to a Medication resource. | ![](plus_sign.png)**SHALL**support representing medication using at least one of a code or a reference to a Medication resource. | |
| ![](plus_sign.png)**SHALL**support`_include`parameter for`.medicationReference`when referencing an external Medication resource. | | |
| ![](plus_sign.png)**SHOULD**support`_include=MedicationDispense:medication`. | ![](plus_sign.png)**SHOULD**support`_include=MedicationDispense:medication`. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](plus_sign.png)**SHOULD**be capable of fetching a MedicationDispense resource using`GET [base]/MedicationDispense/[id]`. | ![](plus_sign.png)**SHALL**be capable of returning a MedicationDispense resource using`GET [base]/MedicationDispense/[id]`. | |
| ![](plus_sign.png)**SHOULD**support`patient+status+type`and`patient+status`search parameter combinations. | ![](plus_sign.png)**SHOULD**support`patient+status+type`and`patient+status`search parameter combinations. | |
| MedicationRequest | ![](arrow_up.png)**SHALL**support the US Core MedicationRequest Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). | ![](arrow_up.png)**SHALL**support the US Core MedicationRequest Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). |
| ![](arrow_up.png)**SHALL**support`patient+intent`and`patient+intent+status`search parameter combinations. | ![](arrow_up.png)**SHALL**support`patient+intent`and`patient+intent+status`search parameter combinations. | |
| ![](plus_sign.png)**SHALL**support both`MedicationRequest.reportedBoolean`and`MedicationRequest.reportedReference`. | ![](plus_sign.png)**SHALL**support at least one of`MedicationRequest.reportedBoolean`and`MedicationRequest.reportedReference`. | |
| ![](plus_sign.png)**SHALL**support at least one target resource type in`MedicationRequest.reasonReference`. | | |
| ![](plus_sign.png)**SHOULD**conform referenced resources in`MedicationRequest.reasonReference`to appropriate US Core profiles. | ![](plus_sign.png)**SHOULD**conform referenced resources in`MedicationRequest.reasonReference`to appropriate US Core profiles. | |
| ![](plus_sign.png)**SHOULD**interpret the use of`MedicationRequest.requester`with Patient or RelatedPerson indicates a self-prescribed medication. | ![](arrow_up.png)**SHOULD**support`patient+intent+encounter`search parameter combination. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](arrow_up.png)**SHOULD**support`patient+intent+encounter`search parameter combination. | | |
| Observation | ![](arrow_up.png)**SHOULD**2support Observation profiles, including profiles with[additional requirements](#us-core-profile-additional-requirements)and[additional profiles](#us-core-profile-additional-profiles). | ![](arrow_up.png)**SHOULD**2support Observation profiles, including profiles with[additional requirements](#us-core-profile-additional-requirements)and[additional profiles](#us-core-profile-additional-profiles). |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**support`patient+category+_lastUpdated`search parameter combination. | ![](plus_sign.png)**SHOULD**support`patient+category+_lastUpdated`search parameter combination. | |
| ![](plus_sign.png)**SHOULD**support`Observation.effectivePeriod`for time-based tests. | ![](plus_sign.png)**SHOULD**support`Observation.effectivePeriod`for time-based tests. | |
| Organization | ![](arrow_up.png)**SHALL**support the US Core Organization Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). | ![](arrow_up.png)**SHALL**support the US Core Organization Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). |
| ![](arrow_up.png)**SHALL**support`address`search parameter. | ![](arrow_up.png)**SHALL**support`address`search parameter. | |
| ![](plus_sign.png)**SHALL**support National Provider Identifier (NPI) for organisations. | ![](plus_sign.png)**SHALL**support National Provider Identifier (NPI) for organisations. | |
| ![](plus_sign.png)**SHOULD**support Clinical Laboratory Improvement Amendments (CLIA) identifier for organisations. | ![](plus_sign.png)**SHOULD**support Clinical Laboratory Improvement Amendments (CLIA) identifier for organisations. | |
| ![](plus_sign.png)**SHOULD**follow the Project US@ Technical Specification for Patient Addresses Final Version 1.0 as the standard style guide for populating Organization.address.line and Organization.address.city. | ![](plus_sign.png)**SHOULD**follow the Project US@ Technical Specification for Patient Addresses Final Version 1.0 as the standard style guide for populating Organization.address.line and Organization.address.city. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| Patient | ![](arrow_up.png)**SHALL**support the US Core Patient Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). | ![](arrow_up.png)**SHALL**support the US Core Patient Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). |
| ![](arrow_up.png)**SHALL**support`_id`,`name`and`birthdate+name`search parameter and search parameter combinations. | ![](arrow_up.png)**SHALL**support`_id`,`name`and`birthdate+name`search parameter and search parameter combinations. | |
| ![](plus_sign.png)**SHOULD**support the`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support the`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](plus_sign.png)**SHALL**support at least`Patient.deceasedDateTime`if supporting`Patient.deceased[x]`. | ![](plus_sign.png)**SHALL**support at least`Patient.deceasedDateTime`if supporting`Patient.deceased[x]`. | |
| ![](plus_sign.png)**SHOULD**follow the Project US@ Technical Specification for Patient.address.line and Patient.address.city formatting. | ![](plus_sign.png)**SHOULD**follow the Project US@ Technical Specification for Patient.address.line and Patient.address.city formatting. | |
| ![](plus_sign.png)**SHOULD NOT**use a Social Security Number in`Patient.identifier.value`. | ![](plus_sign.png)**SHOULD NOT**use a Social Security Number in`Patient.identifier.value`. | |
| ![](plus_sign.png)**SHALL**include a text description when using the Race and Ethnicity complex extensions. | ![](plus_sign.png)**SHALL**include a text description when using the Race and Ethnicity complex extensions. | |
| Practitioner | ![](arrow_up.png)**SHALL**support the US Core Practitioner which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). | ![](arrow_up.png)**SHALL**support the US Core Practitioner which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). |
| ![](arrow_up.png)**SHALL**support`name`search parameter. | ![](arrow_up.png)**SHALL**support`name`search parameter. | |
| ![](plus_sign.png)**SHALL**support`Practitioner.address`, regardless of whether the server supports the PractitionerRole resource. | ![](plus_sign.png)**SHALL**support`Practitioner.address`if the server does not support the PractitionerRole resource. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHALL**provide implementation-specific guidance for accessing a provider's location and contact information when only the Practitioner resource is supported. | |
| ![](plus_sign.png)**SHOULD**follow the Project US@ Technical Specification for`Practitioner.address.line`and`Practitioner.address.city`formatting. | ![](plus_sign.png)**SHOULD**follow the Project US@ Technical Specification for`Practitioner.address.line`and`Practitioner.address.city`formatting. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | | |
| ![](plus_sign.png)**SHOULD**expose only professional or work contact information to patients. | ![](plus_sign.png)**SHOULD**expose only professional or work contact information to patients. | |
| PractitionerRole | ![](arrow_up.png)**SHALL**support the US Core PractitionerRole which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). | ![](arrow_up.png)**SHALL**support the US Core PractitionerRole which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). |
| ![](arrow_up.png)**SHALL**support`specialty`search parameter. | ![](arrow_up.png)**SHALL**support`specialty`search parameter. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**support`_include=PractitionerRole:endpoint`. | ![](plus_sign.png)**SHOULD**support`_include=PractitionerRole:endpoint`. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | |
| Procedure | ![](plus_sign.png)**SHALL**support both the US Core Procedure and US Core ServiceRequest profiles for communicating the reason for referral or consultation via`Procedure.basedOn`. | ![](plus_sign.png)**SHALL**support at least one of target resource types in`Procedure.reasonReference`. |
| ![](plus_sign.png)**SHOULD**ensure that referenced resources in`Procedure.reasonReference`conform to US Core profiles | ![](plus_sign.png)**SHOULD**ensure that referenced resources in`Procedure.reasonReference`conform to US Core profiles. | |
| ![](plus_sign.png)**SHALL**support both the US Core Procedure and US Core ServiceRequest profiles for communicating the reason for referral or consultation via`Procedure.basedOn`. | | |
| ![](plus_sign.png)**SHOULD**use`Procedure.focalDevice`with reference to the US Core Implantable Device Profile when applicable. | ![](plus_sign.png)**SHOULD**use`Procedure.focalDevice`with reference to the US Core Implantable Device Profile when applicable. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](plus_sign.png)**SHOULD**only use LOINC codes that reflect the actual procedures. | ![](plus_sign.png)**SHOULD**only use LOINC codes that reflect the actual procedures. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| Provenance | ![](plus_sign.png)**SHOULD**support Provenance resource. | ![](plus_sign.png)**SHOULD**2support Provenance resource. |
| ![](plus_sign.png)**SHALL**support US Core Provenance Profile. | ![](plus_sign.png)**SHALL**support US Core Provenance Profile. | |
| ![](plus_sign.png)**SHALL**support`read`interaction. | ![](plus_sign.png)**SHALL**support`read`interaction. | |
| ![](plus_sign.png)**SHALL**support the US Core Provenance Profile for AllergyIntolerance, CarePlan, CareTeam, Condition, Coverage, Device, DiagnosticReport, DocumentReference, Encounter, Goal, Immunization, MedicationDispense, MedicationRequest, Observation, Patient, Procedure, QuestionnaireResponse, RelatedPerson, and ServiceRequest resources. | ![](plus_sign.png)**SHALL**support the US Core Provenance Profile for AllergyIntolerance, CarePlan, CareTeam, Condition, Coverage, Device, DiagnosticReport, DocumentReference, Encounter, Goal, Immunization, MedicationDispense, MedicationRequest, Observation, Patient, Procedure, QuestionnaireResponse, RelatedPerson, and ServiceRequest resources. | |
| ![](plus_sign.png)**SHALL**provide the organisation as the source when a provider is received in`Provenance.agent.who`as free text. | ![](plus_sign.png)**SHALL**provide the organisation as the source when a provider is received in`Provenance.agent.who`as free text. | |
| ![](plus_sign.png)**SHOULD**populate the activity when the system needs to know the activity has occurred. | ![](plus_sign.png)**SHOULD**populate activity when the system needs to know the activity has occurred. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHALL**be capable of fetching a Provenance resource using`GET [base]/Provenance/[id]`. | ![](plus_sign.png)**SHALL**be capable of returning a Provenance resource using`GET [base]/Provenance/[id]`. | |
| Questionnaire | ![](plus_sign.png)**SHOULD**support Questionnaire resource. | ![](plus_sign.png)**SHOULD**support Questionnaire resource. |
| ![](plus_sign.png)**SHALL**support SDC Base Questionnaire Profile. | ![](plus_sign.png)**SHALL**support US Core Observation Screening Assessment Profile. | |
| ![](plus_sign.png)**SHOULD**support SDC Base Questionnaire Profile/US Core QuestionnaireResponse Profile. | | |
| ![](plus_sign.png)**SHOULD**support`read`and`vread`interactions. | ![](plus_sign.png)**SHOULD**support`read`and`vread`interactions. | |
| ![](plus_sign.png)**SHOULD**be capable of fetching a Questionnaire resource using`GET [base]/Questionnaire/[id]`. | ![](plus_sign.png)**SHOULD**be capable of returning a Questionnaire resource using`GET [base]/Questionnaire/[id]`. | |
| QuestionnaireResponse | ![](plus_sign.png)**SHOULD**support QuestionnaireResponse resource. | ![](plus_sign.png)**SHOULD**support QuestionnaireResponse resource. |
| ![](plus_sign.png)**SHALL**support US Core QuestionnaireResponse Profile. | ![](plus_sign.png)**SHALL**support US Core Observation Screening Assessment Profile. | |
| ![](plus_sign.png)**SHOULD**support SDC Base Questionnaire Profile/US Core QuestionnaireResponse Profile. | | |
| ![](plus_sign.png)**SHOULD**support`search-type`,`read`,`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`search-type`,`read`,`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**be capable of fetching a QuestionnaireResponse resource using`GET [base]/QuestionnaireResponse/[id]`. | ![](plus_sign.png)**SHOULD**be capable of returning a QuestionnaireResponse resource using`GET [base]/QuestionnaireResponse/[id]`. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](plus_sign.png)**SHALL**support`_id`and`patient`search parameters. | ![](plus_sign.png)**SHALL**support`_id`and`patient`search parameters. | |
| ![](plus_sign.png)**SHOULD**support`patient+authored`,`patient+status`and`patient+questionnaire`search parameter combinations. | ![](plus_sign.png)**SHOULD**support`patient+authored`,`patient+status`and`patient+questionnaire`search parameter combinations. | |
| RelatedPerson | ![](arrow_up.png)**SHALL**support the US Core RelatedPerson Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). | ![](arrow_up.png)**SHALL**support the US Core RelatedPerson Profile which has additional requirements, see[US Core profile additional requirements](#us-core-profile-additional-requirements). |
| ![](arrow_up.png)**SHALL**support`_id`search parameter. | ![](arrow_up.png)**SHALL**support`_id`search parameter. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](arrow_up.png)**SHOULD**support`name`search parameter. | ![](arrow_up.png)**SHOULD**support`name`search parameter. | |
| ![](plus_sign.png)**SHOULD**follow the Project US@ Technical Specification for`RelatedPerson.address.line`and`RelatedPerson.address.city`formatting. | ![](plus_sign.png)**SHOULD**follow the Project US@ Technical Specification for`RelatedPerson.address.line`and`RelatedPerson.address.city`formatting. | |
| ServiceRequest | ![](plus_sign.png)**SHOULD**support ServiceRequest resource. | ![](plus_sign.png)**SHOULD**2support ServiceRequest resource. |
| ![](plus_sign.png)**SHALL**support US Core ServiceRequest Profile. | ![](plus_sign.png)**SHALL**support US Core ServiceRequest Profile. | |
| ![](plus_sign.png)**SHALL**support`search-type`and`read`interactions. | ![](plus_sign.png)**SHALL**support`read`interaction. | |
| ![](plus_sign.png)**SHOULD**be capable of fetching a ServiceRequest resource using:`GET [base]/ServiceRequest/[id]`. | ![](plus_sign.png)**SHALL**be capable of returning a ServiceRequest resource using:`GET [base]/ServiceRequest/[id]`. | |
| ![](plus_sign.png)**SHALL**support`_id`,`patient`,`patient+category`,`patient+category+authored`, and`patient+code`search parameters and search parameter combinations. | ![](plus_sign.png)**SHALL**support`_id`,`patient`,`patient+category`,`patient+category+authored`, and`patient+code`search parameters and search parameter combinations. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**support`_revinclude=Provenance:target`. | ![](plus_sign.png)**SHALL**support`_revinclude=Provenance:target`. | |
| ![](plus_sign.png)**SHALL**support both US Core ServiceRequest and US Core Procedure Profiles for representing the reason for a referral. | ![](plus_sign.png)**SHALL**support both US Core ServiceRequest and US Core Procedure Profiles for representing the reason for a referral. | |
| ![](plus_sign.png)**SHALL**support both`ServiceRequest.reasonCode`and`ServiceRequest.reasonReference`. | ![](plus_sign.png)**SHALL**support at least one of`ServiceRequest.reasonCode`and`ServiceRequest.reasonReference`. | |
| ![](plus_sign.png)**SHALL**support all target resource types in`ServiceRequest.reasonReference`. | ![](plus_sign.png)**SHALL**support at least one target resource type in`ServiceRequest.reasonReference`. | |
| ![](plus_sign.png)**SHOULD**support`patient+status`and`patient+code+authored`search parameter combinations. | ![](plus_sign.png)**SHOULD**support`patient+status`and`patient+code+authored`search parameter combinations. | |
| ![](plus_sign.png)**SHALL**support querying by ServiceRequest.category. | ![](plus_sign.png)**SHALL**support querying by ServiceRequest.category. | |
| ![](plus_sign.png)**SHOULD**use US Core Profiles as target references in`ServiceRequest.reasonReference`. | ![](plus_sign.png)**SHOULD**use US Core Profiles as target references in`ServiceRequest.reasonReference`. | |
| ![](plus_sign.png)**SHOULD**use the corresponding category codes for the USCDI Data Element context, as listed in the US Core ServiceRequest Profile page. | ![](plus_sign.png)**SHOULD**use the corresponding category codes for the USCDI Data Element context, as listed in the US Core ServiceRequest Profile page. | |
| ![](plus_sign.png)**SHOULD**constrain`ServiceRequest.code`to an appropriate subset for the use case or domain. | ![](plus_sign.png)**SHOULD**constrain`ServiceRequest.code`to an appropriate subset for the use case or domain. | |
| ![](plus_sign.png)**SHOULD**conform to the value set bindings for`ServiceRequest.code`as listed for each USCDI Order context in the US Core ServiceRequest Profile page. | ![](plus_sign.png)**SHOULD**conform to the value set bindings for`ServiceRequest.code`as listed for each USCDI Order context in the US Core ServiceRequest Profile page. | |
| Specimen | ![](arrow_up.png)**SHALL**support the US Core Specimen Profile. | ![](arrow_up.png)**SHALL**support the US Core Specimen Profile. |
| ![](plus_sign.png)**SHALL**be capable of fetching a Specimen resource using:`GET [base]/Specimen/[id]`. | ![](plus_sign.png)**SHALL**be capable of returning a Specimen resource using:`GET [base]/Specimen/[id]`. | |
| ![](plus_sign.png)**SHALL**support both`Specimen.identifier`and`Specimen.accessionIdentifier`. | ![](plus_sign.png)**SHALL**support at least one of`Specimen.identifier`and`Specimen.accessionIdentifier`. | |
| ![](plus_sign.png)**SHALL**support the`_id`search parameter. | ![](plus_sign.png)**SHALL**support the`_id`search parameter. | |
| ![](plus_sign.png)**SHALL**support`read`interaction. | ![](plus_sign.png)**SHALL**support`read`interaction. | |
| ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | ![](plus_sign.png)**SHOULD**support`vread`and`history-instance`interactions. | |
| ![](plus_sign.png)**SHOULD**support`patient`search parameter. | ![](plus_sign.png)**SHOULD**support`patient`search parameter. | |
| ValueSet | ![](plus_sign.png)**SHOULD**support the ValueSet resource. | ![](plus_sign.png)**SHOULD**support the ValueSet resource. |
| ![](plus_sign.png)**SHOULD**support the`$expand`operation. | ![](plus_sign.png)**SHOULD**support the`$expand`operation. | |
| ![](plus_sign.png)**SHOULD**support the`context`and`contextdirection`parameters of the`$expand`operation when supporting DocumentReference for clinical notes. | | |

