# AU Core Procedure - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU Core Procedure**

## Resource Profile: AU Core Procedure 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/core/StructureDefinition/au-core-procedure | *Version*:2.0.0 | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://hl7.org.au/fhir/6.0.0/generalguidance.html#maturity-levels): 2 | *Computable Name*:AUCoreProcedure |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile sets minimum expectations for a Procedure resource to record, search, and fetch procedures associated with a patient. It is based on the [AU Base Procedure](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-procedure.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Procedure resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. 

See [Comparison with other national and international IGs](comparison.md) for a comparison between AU Core profiles and profiles in other implementation guides.

### Usage Scenarios

The following are supported usage scenarios for this profile:

* Query for procedures performed on a patient
* Record or update a record of a procedure performed on a patient

### Profile Specific Implementation Guidance

* `Procedure.category` provides an efficient way of supporting system interactions, e.g. restricting searches. Implementers need to understand that data categorisation is somewhat subjective. The categorisation applied by the source may not align with a receiver’s expectations.
* The use of coding can vary significantly across systems, requesters need to understand that they may encounter codes they do not recognise and be prepared to handle those resources appropriately. Responders **SHOULD** populate `Procedure.code.text` and/or `Procedure.code.coding.display` so that requesters can at least display the procedure even if the requester does not recognise the code supplied.
* `Procedure.code` contains the identification of the procedure which may include body site information. Where a system has information not supported by the coding in `Procedure.code.coding` (e.g. body site, laterality and other qualification of procedure coding terms) that information **SHOULD** be supplied in `Procedure.code.text`
* See the [Representing Body Site, Which May Include Laterality](general-guidance.md#representing-body-site-which-may-include-laterality) section for guidance on representing a relevant body site and associated laterality.
* The Procedure resource can represent a clinical indication with `Procedure.reasonCode`, or a reference with `Procedure.reasonReference` to a Condition or other resource. 
* Although both are marked as **Must Support**, responders are not required to support both a code and a reference, but they **SHALL** support **at least one** of these elements
* A requester **SHALL** support both elements
 
* A procedure including an implantable device is recommended to use `Procedure.focalDevice` with a reference to a Device resource

The additional obligation for `Procedure.performedDateTime` for [AU Core Responder](ActorDefinition-au-core-actor-responder.md) is [SHOULD:populate](https://hl7.org/fhir/extensions/CodeSystem-obligation.html#obligation-SHOULD.58populate). There is no additional obligation for [AU Core Requester](ActorDefinition-au-core-actor-requester.md), the obligation of [SHALL:no-error](https://hl7.org/fhir/extensions/CodeSystem-obligation.html#obligation-SHALL.58no-error) applies.

This obligation is present in the underlying structure but due to a tooling limitation is not currently rendered in the Formal Views of Profile Content. See [Zulip discussion](https://chat.fhir.org/#narrow/channel/179252-IG-creation/topic/Obligation.20Extension.20on.20ElementDefinition.2Etype.20not.20rendering) for more information.

**Usages:**

* Refer to this Profile: [AU Core Encounter](StructureDefinition-au-core-encounter.md) and [AU Core Procedure](StructureDefinition-au-core-procedure.md)
* Examples for this Profile: [Procedure/dialysis](Procedure-dialysis.md) and [Procedure/stentinsertion](Procedure-stentinsertion.md)
* CapabilityStatements using this Profile: [AU Core Requester CapabilityStatement](CapabilityStatement-au-core-requester.md) and [AU Core Responder CapabilityStatement](CapabilityStatement-au-core-responder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.core|current/StructureDefinition/au-core-procedure)

**Changes since version 1.0.0:**

* The resource metadata has changed (description)

* The data elements list has changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-core-procedure.csv), [Excel](StructureDefinition-au-core-procedure.xlsx), [Schematron](StructureDefinition-au-core-procedure.sch) 

### Notes:

Below is an overview of the mandatory and optional search parameters and combined search parameters. See the [AU Core CapabilityStatements](capability-statements.md) for a complete list of supported RESTful interactions for this IG.

FHIR search operations are described [here](http://hl7.org/fhir/R4/search.html) and the syntax used to describe AU Core interactions is defined [here](general-guidance.md#readsearch-syntax).

Any search parameter defined in FHIR may be 'allowed' by the system unless explicitly marked as "**SHALL NOT**". A few items are marked as **MAY** in this implementation guide to highlight their potential relevance.

* Parameter(s): patient
  * Conformance: **SHALL**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least an id value and**MAY**provide both the Type and id values. The responder**SHALL**support both.The requester**SHOULD**support chained search patient.identifier using IHI, Medicare Number, and DVA Number identifiers as defined in the AU Core Patient profile. The responder**SHOULD**support chained search patient.identifier using IHI, Medicare Number, and DVA Number identifiers as defined in the AU Core Patient profile.
* Parameter(s): patient+date
  * Conformance: **SHALL**
  * Type(s): `reference`+`date`
  * Requirements (when used alone or in combination): 
* Parameter(s): patient+code+date
  * Conformance: **SHOULD**
  * Type(s): `reference`+`token`+`date`
  * Requirements (when used alone or in combination): 
* Parameter(s): patient+status
  * Conformance: **SHOULD**
  * Type(s): `reference`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): code
  * Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least a code value and**MAY**provide both the system and code values. The responder**SHALL**support both.The requester**SHOULD**support`multipleOr`. The responder**SHOULD**support`multipleOr`.
* Parameter(s): date
  * Conformance: **MAY**
  * Type(s): `date`
  * Requirements (when used alone or in combination): A requester**SHALL**provide a value precise to the second + time offset. A responder**SHALL**support a value precise to the second + time offset.The requester**SHALL**support these search comparators`gt`,`lt`,`ge`,`le`. The responder**SHALL**support these search comparators`gt`,`lt`,`ge`,`le`.The requester**SHOULD**support`multipleAnd`, and if`multipleAnd`is supported,**SHALL**support the search comparators`gt`,`lt`,`ge`,`le`. The responder**SHOULD**support`multipleAnd`, and if`multipleAnd`is supported,**SHALL**support the search comparators`gt`,`lt`,`ge`,`le`.
* Parameter(s): status
  * Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least a code value and**MAY**provide both the system and code values. The responder**SHALL**support both.The requester**SHALL**support`multipleOr`. The responder**SHALL**support`multipleOr`.

#### Mandatory Search Parameters

The following search parameters and search parameter combinations **SHALL** be supported:

1. **SHALL**support searching using the**[`patient`](https://hl7.org/fhir/R4/procedure.html#search)**search parameter:
* **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)
`GET [base]/Procedure?patient={Type/}[id]` or optionally`GET [base]/Procedure?patient.identifier=[system|][code]`Example:
1. GET [base]/Procedure?patient=5678
1. GET [base]/Procedure?patient.identifier=http://ns.electronichealth.net.au/id/medicare-number|32788511952
1. GET [base]/Procedure?patient.identifier=http://ns.electronichealth.net.au/id/hi/ihi/1.0|8003608833357361
**Implementation Notes:** Fetches a bundle of all Procedure resources for the specified patient ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the combination of the**[`patient`](https://hl7.org/fhir/R4/procedure.html#search)**and**[`date`](https://hl7.org/fhir/R4/procedure.html#search)**search parameters:
* **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)
* **SHALL** support these `date` comparators: `gt,lt,ge,le`
* **SHOULD** support **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** search on `date` (e.g. `date=[date]&date=[date]]&...`), and if **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** is supported, **SHALL** support the search comparators `gt,lt,ge,le` `GET [base]/Procedure?patient={Type/}[id]&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`
Example:
1. GET [base]/Procedure?patient=5678&date=ge2020-01-01T00:00:00Z
1. GET [base]/Procedure?patient.identifier=http://example.org/fhir/mrn|12345&date=ge2020-01-01T00:00:00Z
**Implementation Notes:** Fetches a bundle of all Procedure resources for the specified patient and date ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by date](http://hl7.org/fhir/R4/search.html#date))

#### Optional Search Parameters

The following search parameters and search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the combination of the**[`patient`](https://hl7.org/fhir/R4/procedure.html#search)**and**[`code`](https://hl7.org/fhir/R4/procedure.html#search)**and**[`date`](https://hl7.org/fhir/R4/procedure.html#search)**search parameters:
* **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)
* **SHOULD** support **[multipleOr](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleOr)** search on `code` (e.g. `code={system|}[code],{system|}[code],...`)
* **SHALL** support these `date` comparators: `gt,lt,ge,le`
* **SHOULD** support **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** search on `date` (e.g. `date=[date]&date=[date]]&...`), and if **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** is supported, **SHALL** support the search comparators `gt,lt,ge,le`
`GET [base]/Procedure?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/Procedure?patient=5678&code=http://snomed.info/sct|26782000,http://snomed.info/sct|36969009&date=ge2020-01-01T00:00:00Z
1. GET [base]/Procedure?patient.identifier=http://example.org/fhir/mrn|12345&code=http://snomed.info/sct|26782000,http://snomed.info/sct|36969009&date=ge2020-01-01T00:00:00Z
**Implementation Notes:** Fetches a bundle of all Procedure resources for the specified patient and date and procedure code(s). **SHOULD** support search by multiple codes. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token) and [how to search by date](http://hl7.org/fhir/R4/search.html#date))
1. **SHOULD**support searching using the combination of the**[`patient`](https://hl7.org/fhir/R4/procedure.html#search)**and**[`status`](https://hl7.org/fhir/R4/procedure.html#search)**search parameters:
* **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)
* **SHALL** support **[multipleOr](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleOr)** search on `status` (e.g. `status={system|}[code],{system|}[code],...`)
`GET [base]/Procedure?patient={Type/}[id]&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Procedure?patient=5678&status=completed
**Implementation Notes:** Fetches a bundle of all Procedure resources for the specified patient and status ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-core-procedure",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-procedure",
  "version" : "2.0.0",
  "name" : "AUCoreProcedure",
  "title" : "AU Core Procedure",
  "status" : "active",
  "date" : "2026-01-28T05:31:23+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for a Procedure resource to record, search, and fetch procedures associated with a patient. It is based on the [AU Base Procedure](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-procedure.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Procedure resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Procedure",
  "baseDefinition" : "http://hl7.org.au/fhir/StructureDefinition/au-procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure",
        "path" : "Procedure"
      },
      {
        "id" : "Procedure.status",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Procedure.status",
        "mustSupport" : true
      },
      {
        "id" : "Procedure.code",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Procedure.code",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/procedure-1"
        }
      },
      {
        "id" : "Procedure.subject",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Procedure.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.encounter",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Procedure.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.performed[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Procedure.performed[x]",
        "type" : [
          {
            "extension" : [
              {
                "extension" : [
                  {
                    "url" : "code",
                    "valueCode" : "SHALL:populate-if-known"
                  },
                  {
                    "url" : "actor",
                    "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
                  }
                ],
                "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
              },
              {
                "extension" : [
                  {
                    "url" : "code",
                    "valueCode" : "SHOULD:populate"
                  },
                  {
                    "url" : "actor",
                    "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
                  }
                ],
                "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
              },
              {
                "extension" : [
                  {
                    "url" : "code",
                    "valueCode" : "SHALL:no-error"
                  },
                  {
                    "url" : "actor",
                    "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
                  }
                ],
                "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          },
          {
            "code" : "string"
          },
          {
            "code" : "Age"
          },
          {
            "code" : "Range"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.reasonCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Procedure.reasonCode",
        "mustSupport" : true
      },
      {
        "id" : "Procedure.reasonReference",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Procedure.reasonReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-condition",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-procedure",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.bodySite",
        "path" : "Procedure.bodySite",
        "condition" : ["au-core-pro-01"],
        "constraint" : [
          {
            "key" : "au-core-pro-01",
            "severity" : "error",
            "human" : "If a coded body site is provided, at least one coding shall be from SNOMED CT",
            "expression" : "coding.exists() implies coding.where(system='http://snomed.info/sct').exists()",
            "xpath" : "not(exists(f:coding/f:system)) or exists(f:coding/f:system[@value='http://snomed.info/sct'])",
            "source" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-procedure"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/body-site-1"
        }
      }
    ]
  }
}

```
