# AU Core Patient - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU Core Patient**

## Resource Profile: AU Core Patient 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient | *Version*:2.0.0 | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://hl7.org.au/fhir/6.0.0/generalguidance.html#maturity-levels): 2 | *Computable Name*:AUCorePatient |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile sets minimum expectations for a Patient resource to record, search, and fetch basic demographics and other administrative information about an individual patient. It is based on the [AU Base Patient](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-patient.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Patient when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. 

See [Comparison with other national and international IGs](comparison.md) for a comparison between AU Core profiles and profiles in other implementation guides.

### Usage Scenarios

The following are supported usage scenarios for this profile:

* Query for records associated with a patient
* Record or update a record associated with a patient
* Query for basic demographics and other administrative information about a patient
* Record or update basic demographics and other administrative information about a patient
* Read information about a patient referenced by another resource

### Profile Specific Implementation Guidance

* When populating `Patient.identifier`, responders are not required to populate all known patient identifiers from the source system. Responders: 
* **SHALL** populate with at least one identifier
* **SHALL** populate with at least one of the supported identifier types if known, or any known identifier when no supported identifier type is known
* **SHOULD** populate an IHI in preference to Medicare or DVA numbers where the IHI is known and **MAY** also provide a Medicare, DVA number, other identifier type or any combination of them
 
* See guidance on the construction of an identifier on the relevant Identifier profile page and the section on [Business Identifiers](https://hl7.org.au/fhir/6.0.0/generalguidance.html#business-identifiers) in AU Base.
* This profile supports the sex, gender, and related concepts of: Name to Use, Gender Identity, and Individual Pronouns. See the [Sex and Gender](sex-and-gender.md) page for guidance on exchanging sex and gender related concepts conformant to AU Core. 
* Sex Assigned at Birth is not marked as **Must Support** but may be exchanged using the [Person Recorded Sex or Gender extension](https://hl7.org/fhir/extensions/StructureDefinition-individual-recordedSexOrGender.html) as profiled by [AU Core Sex Assigned At Birth](StructureDefinition-au-core-rsg-sexassignedab.md)
 
* When constructing an address: 
* an international address can be represented using the core [Address](http://hl7.org/fhir/R4/datatypes.html#Address) data type
* an Australian address **SHOULD** be represented using the [Australian Address](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-address.html) data type profile
 
* Patient names can be provided as a text representation in `name.text` and/or parts such as `name.family` and `name.given`.
* `name.text` specifies the entire name as it is intended to be displayed. This may be provided instead of, or as well as, the specific parts. It is important to note that the presence of parts of a name, e.g. `name.family` and `name.given`, do not imply that `name.text` is known or needs to be supplied.
* In this profile, the following sub-elements of `name` are marked as **Must Support**: `name.use`, `name.text`, `name.family`, and `name.given` 
* responders are required to support at least one of the following sub-elements: `name.text`, `name.family`, and `name.given`
* requesters are required to support all sub-elements marked **Must Support**: `name.use`, `name.text`, `name.family`, and `name.given`
 
* See the section on [Representing Communication Preferences](https://hl7.org.au/fhir/6.0.0/generalguidance.html#representing-communication-preferences) for guidance on how to represent languages that can be used to communicate with the patient about their health including preferred language and if an interpreter is required.

**Usages:**

* Refer to this Profile: [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md), [AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md), [AU Core Body Height](StructureDefinition-au-core-bodyheight.md), [AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md)... Show 14 more, [AU Core Body Weight](StructureDefinition-au-core-bodyweight.md), [AU Core Condition](StructureDefinition-au-core-condition.md), [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md), [AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md), [AU Core Encounter](StructureDefinition-au-core-encounter.md), [AU Core Heart Rate](StructureDefinition-au-core-heartrate.md), [AU Core Immunization](StructureDefinition-au-core-immunization.md), [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md), [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md), [AU Core Procedure](StructureDefinition-au-core-procedure.md), [AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md), [AU Core Respiration Rate](StructureDefinition-au-core-resprate.md), [AU Core Smoking Status](StructureDefinition-au-core-smokingstatus.md) and [AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md)
* Examples for this Profile: [Patient/banks-mia-leanne](Patient-banks-mia-leanne.md), [Patient/bennelong-anne](Patient-bennelong-anne.md), [Patient/howe-deangelo](Patient-howe-deangelo.md), [Patient/ronny-irvine](Patient-ronny-irvine.md) and [Patient/wang-li](Patient-wang-li.md)
* CapabilityStatements using this Profile: [AU Core Requester CapabilityStatement](CapabilityStatement-au-core-requester.md) and [AU Core Responder CapabilityStatement](CapabilityStatement-au-core-responder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.core|current/StructureDefinition/au-core-patient)

**Changes since version 1.0.0:**

* The resource metadata has changed (description)

* The data elements list has changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-core-patient.csv), [Excel](StructureDefinition-au-core-patient.xlsx), [Schematron](StructureDefinition-au-core-patient.sch) 

### Notes:

Below is an overview of the mandatory and optional search parameters and combined search parameters. See the [AU Core CapabilityStatements](capability-statements.md) for a complete list of supported RESTful interactions for this IG.

FHIR search operations are described [here](http://hl7.org/fhir/R4/search.html) and the syntax used to describe AU Core interactions is defined [here](general-guidance.md#readsearch-syntax).

Any search parameter defined in FHIR may be 'allowed' by the system unless explicitly marked as "**SHALL NOT**". A few items are marked as **MAY** in this implementation guide to highlight their potential relevance. 

**Note:** Support for _id is mandatory for a responder and optional for a requester. Where the expectation for a search parameter differs between actors, the table below will reflect the stronger conformance requirement.

* Parameter(s): _id
  * Conformance: **SHALL**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): identifier
  * Conformance: **SHALL**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide both the system and code values. The responder**SHALL**support both.The requester**SHOULD**support search using IHI, Medicare Number, and DVA Number identifiers as defined in the profile. The responder**SHOULD**support search using the using IHI, Medicare Number, and DVA Number identifiers as defined in the profile.
* Parameter(s): birthdate+family
  * Conformance: **SHOULD**
  * Type(s): `date`+`string`
  * Requirements (when used alone or in combination): 
* Parameter(s): birthdate+name
  * Conformance: **SHOULD**
  * Type(s): `date`+`string`
  * Requirements (when used alone or in combination): 
* Parameter(s): family
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): family+gender
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): gender+name
  * Conformance: **SHOULD**
  * Type(s): `token`+`string`
  * Requirements (when used alone or in combination): 
* Parameter(s): name
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): birthdate
  * Conformance: **MAY**
  * Type(s): `date`
  * Requirements (when used alone or in combination): A requester**SHALL**provide a value precise to the day. A responder**SHALL**support a value precise to the day.The requester**SHOULD**support these search comparators`gt`,`lt`,`ge`,`le`. The responder**SHOULD**support these search comparators`gt`,`lt`,`ge`,`le`.The requester**SHOULD**support`multipleAnd`, and if`multipleAnd`is supported,**SHALL**support the search comparators`gt`,`lt`,`ge`,`le`. The responder**SHOULD**support`multipleAnd`, and if`multipleAnd`is supported,**SHALL**support the search comparators`gt`,`lt`,`ge`,`le`.
* Parameter(s): gender
  * Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least a code value and**MAY**provide both the system and code values. The responder**SHALL**support both.
* Parameter(s): indigenous-status
  * Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least a code value and**MAY**provide both the system and code values. The responder**SHALL**support both.
* Parameter(s): gender-identity
  * Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least a code value and**MAY**provide both the system and code values. The responder**SHALL**support both.

#### Mandatory Search Parameters

The following search parameters **SHALL** be supported:

1. **SHALL** support searching using the **[`_id`](https://hl7.org/fhir/R4/patient.html#search)** search parameter:`GET [base]/Patient?_id=[id]`Example:
1. GET [base]/Patient?_id=5678
**Implementation Notes:** Fetches a bundle with the requested Patient, instead of just the resource itself, and allows for the inclusion of additional search parameters such as _include, _revinclude, or _lastUpdated ([how to search by id of the resource](https://hl7.org/fhir/r4/search.html#id)).
1. **SHALL** support searching using the **[`identifier`](https://hl7.org/fhir/R4/patient.html#search)** search parameter:`GET [base]/Patient?identifier=[system|][code]`Example:
1. GET [base]/Patient?identifier=http://ns.electronichealth.net.au/id/medicare-number|32788511952
1. GET [base]/Patient?identifier=http://ns.electronichealth.net.au/id/hi/ihi/1.0|8003608833357361
1. GET [base]/Patient?identifier=http://example.org/fhir/mrn|12345
**Implementation Notes:** Fetches a bundle containing all Patient resources matching the identifier ([how to search by token](http://hl7.org/fhir/R4/search.html#token))

#### Optional Search Parameters:

The following search parameters and search parameter combinations **SHOULD** be supported:

1. **SHOULD** support searching by a responder-defined search that matches any string field in HumanName, including family, given, prefix, suffix, and/or text using the **[`name`](https://hl7.org/fhir/R4/patient.html#search)** search parameter:`GET [base]/Patient?name=[string]`Example:
1. GET [base]/Patient?name=Wang
1. GET [base]/Patient?name=Wang

1. **SHOULD** support searching using the combination of the **[`gender`](https://hl7.org/fhir/R4/patient.html#search)** and **[`name`](https://hl7.org/fhir/R4/patient.html#search)** search parameters:`GET [base]/Patient?gender={system|}[code]&name=[string]`Example:
1. GET [base]/Patient?name=Wang&gender=female
**Implementation Notes:** Fetches a bundle of all Patient resources matching the specified gender and name ([how to search by string](http://hl7.org/fhir/R4/search.html#string) and [how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`birthdate`](https://hl7.org/fhir/R4/patient.html#search)**and**[`family`](https://hl7.org/fhir/R4/patient.html#search)**search parameters:
* **SHOULD** support these `date` comparators: `gt,lt,ge,le`
* **SHOULD** support **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** search on `date` (e.g. `date=[date]&date=[date]]&...`), and if **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** is supported, **SHALL** support the search comparators `gt,lt,ge,le`
`GET [base]/Patient?birthdate=[date]&family=[string]`Example:
1. GET [base]/Patient?family=Wang&birthdate=2007-03-20
**Implementation Notes:** Fetches a bundle of all Patient resources matching the specified birthdate and family ([how to search by date](http://hl7.org/fhir/R4/search.html#date) and [how to search by string](http://hl7.org/fhir/R4/search.html#string))
1. **SHOULD**support searching using the combination of the**[`birthdate`](https://hl7.org/fhir/R4/patient.html#search)**and**[`name`](https://hl7.org/fhir/R4/patient.html#search)**search parameters:
* **SHOULD** support these `date` comparators: `gt,lt,ge,le`
* **SHOULD** support **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** search on `date` (e.g. `date=[date]&date=[date]]&...`) and if **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd), and if *[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** is supported, **SHALL** support the search comparators `gt,lt,ge,le`
`GET [base]/Patient?birthdate=[date]&name=[string]`Example:
1. GET [base]/Patient?name=Wang&birthdate=2007-03-20gt
**Implementation Notes:** Fetches a bundle of all Patient resources matching the name and a birthdate greater than that specified ([how to search by date](http://hl7.org/fhir/R4/search.html#date) and [how to search by string](http://hl7.org/fhir/R4/search.html#string))
1. **SHOULD** support searching using the combination of the **[`family`](https://hl7.org/fhir/R4/patient.html#search)** and **[`gender`](https://hl7.org/fhir/R4/patient.html#search)** search parameters:`GET [base]/Patient?family=[string]&gender={system|}[code]`Example:
1. GET [base]/Patient?family=Wang&gender=female
**Implementation Notes:** Fetches a bundle of all Patient resources matching the specified family and gender ([how to search by string](http://hl7.org/fhir/R4/search.html#string) and [how to search by token](http://hl7.org/fhir/R4/search.html#token))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-core-patient",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient",
  "version" : "2.0.0",
  "name" : "AUCorePatient",
  "title" : "AU Core Patient",
  "status" : "active",
  "date" : "2026-01-28T05:31:23+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for a Patient resource to record, search, and fetch basic demographics and other administrative information about an individual patient. It is based on the [AU Base Patient](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-patient.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Patient when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org.au/fhir/StructureDefinition/au-patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "short" : "A patient in the context of electronic exchange of health information",
        "constraint" : [
          {
            "key" : "au-core-pat-01",
            "severity" : "error",
            "human" : "At least one patient identifier shall be valid, or if not available, the Data Absent Reason extension shall be present",
            "expression" : "(identifier.where(system.count() + value.count() >1)).exists() xor identifier.extension('http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "xpath" : "(exists(f:identifier/f:system) and exists(f:identifier/f:value)) and not(exists(f:identifier/f:extension[@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason'])) or not(exists(f:identifier/f:system) and exists(f:identifier/f:value)) and exists(f:identifier/f:extension[@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason'])"
          },
          {
            "key" : "au-core-pat-02",
            "severity" : "error",
            "human" : "At least one patient name shall have a family name, or if not available, the Data Absent Reason extension shall be present",
            "expression" : "name.family.exists() xor name.extension('http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "xpath" : "(exists(f:name/f:family) and not(exists(f:name/f:extension[@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason']))) or (not(exists(f:name/f:family)) and exists(f:name/f:extension[@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason']))",
            "source" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
          }
        ]
      },
      {
        "id" : "Patient.extension:indigenousStatus",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.extension",
        "sliceName" : "indigenousStatus",
        "mustSupport" : true
      },
      {
        "id" : "Patient.extension:genderIdentity",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.extension",
        "sliceName" : "genderIdentity",
        "short" : "Gender identity shall be a member of the Gender Identity Response value set if any codes within that value set can apply",
        "mustSupport" : true
      },
      {
        "id" : "Patient.extension:individualPronouns",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.extension",
        "sliceName" : "individualPronouns",
        "short" : "Pronouns shall be a member of the Australian Pronouns value set if any codes within that value set can apply",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "type"
            }
          ],
          "rules" : "open"
        },
        "min" : 1,
        "condition" : ["au-core-pat-01"],
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:ihi",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.identifier",
        "sliceName" : "ihi",
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://hl7.org.au/fhir/StructureDefinition/au-ihi"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:medicare",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.identifier",
        "sliceName" : "medicare",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://hl7.org.au/fhir/StructureDefinition/au-medicarecardnumber"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:dva",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.identifier",
        "sliceName" : "dva",
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://hl7.org.au/fhir/StructureDefinition/au-dvanumber"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name",
        "comment" : "A patient may have multiple names with different uses or applicable periods. At least one name SHOULD be the name the patient is considered to have for administrative and record keeping purposes - family name is used to enable matching against patient records.",
        "min" : 1,
        "condition" : ["au-core-pat-02"],
        "constraint" : [
          {
            "key" : "au-core-pat-03",
            "severity" : "error",
            "human" : "At least text, family name, or given name shall be present, or if neither is available, the Data Absent Reason extension shall be present",
            "expression" : "(text.exists() or family.exists() or given.exists()) xor extension('http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "xpath" : "(exists(f:text) or exists(f:family) or exists(f:given)) and not (exists(f:text) and exists(f:family) and exists(f:given)) or exists(f:extension[@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason'])",
            "source" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.use",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name.use",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name.text",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.family",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name.family",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.given",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name.given",
        "mustSupport" : true
      },
      {
        "id" : "Patient.telecom",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.telecom",
        "mustSupport" : true
      },
      {
        "id" : "Patient.telecom.system",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.telecom.system",
        "mustSupport" : true
      },
      {
        "id" : "Patient.telecom.value",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.telecom.value",
        "mustSupport" : true
      },
      {
        "id" : "Patient.telecom.use",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.telecom.use",
        "mustSupport" : true
      },
      {
        "id" : "Patient.gender",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.gender",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.birthDate",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.birthDate",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.address",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address",
        "mustSupport" : true
      },
      {
        "id" : "Patient.communication",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.communication",
        "mustSupport" : true
      },
      {
        "id" : "Patient.communication.language",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.communication.language",
        "mustSupport" : true
      },
      {
        "id" : "Patient.communication.preferred",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.communication.preferred",
        "mustSupport" : true
      }
    ]
  }
}

```
