# AU Core Location - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU Core Location**

## Resource Profile: AU Core Location 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/core/StructureDefinition/au-core-location | *Version*:2.0.0 | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://hl7.org.au/fhir/6.0.0/generalguidance.html#maturity-levels): 2 | *Computable Name*:AUCoreLocation |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile sets minimum expectations for a Location resource to record, search, and fetch information about a location. It is based on the [AU Base Location](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-location.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Location when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. 

See [Comparison with other national and international IGs](comparison.md) for a comparison between AU Core profiles and profiles in other implementation guides.

### Usage Scenarios

The following are supported usage scenarios for this profile:

* Record or update basic information for a location
* Read information about a location referenced by another resource

### Profile Specific Implementation Guidance

* See guidance on the construction of an identifier on the relevant Identifier profile page and the section on [Business Identifiers](https://hl7.org.au/fhir/6.0.0/generalguidance.html#business-identifiers) in AU Base.
* See the [AU Base Location](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-location.html) profile for guidance on using a Location resource as part of defining a type of mobile or remotely delivered service.
* When constructing an address 
* an international address can be represented using the core [Address](http://hl7.org/fhir/R4/datatypes.html#Address) data type
* an Australian address **SHOULD** be represented using the [Australian Address](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-address.html) data type profile
 

**Usages:**

* Refer to this Profile: [AU Core Encounter](StructureDefinition-au-core-encounter.md)
* Examples for this Profile: [Tindal Building](Location-bobrester-medical-center.md), [Murrabit Public Hospital](Location-murrabit-hospital.md) and [Patient's home](Location-patient-home.md)
* CapabilityStatements using this Profile: [AU Core Requester CapabilityStatement](CapabilityStatement-au-core-requester.md) and [AU Core Responder CapabilityStatement](CapabilityStatement-au-core-responder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.core|current/StructureDefinition/au-core-location)

**Changes since version 1.0.0:**

* The resource metadata has changed (description)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-core-location.csv), [Excel](StructureDefinition-au-core-location.xlsx), [Schematron](StructureDefinition-au-core-location.sch) 

### Notes:

Below is an overview of the mandatory and optional search parameters and combined search parameters. See the [AU Core CapabilityStatements](capability-statements.md) for a complete list of supported RESTful interactions for this IG.

FHIR search operations are described [here](http://hl7.org/fhir/R4/search.html) and the syntax used to describe AU Core interactions is defined [here](general-guidance.md#readsearch-syntax).

Any search parameter defined in FHIR may be 'allowed' by the system unless explicitly marked as "**SHALL NOT**". A few items are marked as **MAY** in this implementation guide to highlight their potential relevance.

* Parameter(s): name
  * Conformance: **SHALL**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): address
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): address-city
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): address-state
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): address-postalcode
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 

#### Mandatory Search Parameters

1. **SHALL** support searching based on text name using the **[`name`](https://hl7.org/fhir/R4/location.html#search)** search parameter:`GET [base]/Location?name=[string]`Example:
1. GET [base]/Location?name=Hospital
**Implementation Notes:** Fetches a bundle of all Location resources matching the name ([how to search by string](http://hl7.org/fhir/R4/search.html#string))

#### Optional Search Parameters:

The following search parameters **SHOULD** be supported:

1. **SHOULD** support searching based on text address using the **[`address`](https://hl7.org/fhir/R4/location.html#search)** search parameter:`GET [base]/Location?address=[string]`Example:
1. GET [base]/Location?address=QLD
**Implementation Notes:** Fetches a bundle of all Location resources matching the address ([how to search by string](http://hl7.org/fhir/R4/search.html#string))
1. **SHOULD** support searching using the **[`address-city`](https://hl7.org/fhir/R4/location.html#search)** search parameter:`GET [base]/Location?address-city=[string]`Example:
1. GET [base]/Location?address-city=Westmead
**Implementation Notes:** Fetches a bundle of all Location resources for the city ([how to search by string](http://hl7.org/fhir/R4/search.html#string))
1. **SHOULD** support searching using the **[`addresss-postalcode`](https://hl7.org/fhir/R4/location.html#search)** search parameter:`GET [base]/Location?addresss-postalcode=[string]`Example:
1. GET [base]/Location?addresss-postalcode=3005
**Implementation Notes:** Fetches a bundle of all Location resources matching the post code ([how to search by string](http://hl7.org/fhir/R4/search.html#string))
1. **SHOULD** support searching using the **[`address-state`](https://hl7.org/fhir/R4/location.html#search)** search parameter:`GET [base]/Location?address-state=[string]`Example:
1. GET [base]/Location?address-state=TAS
**Implementation Notes:** Fetches a bundle of all Location resources matching the state ([how to search by string](http://hl7.org/fhir/R4/search.html#string))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-core-location",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-location",
  "version" : "2.0.0",
  "name" : "AUCoreLocation",
  "title" : "AU Core Location",
  "status" : "active",
  "date" : "2026-01-28T05:31:23+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for a Location resource to record, search, and fetch information about a location. It is based on the [AU Base Location](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-location.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Location when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "http://hl7.org.au/fhir/StructureDefinition/au-location",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location",
        "path" : "Location",
        "short" : "A location in an Australian healthcare context",
        "constraint" : [
          {
            "key" : "au-core-loc-01",
            "severity" : "error",
            "human" : "The location shall at least have a valid identifier or address or type",
            "expression" : "address.exists() or type.exists() or identifier.where(system.count() + value.count() >1).exists()",
            "xpath" : "exists(f:address) or exists(f:type) or exists(f:identifier)",
            "source" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-location"
          }
        ]
      },
      {
        "id" : "Location.identifier",
        "path" : "Location.identifier",
        "condition" : ["au-core-loc-01"]
      },
      {
        "id" : "Location.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Location.name",
        "mustSupport" : true
      },
      {
        "id" : "Location.type",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Location.type",
        "condition" : ["au-core-loc-01"],
        "mustSupport" : true
      },
      {
        "id" : "Location.address",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Location.address",
        "condition" : ["au-core-loc-01"],
        "mustSupport" : true
      },
      {
        "id" : "Location.physicalType",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Location.physicalType",
        "mustSupport" : true
      },
      {
        "id" : "Location.managingOrganization",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Location.managingOrganization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
