# AUCorePractitionerRolePractitioner - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AUCorePractitionerRolePractitioner**

## SearchParameter: AUCorePractitionerRolePractitioner 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/core/SearchParameter/au-core-practitionerrole-practitioner | *Version*:2.0.0 | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://hl7.org.au/fhir/6.0.0/generalguidance.html#maturity-levels): 2 | *Computable Name*:AUCorePractitionerRolePractitioner |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This SearchParameter describes the rules on the PractitionerRole-practitioner search parameter in AU Core. It is based on the FHIR [PractitionerRole-practitioner](https://hl7.org/fhir/R4/practitionerrole.html#search) search parameter and identifies the additional requirements when conforming to AU Core. 



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "au-core-practitionerrole-practitioner",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/core/SearchParameter/au-core-practitionerrole-practitioner",
  "version" : "2.0.0",
  "name" : "AUCorePractitionerRolePractitioner",
  "derivedFrom" : "http://hl7.org/fhir/SearchParameter/PractitionerRole-practitioner",
  "status" : "active",
  "date" : "2026-01-28T05:31:23+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This SearchParameter describes the rules on the PractitionerRole-practitioner search parameter in AU Core. It is based on the FHIR [PractitionerRole-practitioner](https://hl7.org/fhir/R4/practitionerrole.html#search) search parameter and identifies the additional requirements when conforming to AU Core.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "code" : "practitioner",
  "base" : ["PractitionerRole"],
  "type" : "reference",
  "expression" : "PractitionerRole.practitioner",
  "target" : ["Practitioner"],
  "multipleOr" : true,
  "_multipleOr" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
        "valueCode" : "MAY"
      }
    ]
  },
  "multipleAnd" : true,
  "_multipleAnd" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
        "valueCode" : "MAY"
      }
    ]
  },
  "chain" : ["identifier"],
  "_chain" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHOULD"
        }
      ]
    }
  ]
}

```
