# RelatedPerson - Friend of Mr. Li Wang - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **RelatedPerson - Friend of Mr. Li Wang**

## Example RelatedPerson: RelatedPerson - Friend of Mr. Li Wang

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md)

**patient**: [Li Wang Male, DoB: 1975-05-03 ( Medical Record Number: 22421441)](Patient-wang-li.md)

**relationship**: unrelated friend

**name**: Peter Rabbit Rabbit 

**telecom**: ph: 07 853 9191(Home)

**address**: 29 Gadsby Street Blacktown NSW 2148 AU (home)



## Resource Content

```json
{
  "resourceType" : "RelatedPerson",
  "id" : "wang-li-friend",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-relatedperson"
    ]
  },
  "patient" : {
    "reference" : "Patient/wang-li"
  },
  "relationship" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "FRND",
          "display" : "unrelated friend"
        },
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
          "code" : "C",
          "display" : "Emergency Contact"
        }
      ]
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Rabbit",
      "given" : ["Peter", "Rabbit"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "07 853 9191",
      "use" : "home"
    }
  ],
  "address" : [
    {
      "use" : "home",
      "line" : ["29 Gadsby Street"],
      "city" : "Blacktown",
      "state" : "NSW",
      "postalCode" : "2148",
      "country" : "AU"
    }
  ]
}

```
