# Procedure - Dialysis - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Procedure - Dialysis**

## Example Procedure: Procedure - Dialysis

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Procedure](StructureDefinition-au-core-procedure.md)

**status**: Completed

**code**: Haemodialysis

**subject**: [Ronny Lawrence Irvine Male, DoB: ( DVA Number: QX827261)](Patient-ronny-irvine.md)

**performed**: 2012-08-05

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [PractitionerRole Nephrologist](PractitionerRole-nephrologist-darleen-mackay.md) |

**reasonReference**: [Chronic Kidney Disease](Condition-ckd.md)



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "dialysis",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-procedure"
    ]
  },
  "status" : "completed",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "302497006",
        "display" : "Haemodialysis"
      }
    ],
    "text" : "Haemodialysis"
  },
  "subject" : {
    "reference" : "Patient/ronny-irvine"
  },
  "performedDateTime" : "2012-08-05",
  "performer" : [
    {
      "actor" : {
        "reference" : "PractitionerRole/nephrologist-darleen-mackay"
      }
    }
  ],
  "reasonReference" : [
    {
      "reference" : "Condition/ckd",
      "display" : "Chronic Kidney Disease"
    }
  ]
}

```
