# Practitioner - Dr. Sallie Sutherland - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Practitioner - Dr. Sallie Sutherland**

## Example Practitioner: Practitioner - Dr. Sallie Sutherland

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Practitioner](StructureDefinition-au-core-practitioner.md)

**identifier**: HPI-I/8003618233385086

**name**: Sallie Sutherland (Official)



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "sallie-sutherland",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NPI",
            "display" : "National provider identifier"
          }
        ],
        "text" : "HPI-I"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/hpii/1.0",
      "value" : "8003618233385086"
    }
  ],
  "name" : [
    {
      "use" : "official",
      "family" : "Sutherland",
      "given" : ["Sallie"],
      "prefix" : ["Dr."]
    }
  ]
}

```
