# Patient - Mrs. Anne Bennelong - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Patient - Mrs. Anne Bennelong**

## Example Patient: Patient - Mrs. Anne Bennelong

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Patient](StructureDefinition-au-core-patient.md)

Mrs. Anne Mary Bennelong(official) Female, DoB: 1968-10-11 ( Medical record number)

-------

| | |
| :--- | :--- |
| Contact Detail | * ph: 0491 572 665(Mobile)
* 144 Otho Street Inverell NSW 2360 AU (home)
 |
| Language: | Yugambal |
| [Australian Indigenous Status](http://hl7.org.au/fhir/6.0.0/StructureDefinition-indigenous-status.html) | australian-indigenous-status-1: 1 (Aboriginal but not Torres Strait Islander origin) |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "bennelong-anne",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/StructureDefinition/indigenous-status",
      "valueCoding" : {
        "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1",
        "code" : "1",
        "display" : "Aboriginal but not Torres Strait Islander origin"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR"
          }
        ]
      },
      "system" : "http://mossypointmc.example.com/mrn/",
      "value" : "872038020",
      "assigner" : {
        "display" : "Mossy Point Medical Centre"
      }
    }
  ],
  "name" : [
    {
      "use" : "official",
      "text" : "Mrs. Anne Mary Bennelong",
      "family" : "Bennelong",
      "given" : ["Anne"],
      "prefix" : ["Mrs"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0491 572 665",
      "use" : "mobile"
    }
  ],
  "gender" : "female",
  "birthDate" : "1968-10-11",
  "address" : [
    {
      "use" : "home",
      "line" : ["144 Otho Street"],
      "city" : "Inverell",
      "state" : "NSW",
      "postalCode" : "2360",
      "country" : "AU"
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "yub"
          }
        ],
        "text" : "Yugambal"
      }
    }
  ]
}

```
