# Patient - Mia Leanne Banks - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Patient - Mia Leanne Banks**

## Example Patient: Patient - Mia Leanne Banks

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Patient](StructureDefinition-au-core-patient.md)

Mia Leanne Banks Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)

-------

| | |
| :--- | :--- |
| Contact Detail | * ph: 0270102724(Work)
* ph: 0491574632(Mobile)
* ph: 0270107520(Home)
* [mia.banks@myownpersonaldomain.com](mailto:mia.banks@myownpersonaldomain.com)
* ph: 270107520(Home)
* 50 Sebastien St Minjary NSW 2720 AU 
 |
| Individual Pronouns: | * value: she/her/her/hers/herself
 |
| Person Recorded Sex Or Gender: | * value: Female
* type: Biological sex at birth
 |
| Individual Gender Identity: | * value: Identifies as female gender
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "banks-mia-leanne",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-genderIdentity",
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "446141000124107",
                "display" : "Identifies as female gender"
              }
            ]
          }
        }
      ]
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-pronouns",
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "LA29519-8",
                "display" : "she/her/her/hers/herself"
              }
            ]
          }
        }
      ]
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender",
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "248152002"
              }
            ],
            "text" : "Female"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "1515311000168102",
                "display" : "Biological sex at birth"
              }
            ]
          }
        }
      ]
    }
  ],
  "identifier" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-status",
          "valueCoding" : {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-status-1",
            "code" : "active"
          }
        },
        {
          "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-record-status",
          "valueCoding" : {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-record-status-1",
            "code" : "verified",
            "display" : "verified"
          }
        }
      ],
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NI"
          }
        ],
        "text" : "IHI"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/ihi/1.0",
      "value" : "8003608333647261"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Banks",
      "given" : ["Mia", "Leanne"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0270102724",
      "use" : "work"
    },
    {
      "system" : "phone",
      "value" : "0491574632",
      "use" : "mobile"
    },
    {
      "system" : "phone",
      "value" : "0270107520",
      "use" : "home"
    },
    {
      "system" : "email",
      "value" : "mia.banks@myownpersonaldomain.com"
    },
    {
      "system" : "phone",
      "value" : "270107520",
      "use" : "home"
    }
  ],
  "gender" : "female",
  "birthDate" : "1983-08-25",
  "address" : [
    {
      "line" : ["50 Sebastien St"],
      "city" : "Minjary",
      "state" : "NSW",
      "postalCode" : "2720",
      "country" : "AU"
    }
  ]
}

```
