# Organization - Murrabit Public Hospital - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Organization - Murrabit Public Hospital**

## Example Organization: Organization - Murrabit Public Hospital

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Organization](StructureDefinition-au-core-organization.md)

**identifier**: HPI-O/8003626566706976

**type**: Hospital

**name**: Murrabit Public Hospital

**telecom**: ph: 0355509111, ph: 0355508677, [reception@murrabitph.example.com.au](mailto:reception@murrabitph.example.com.au)

**address**: 144 Central Gdns Murrabit VIC 3579 AU 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "murrabit-hospital",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "NOI",
            "display" : "National Organisation Identifier"
          }
        ],
        "text" : "HPI-O"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/hpio/1.0",
      "value" : "8003626566706976"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "22232009",
          "display" : "Hospital"
        },
        {
          "system" : "http://www.abs.gov.au/ausstats/abs@.nsf/mf/1292.0",
          "code" : "8401",
          "display" : "Hospitals (Except Psychiatric Hospitals)"
        }
      ]
    }
  ],
  "name" : "Murrabit Public Hospital",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0355509111"
    },
    {
      "system" : "phone",
      "value" : "0355508677"
    },
    {
      "system" : "email",
      "value" : "reception@murrabitph.example.com.au"
    }
  ],
  "address" : [
    {
      "line" : ["144 Central Gdns"],
      "city" : "Murrabit",
      "state" : "VIC",
      "postalCode" : "3579",
      "country" : "AU"
    }
  ]
}

```
