# Observation - Waist Circumference - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Observation - Waist Circumference**

## Example Observation: Observation - Waist Circumference

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md)

**status**: Final

**category**: Vital Signs

**code**: Waist Circumference

**subject**: [Mia Leanne Banks Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)](Patient-banks-mia-leanne.md)

**effective**: 2023-03-14

**performer**: [PractitionerRole General practitioner](PractitionerRole-bobrester-bob-gp.md)

**value**: 78.6 cm (Details: UCUM codecm = 'cm')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "waistcircum-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-waistcircum"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "8280-0",
        "display" : "Waist Circumference at umbilicus by Tape measure"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "276361009",
        "display" : "Waist circumference"
      }
    ],
    "text" : "Waist Circumference"
  },
  "subject" : {
    "reference" : "Patient/banks-mia-leanne"
  },
  "effectiveDateTime" : "2023-03-14",
  "performer" : [
    {
      "reference" : "PractitionerRole/bobrester-bob-gp"
    }
  ],
  "valueQuantity" : {
    "value" : 78.6,
    "unit" : "cm",
    "system" : "http://unitsofmeasure.org",
    "code" : "cm"
  }
}

```
