# Observation - Total Cholesterol/HDL ratio - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Observation - Total Cholesterol/HDL ratio**

## Example Observation: Observation - Total Cholesterol/HDL ratio

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md)

**status**: Final

**category**: Laboratory, Chemistry

**code**: Total Chol/HDL

**subject**: [Mia Leanne Banks Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)](Patient-banks-mia-leanne.md)

**effective**: 2023-01-17

**value**: 3.93

**interpretation**: Normal

### ReferenceRanges

| | |
| :--- | :--- |
| - | **High** |
| * | 4.6 |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "lipid-total-chol-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult-path"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory",
          "display" : "Laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "CH",
          "display" : "Chemistry"
        }
      ],
      "text" : "Chemistry"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "32309-7",
        "display" : "Cholesterol.total/Cholesterol in HDL [Molar ratio] in Serum or Plasma"
      }
    ],
    "text" : "Total Chol/HDL"
  },
  "subject" : {
    "reference" : "Patient/banks-mia-leanne"
  },
  "effectiveDateTime" : "2023-01-17",
  "valueQuantity" : {
    "value" : 3.93
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "N",
          "display" : "Normal"
        }
      ]
    }
  ],
  "referenceRange" : [
    {
      "high" : {
        "value" : 4.6
      }
    }
  ]
}

```
