# Observation - LDL - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Observation - LDL**

## Example Observation: Observation - LDL

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md)

**status**: Final

**category**: Laboratory, Chemistry

**code**: LDL

**subject**: [Mia Leanne Banks Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)](Patient-banks-mia-leanne.md)

**effective**: 2023-01-17

**value**: 4.10 mmol/L (Details: UCUM codemmol/L = 'mmol/L')

**interpretation**: High

### ReferenceRanges

| | | |
| :--- | :--- | :--- |
| - | **Low** | **High** |
| * | 2.0 mmol/L (Details: UCUM codemmol/L = 'mmol/L') | 3.4 mmol/L (Details: UCUM codemmol/L = 'mmol/L') |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "lipid-ldl-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult-path"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory",
          "display" : "Laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "CH",
          "display" : "Chemistry"
        }
      ],
      "text" : "Chemistry"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "22748-8",
        "display" : "Cholesterol in LDL [Moles/volume] in Serum or Plasma"
      }
    ],
    "text" : "LDL"
  },
  "subject" : {
    "reference" : "Patient/banks-mia-leanne"
  },
  "effectiveDateTime" : "2023-01-17",
  "valueQuantity" : {
    "value" : 4.10,
    "unit" : "mmol/L",
    "system" : "http://unitsofmeasure.org",
    "code" : "mmol/L"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "H",
          "display" : "High"
        }
      ]
    }
  ],
  "referenceRange" : [
    {
      "low" : {
        "value" : 2.0,
        "unit" : "mmol/L",
        "system" : "http://unitsofmeasure.org",
        "code" : "mmol/L"
      },
      "high" : {
        "value" : 3.4,
        "unit" : "mmol/L",
        "system" : "http://unitsofmeasure.org",
        "code" : "mmol/L"
      }
    }
  ]
}

```
