# Observation - Temperature - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Observation - Temperature**

## Example Observation: Observation - Temperature

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md)

**status**: Final

**category**: Vital Signs

**code**: Body temperature

**subject**: [Mrs. Anne Mary Bennelong(official) Female, DoB: 1968-10-11 ( Medical record number)](Patient-bennelong-anne.md)

**effective**: 2022-02-10

**value**: 36.5 C (Details: UCUM codeCel = 'Cel')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "bodytemp-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-bodytemp"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "8310-5",
        "display" : "Body temperature"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "386725007"
      }
    ],
    "text" : "Body temperature"
  },
  "subject" : {
    "reference" : "Patient/bennelong-anne"
  },
  "effectiveDateTime" : "2022-02-10",
  "valueQuantity" : {
    "value" : 36.5,
    "unit" : "C",
    "system" : "http://unitsofmeasure.org",
    "code" : "Cel"
  }
}

```
