# Observation - Height - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Observation - Height**

## Example Observation: Observation - Height

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Body Height](StructureDefinition-au-core-bodyheight.md)

**status**: Final

**category**: Vital Signs

**code**: height

**subject**: [Li Wang Male, DoB: 1975-05-03 ( Medical Record Number: 22421441)](Patient-wang-li.md)

**effective**: 2016-07-02

**value**: 175 cm (Details: UCUM codecm = 'cm')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "bodyheight-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-bodyheight"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "8302-2",
        "display" : "Body height"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "50373000"
      }
    ],
    "text" : "height"
  },
  "subject" : {
    "reference" : "Patient/wang-li"
  },
  "effectiveDateTime" : "2016-07-02",
  "valueQuantity" : {
    "value" : 175,
    "unit" : "cm",
    "system" : "http://unitsofmeasure.org",
    "code" : "cm"
  }
}

```
