# MedicationStatement - completed use of Bactrim DS - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **MedicationStatement - completed use of Bactrim DS**

## Example MedicationStatement: MedicationStatement - completed use of Bactrim DS

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md)

**status**: Completed

**medication**: Bactrim DS - tablet

**subject**: [Mia Leanne Banks Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)](Patient-banks-mia-leanne.md)

**dateAsserted**: 2020-05-30 10:00:00+1000

**reasonReference**: [Condition Urinary tract infection](Condition-uti.md)



## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "completed-bactrim",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement"
    ]
  },
  "status" : "completed",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "6632011000036102",
        "display" : "Bactrim DS tablet"
      },
      {
        "system" : "http://pbs.gov.au/code/item",
        "code" : "2951H"
      }
    ],
    "text" : "Bactrim DS - tablet"
  },
  "subject" : {
    "reference" : "Patient/banks-mia-leanne"
  },
  "dateAsserted" : "2020-05-30T10:00:00+10:00",
  "reasonReference" : [
    {
      "reference" : "Condition/uti"
    }
  ]
}

```
