# MedicationRequest - active prescription, Reaptan - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **MedicationRequest - active prescription, Reaptan**

## Example MedicationRequest: MedicationRequest - active prescription, Reaptan

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "reaptan",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationrequest"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Medication",
      "id" : "med1",
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "926213011000036100"
          }
        ],
        "text" : "Reaptan 10 mg/10 mg (perindopril arginine/amlodipine) tablet, 10"
      }
    }
  ],
  "status" : "active",
  "intent" : "order",
  "medicationReference" : {
    "reference" : "#med1"
  },
  "subject" : {
    "reference" : "Patient/wang-li"
  },
  "authoredOn" : "2018-07-15",
  "requester" : {
    "reference" : "PractitionerRole/surgeon-chau-fryer"
  },
  "reasonCode" : [
    {
      "text" : "Hypertension"
    }
  ],
  "dosageInstruction" : [
    {
      "text" : "1 tablet daily",
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "26643006",
            "display" : "Oral route"
          }
        ]
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "TAB",
            "system" : "http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm",
            "code" : "TAB"
          }
        }
      ]
    }
  ]
}

```
