# HealthcareService - Murrabit Crisis Hotline - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **HealthcareService - Murrabit Crisis Hotline**

## Example HealthcareService: HealthcareService - Murrabit Crisis Hotline

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core HealthcareService](StructureDefinition-au-core-healthcareservice.md)

**identifier**: `http://pca.digitalhealth.gov.au/id/pca-healthcare-service`/4d00ad2659cb4b54bd8028798af62631

**type**: Crisis counselling, Counselling service

**name**: Murrabit Crisis Hotline

**telecom**: ph: 1800975708



## Resource Content

```json
{
  "resourceType" : "HealthcareService",
  "id" : "murrabit-crisis-hotline",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-healthcareservice"
    ]
  },
  "identifier" : [
    {
      "system" : "http://pca.digitalhealth.gov.au/id/pca-healthcare-service",
      "value" : "4d00ad2659cb4b54bd8028798af62631"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "1244561000168107",
          "display" : "Crisis counselling"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "310026003",
          "display" : "Counselling service"
        }
      ]
    }
  ],
  "name" : "Murrabit Crisis Hotline",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "1800975708"
    }
  ]
}

```
