# Encounter - telehealth - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Encounter - telehealth**

## Example Encounter: Encounter - telehealth

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Encounter](StructureDefinition-au-core-encounter.md)

**status**: Finished

**class**: [ActCode: VR](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-VR) (virtual)

**type**: Telehealth encounter

**serviceType**: General practice service

**subject**: [Mrs. Anne Mary Bennelong(official) Female, DoB: 1968-10-11 ( Medical record number)](Patient-bennelong-anne.md)

### Participants

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Individual** |
| * | primary performer | [PractitionerRole General practitioner](PractitionerRole-bobrester-bob-gp.md) |

**period**: 2023-02-10 11:20:00+1000 --> 2023-02-10 11:35:00+1000

### Locations

| | |
| :--- | :--- |
| - | **Location** |
| * | [Location Patient's home](Location-patient-home.md) |

**serviceProvider**: [Organization Bobrester Medical Center](Organization-bobrester-medical-center.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "telehealth",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter"
    ]
  },
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "VR",
    "display" : "virtual"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "1479961000168103",
          "display" : "Telehealth encounter"
        }
      ]
    }
  ],
  "serviceType" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "788007007",
        "display" : "General practice service"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/bennelong-anne"
  },
  "participant" : [
    {
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "PPRF"
            }
          ]
        }
      ],
      "individual" : {
        "reference" : "PractitionerRole/bobrester-bob-gp"
      }
    }
  ],
  "period" : {
    "start" : "2023-02-10T11:20:00+10:00",
    "end" : "2023-02-10T11:35:00+10:00"
  },
  "location" : [
    {
      "location" : {
        "reference" : "Location/patient-home"
      }
    }
  ],
  "serviceProvider" : {
    "reference" : "Organization/bobrester-medical-center"
  }
}

```
