# Encounter - COVID 19 Vaccine Administration Dose 1 - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Encounter - COVID 19 Vaccine Administration Dose 1**

## Example Encounter: Encounter - COVID 19 Vaccine Administration Dose 1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Encounter](StructureDefinition-au-core-encounter.md)

**status**: Finished

**class**: [ActCode: AMB](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-AMB) (ambulatory)

**serviceType**: COVID-19 vaccination service

**subject**: [Mrs. Anne Mary Bennelong(official) Female, DoB: 1968-10-11 ( Medical record number)](Patient-bennelong-anne.md)

### Participants

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Individual** |
| * | primary performer | [PractitionerRole General practitioner](PractitionerRole-bobrester-bob-gp.md) |

**period**: 2021-06-17 09:20:00+1000 --> 2021-06-17 09:35:00+1000

**serviceProvider**: [Organization Bobrester Medical Center](Organization-bobrester-medical-center.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "covid-admin-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter"
    ]
  },
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB",
    "display" : "ambulatory"
  },
  "serviceType" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "1575161000168105",
        "display" : "COVID-19 vaccination service"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/bennelong-anne",
    "identifier" : {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR"
          }
        ]
      },
      "system" : "http://mossypointmc.example.com/mrn/",
      "value" : "872038020",
      "assigner" : {
        "display" : "Albion Hospital"
      }
    }
  },
  "participant" : [
    {
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "PPRF",
              "display" : "primary performer"
            }
          ]
        }
      ],
      "individual" : {
        "reference" : "PractitionerRole/bobrester-bob-gp",
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                "code" : "EI",
                "display" : "Employee number"
              }
            ],
            "text" : "Employee Number"
          },
          "system" : "http://ns.electronichealth.net.au/id/abn-scoped/service-provider-individual/1.0/12345678901",
          "value" : "12345678",
          "assigner" : {
            "display" : "Bobrester Medical Center"
          }
        }
      }
    }
  ],
  "period" : {
    "start" : "2021-06-17T09:20:00+10:00",
    "end" : "2021-06-17T09:35:00+10:00"
  },
  "serviceProvider" : {
    "reference" : "Organization/bobrester-medical-center"
  }
}

```
