# Condition - Urinary tract infection - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Condition - Urinary tract infection**

## Example Condition: Condition - Urinary tract infection

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Condition](StructureDefinition-au-core-condition.md)

**clinicalStatus**: Resolved

**verificationStatus**: Confirmed

**category**: Problem List Item

**severity**: Severe

**code**: Urinary tract infection

**subject**: [Mia Leanne Banks Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)](Patient-banks-mia-leanne.md)

**onset**: 2020-05-10

**abatement**: 2020-05-24



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "uti",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-condition"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "resolved",
        "display" : "Resolved"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
          "code" : "problem-list-item",
          "display" : "Problem List Item"
        }
      ]
    }
  ],
  "severity" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "24484000",
        "display" : "Severe"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "68566005",
        "display" : "Urinary tract infection"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/banks-mia-leanne"
  },
  "onsetDateTime" : "2020-05-10",
  "abatementDateTime" : "2020-05-24"
}

```
