# AllergyIntolerance - No known allergy - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AllergyIntolerance - No known allergy**

## Example AllergyIntolerance: AllergyIntolerance - No known allergy

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md)

**clinicalStatus**: Active

**code**: No known allergy

**patient**: [Li Wang Male, DoB: 1975-05-03 ( Medical Record Number: 22421441)](Patient-wang-li.md)



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "noneknown",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "716186003",
        "display" : "No known allergy"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/wang-li"
  }
}

```
