# AllergyIntolerance - Lactose intolerance - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AllergyIntolerance - Lactose intolerance**

## Example AllergyIntolerance: AllergyIntolerance - Lactose intolerance

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md)

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**code**: Intolerance to lactose

**patient**: [Mia Leanne Banks Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)](Patient-banks-mia-leanne.md)

**onset**: 2022

**recordedDate**: 2023-03-14

**recorder**: [PractitionerRole General practitioner](PractitionerRole-bobrester-bob-gp.md)

> **reaction****manifestation**: Abdominal pain, Abdominal bloating, Diarrhoea**severity**: Mild



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "lactose",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "782415009",
        "display" : "Intolerance to lactose"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/banks-mia-leanne"
  },
  "onsetDateTime" : "2022",
  "recordedDate" : "2023-03-14",
  "recorder" : {
    "reference" : "PractitionerRole/bobrester-bob-gp"
  },
  "reaction" : [
    {
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "21522001",
              "display" : "Abdominal pain"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "116289008",
              "display" : "Abdominal bloating"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "62315008",
              "display" : "Diarrhoea"
            }
          ]
        }
      ],
      "severity" : "mild"
    }
  ]
}

```
