# Home - AU Base Implementation Guide v6.0.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/ImplementationGuide/hl7.fhir.au.base | *Version*:6.0.0 |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:AUBaseImplementationGuide |
| **Copyright/Legal**: HL7 Australia© 2018+; Licensed Under Creative Commons No Rights Reserved. | |

### Introduction

This implementation guide is provided to support the use of HL7® FHIR®© in an Australian context.

AU Base defines Australian realm concepts (e.g. Medicare card number) as an additional set of options to what is available in the FHIR standard, including extensions, terminology and identifiers. It provides base profiles to inform a reader of which added concepts are considered relevant to a particular resource type, and these base profiles may be further constrained in a separate implementation guide for a particular usage. For this reason, AU Base does not apply cardinality constraints or required binding strengths to added concepts (except in rare circumstances), and does not utilise must support flags or recommend or mandate any particular resource, element or interactions.

This guide alone does not constrain profiles sufficiently to ensure implementation use cases can be met.

AU Core defines a set of conformance requirements that enforce a set of ‘minimum requirements’ on the Australian localised concepts from AU Base through cardinality constraints, Must Support flags, required/extensible binding strengths, and capability statements. AU Core is for use by Australian stakeholders when implementing FHIR to provide a common implementation and should be built on top of when creating additional Australian profiles and implementation guides. Conformance to AU Core may become tied to regulatory and/or contractual agreements in order to necessitate adoption to this more prescriptive specification.

### Dependencies



* Parameter: system-version
  * Value: SNOMED CT[AU]

### How to Read This Guide

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction and scope for this guide.
* [Guidance](guidance.md): These pages list the guidance for this guide. 
* [General Guidance](generalguidance.md): This page provides guidance on using the profiles defined in this guide.
* [Sex and Gender](sexgender.md): This page provides guidance on the representation of sex, gender, and related concepts.
* [Relationship with other IGs](relationship.md): This page provides guidance on the relationship between AU Base and other implementation guides.
* [Future of AU Base](future.md): This page outlines the yearly update cycle and approach to maturing AU Base.
 
* [FHIR Artefacts](fhirartefacts.md): These pages provide detailed descriptions and formal definitions for all the FHIR artefacts defined in this guide. 
* [Artefacts Summary](artifacts.md): This page lists the FHIR artefacts defined in this guide.
* [Profiles and Extensions](profiles-and-extensions.md): This page describes the profiles and extensions that are defined in this guide to represent Australian local concepts using FHIR. Each profile page includes a narrative description, guidance, and formal definition. Although the guidance typically focuses on the profiled elements and seeks to provide a ‘how-to’ guide when representing concepts, it may also focus on un-profiled elements to aid with implementation.
* [Search Parameters](search-parameters.md): This page lists the search parameters defined in this guide for use in AU operations.
* [Terminology](terminology.md): This page lists the value sets and code systems localised in this guide.
 
* [Examples](examples.md): This page lists all the examples used in this guide.
* [Support](support.md): These pages provide supporting material for implementation of AU Base. 
* [Downloads](downloads.md): This page provides links to downloadable artefacts.
* [License and Legal](license.md): This page outlines license and legal requirements relating to AU Base.
 
* [Change Log](changes.md): This page documents the changes across versions of this guide.

### Collaboration

This guide is the product of collaborative work undertaken with participants from:

* [HL7 Australia FHIR Working Group](https://confluence.hl7.org/display/HAFWG/HL7+Australia+FHIR+Work+Group+Home)
* Australian FHIR Implementers Community
* Secure Messaging Technical Working Group

Primary Editors: Brett Esler, Danielle Tavares-Rixon.

