# Artefacts Summary - AU Base Implementation Guide v6.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* **Artefacts Summary**

## Artefacts Summary

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [AustralianIndigenousStatus](SearchParameter-indigenous-status.md) | This search parameter returns patients with an Australian Indigenous Status extension matching the specified code. |
| [EncounterDischargeDisposition](SearchParameter-encounter-discharge-disposition.md) | This search parameter returns encounters with a discharge-disposition matching the specified code. |
| [GenderIdentity](SearchParameter-gender-identity.md) | This search parameter returns resources with the Individual Gender Identity extension matching the specified code. |
| [ServiceRequestSupportingInfo](SearchParameter-servicerequest-supporting-info.md) | This search parameter returns service requests that reference the specified resource in ServiceRequest.supportingInfo. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AU Assertion of No Relevant Finding](StructureDefinition-au-norelevantfinding.md) | This profile provides an observation information structure for asserting a clinical judgement that there are no items of specific interest, (e.g. no current medications or no history of vaccination), for a patient. An assertion of no relevant finding may be used in continuity of care or transfer or care related lists and composition sections. |
| [AU Base AllergyIntolerance](StructureDefinition-au-allergyintolerance.md) | This profile defines an allergy intolerance structure that localises core concepts, including terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base BodyStructure](StructureDefinition-au-bodystructure.md) | This profile defines a body structure that localises core concepts, including terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base Composition](StructureDefinition-au-composition.md) | This profile defines a composition structure that localises core concepts for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base Condition](StructureDefinition-au-condition.md) | This profile defines a condition structure that localises core concepts, including terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base Coverage](StructureDefinition-au-coverage.md) | This profile defines a coverage structure that localises core concepts, including terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base Diagnostic Imaging Report](StructureDefinition-au-imagingreport.md) | This profile defines a diagnostic report structure to represent a diagnostic imaging report issued by a diagnostic service provider in an Australian context. |
| [AU Base Diagnostic Imaging Result](StructureDefinition-au-imagingresult.md) | This profile defines an observation structure to represent a imaging examination result issued by a diagnostic service provider in an Australian context. The observation may represent the conclusions of a diagnostic procedure such as Left retina Foveal thickness by OCT, or it may group the set of results produced by a multi-test study or panel such as Biophysical profile panel. |
| [AU Base Diagnostic Request](StructureDefinition-au-diagnosticrequest.md) | This profile defines a service request structure to represent a request for a diagnostic investigation in an Australian context. This profile is intended to support ordering for pathology, radiology, and specialist diagnostic investigations. |
| [AU Base Diagnostic Result](StructureDefinition-au-diagnosticresult.md) | This profile defines an observation structure to represent a diagnostic investigation result issued by a diagnostic service provider in an Australian context. This profile may be used to represent a specialist or other diagnostic (not imaging or pathology) observation including results of audiology studies, sleep studies or speech pathology. The observation may represent the result of a simple investigation or it may group the set of results of a multi-modality procedure or multi-test study / panel. |
| [AU Base DiagnosticReport](StructureDefinition-au-diagnosticreport.md) | This profile defines a diagnostic report structure that localises core concepts, including identifiers and terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs.For specific reporting of pathology or imaging services the more specific[AU Base Pathology Report](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-pathologyreport.html)or[AU Base Diagnostic Imaging Report](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-imagingreport.html)profiles would be preferred. This profile is suitable for any other diagnostic service reporting needs. |
| [AU Base Encounter](StructureDefinition-au-encounter.md) | This profile defines an encounter structure that localises core concepts, including terminology, for use in an Australian context. This profile is intended to be applicable for recording details of ambulatory and non-ambulatory patient encounters in an Australian healthcare context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base HealthcareService](StructureDefinition-au-healthcareservice.md) | This profile defines a healthcare service structure that localises core concepts, including identifiers and terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base Immunization](StructureDefinition-au-immunization.md) | This profile defines an immunisation structure that localises core concepts, including terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base Location](StructureDefinition-au-location.md) | This profile defines a location structure that localises core concepts, including identifiers and terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base Medication](StructureDefinition-au-medication.md) | This profile defines a medication structure that localises core concepts, including terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base MedicationAdministration](StructureDefinition-au-medicationadministration.md) | This profile defines a medication administration structure that localises core concepts, including terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base MedicationDispense](StructureDefinition-au-medicationdispense.md) | This profile defines a medication dispense structure that localises core concepts, including identifiers and terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base MedicationRequest](StructureDefinition-au-medicationrequest.md) | This profile defines a medication request structure that localises core concepts, including identifiers and terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base MedicationStatement](StructureDefinition-au-medicationstatement.md) | This profile defines a medication statement structure that localises core concepts, including terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base Organization](StructureDefinition-au-organization.md) | This profile defines an organisation structure that localises core concepts, including identifiers and terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base Pathology Report](StructureDefinition-au-pathologyreport.md) | This profile defines a diagnostic report structure to represent a pathology report issued by a diagnostic service provider in an Australian context. This profile is intended to be capable of supporting reporting for all pathology disciplines (e.g. including microbiology, histopathology, cytology, blood transfusion) with the exception of genomics.This profile does not provide full support for structured pathology reporting. It is expected that this support is best handled by a set of profiles that represent the structured reporting requirements for each specific protocol (see for example[RCPA’s structured pathology reporting of cancer](https://www.rcpa.edu.au/Library/Practising-Pathology/Structured-Pathology-Reporting-of-Cancer)); this is not in the scope of this implementation guide at this time. |
| [AU Base Pathology Result](StructureDefinition-au-pathologyresult.md) | This profile defines an observation structure to represent a pathology test result issued by a diagnostic service provider in an Australian context. This profile is intended to be capable of supporting reporting for all pathology disciplines (e.g. including microbiology, histopathology, cytology, blood transfusion) with the exception of genomics. The observation may represent the result of a simple test such as haemoglobin or it may group the set of results produced by a multi-test study or panel such as a full blood count, or urine specimen study.This profile does not provide full support for structured pathology reporting. It is expected that this support is best handled by a set of profiles that represent the structured reporting requirements for each specific protocol (see for example[RCPA’s structured pathology reporting of cancer](https://www.rcpa.edu.au/Library/Practising-Pathology/Structured-Pathology-Reporting-of-Cancer)); this is not in the scope of this implementation guide at this time. |
| [AU Base Patient](StructureDefinition-au-patient.md) | This profile defines a patient structure that localises core concepts, including identifiers and terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base Practitioner](StructureDefinition-au-practitioner.md) | This profile defines a practitioner structure that localises core concepts, including identifiers and terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base PractitionerRole](StructureDefinition-au-practitionerrole.md) | This profile defines a practitioner role structure that localises core concepts, including identifiers and terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base Procedure](StructureDefinition-au-procedure.md) | This profile defines a procedure structure that localises core concepts, including terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base RelatedPerson](StructureDefinition-au-relatedperson.md) | This profile defines a related person structure that localises core concepts, including identifiers and terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base ServiceRequest](StructureDefinition-au-servicerequest.md) | This profile defines a service request structure that localises core concepts, including terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base Specimen](StructureDefinition-au-specimen.md) | This profile defines a specimen structure that localises core concepts, including terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Base Substance](StructureDefinition-au-substance.md) | This profile defines a substance structure that localises core concepts, including terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU Medicine List](StructureDefinition-au-medlist.md) | This profile defines a list structure that localises core concepts for use as a medicines list in an Australian context. This profile is intended to offer a common structure and expectations for a list of medications associated with a patient in an Australian healthcare context. |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AU Accession Number](StructureDefinition-au-accessionnumber.md) | This identifier profile defines an accession number in an Australian context. Accession numbers are typically assigned by a diagnostic imaging system or clinical laboratory system and depending on the domain an accession number may for example identify a specimen, imaging examination, or biological polymer sequence. |
| [AU Ahpra Registration Number](StructureDefinition-au-ahpraregistrationnumber.md) | This identifier profile defines an Australian Health Practitioner Regulation Agency (Ahpra) registration number in an Australian context (see[Ahpra](https://www.ahpra.gov.au)for further information). |
| [AU Australian Business Number](StructureDefinition-au-australianbusinessnumber.md) | This identifier profile defines an Australian Business Number (ABN) in an Australian context. An ABN is issued to all entities registered in the Australian Business Register (ABR). |
| [AU Australian Company Number](StructureDefinition-au-australiancompanynumber.md) | This identifier profile defines an Australian Company Number in an Australian context. An ACN is allocated by the Australian Securities and Investments Commission (ASIC) when a body becomes registered as a company under Corporations Law. |
| [AU Australian Registered Body Number](StructureDefinition-au-australianregistredbodynumber.md) | This identifier profile defines an Australian Registered Body Number (ARBN) in an Australian context. ARBNs are issued to registrable Australian bodies and foreign companies. |
| [AU Base Dosage](StructureDefinition-au-dosage.md) | This profile defines a dosage structure that localises core concepts for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. |
| [AU CSP Registration Number](StructureDefinition-au-cspregistrationnumber.md) | This identifier profile defines a Contracted Service Provider (CSP) registration number in an Australian context (see[My Health Record](https://www.myhealthrecord.gov.au/for-healthcare-professionals/howtos/contracted-service-provider-registration)for further information). A CSP registration number may be issued to organisations who wish to participate in the My Health Record and/or the Healthcare Identifiers Service as a CSP. |
| [AU Care Agency Employee Identifier](StructureDefinition-au-careagencyemployeeidentifier.md) | This identifier profile defines a care agency employee (CAE) identifier in an Australian context. A CAE identifier may be issued to an employee of, or person under contracted arrangement with, a care agency who wishes to participate in the My Health Record. |
| [AU Commonwealth Seniors Health Card Number](StructureDefinition-au-cwlthseniorshealthcardnumber.md) | This identifier profile defines a Commonwealth Seniors Health Card number in an Australian context (see[Services Australia](https://www.servicesaustralia.gov.au/individuals/services/centrelink/commonwealth-seniors-health-card)or[Department of Veterans' Affairs](https://www.dva.gov.au/health-and-treatment/veteran-healthcare-cards/commonwealth-seniors-health-card)for further information).This definition supports sending the Centrelink Customer Reference Number (CRN) (also referred to as unique identifier number (UIN) in the Centrelink Confirmation eServices (CCeS)) as displayed on the individual's Commonwealth Seniors Health Card (see[Services Australia](https://www.servicesaustralia.gov.au/individuals/subjects/centrelink-customer-reference-number-crn)for further information). An individual's CRN is present as the primary identifier on different concession cards and is used to confirm concessions by most government agencies and utility providers.A Commonwealth Seniors Health Card may be issued by Services Australia or Department of Veterans' Affairs (DVA) to retirees of age pension qualification age to assist with certain living costs by allowing access to specific goods and services at a concessional rate. |
| [AU DVA Number](StructureDefinition-au-dvanumber.md) | This identifier profile defines a Department of Veterans' Affairs (DVA) number) in an Australian context. This definition supports sending an individual's state-based DVA file number as displayed on a[Veteran Card](https://www.dva.gov.au/health-and-treatment/veteran-healthcare-cards/veteran-card), i.e. a Gold, White, or Orange Card. A Veteran Card may be issued by DVA to eligible individuals to allowing access to specific goods and services at a concessional rate. |
| [AU Delivery Point Identifier](StructureDefinition-au-deliverypointidentifier.md) | This identifier profile defines an Australia Post Delivery Point Identifier (DPID) in an Australian context (see[Australia Post](https://auspost.com.au/content/dam/auspost_corp/media/documents/australia-post-data-guide.pdf)for further information). A DPID is a randomly generated, unique 8-digit number, allocated by Australia Post to an address. A DPID enables each delivery point in Australia to be uniquely identified. |
| [AU ETP Prescription Identifier](StructureDefinition-au-etpprescriptionidentifier.md) | This identifier profile defines an Electronic Transfer of Prescription (ETP) prescription identifier in an Australian context. An ETP prescription identifier is assigned to a prescription by an ETP vendor, e.g. ERx or Medisecure, and is the assigned numeric value of the barcode on a prescription instance. |
| [AU Employee Number](StructureDefinition-au-employeenumber.md) | This identifier profile defines an employee number (sometimes referred to as an employee identifier (EI)) in an Australian context. An employee number is an organisation's identifier for an individual employed by that organisation. |
| [AU G-NAF Identifier](StructureDefinition-au-gnafidentifier.md) | This identifier profile defines a Geocoded National Address File (G-NAF) identifier in an Australian context. The[PSMA G-NAF](https://data.gov.au/data/dataset/geocoded-national-address-file-g-naf)is Australia’s authoritative, geocoded address file. A G-NAF identifier (sometimes referred to as G-NAF ID, or G-NAF PID, or GNAF ID, or address_detail_pid) identifies an address in the PSMA G-NAF. |
| [AU HPI-I](StructureDefinition-au-hpii.md) | This identifier profile defines a Healthcare Provider Identifier - Individual (HPI-I) in an Australian context (see[Australian Digital Health Agency](https://developer.digitalhealth.gov.au/specifications/national-infrastructure/ep-1826-2014/nehta-1163-2010)for further information). An HPI-I is assigned under the HI Service to healthcare providers involved in providing patient care. |
| [AU HPI-O](StructureDefinition-au-hpio.md) | This identifier profile defines a Healthcare Provider Identifier – Organisation in an Australian context (see[Australian Digital Health Agency](https://developer.digitalhealth.gov.au/specifications/national-infrastructure/ep-1826-2014/nehta-1163-2010)for further information). An HPI-O is assigned under the HI Service to an organisation (such as a hospital or medical clinic) where healthcare is provided. |
| [AU Health Care Card Number](StructureDefinition-au-healthcarecardnumber.md) | This identifier profile defines Health Care Card number in an Australian context (see[Services Australia](https://www.servicesaustralia.gov.au/individuals/services/centrelink/health-care-card)for further information).This definition supports sending the Centrelink Customer Reference Number (CRN) (also referred to as unique identifier number (UIN) in the Centrelink Confirmation eServices (CCeS)) as displayed on the individual's Health Care Card (see[Services Australia](https://www.servicesaustralia.gov.au/individuals/subjects/centrelink-customer-reference-number-crn)for further information). An individual's CRN is present as the primary identifier on different concession cards and is used to confirm concessions by most government agencies and utility providers.A Health Care Card is a concession card assigned by Services Australia to benefit recipients, low income earners and selected other groups (e.g. foster children) to assist with certain health costs, by allowing access to specific services at a concessional rate. |
| [AU IHI](StructureDefinition-au-ihi.md) | This identifier profile defines an Individual Healthcare Identifier in an Australian context (see[Australian Digital Health Agency](https://developer.digitalhealth.gov.au/specifications/national-infrastructure/ep-1826-2014/nehta-1163-2010)for further information). An IHI is assigned under the Healthcare Identifiers (HI) Service to a patient. |
| [AU Insurance Member Number](StructureDefinition-au-insurancemembernumber.md) | This identifier profile defines an insurance member number in an Australian context. An insurance member number is the unique member number assigned to an individual by an insurer and is typically displayed on their insurance card. An individual will not have more than one member number per insurer.This definition supports the sending of an insurance member number that is relevant in a healthcare context and may be used to capture Australian and International health insurer issued member numbers. In Australia this will typically be a private health insurance member number. This identifier should not be confused with an insurance policy number. |
| [AU Local Dispense Identifier](StructureDefinition-au-localdispenseidentifier.md) | This identifier profile defines a local dispense identifier in an Australian context. A local dispense identifier is an organisation's identifier for a dispense record in that organisation's local system set of dispense records. A dispense record identifier is typically assigned by the dispensing system and allows linking of a dispensing record to the dispensing system's local identifier. |
| [AU Local Order Identifier](StructureDefinition-au-localorderidentifier.md) | This identifier profile defines a local order identifier in an Australian context. A local order identifier is an organisation's identifier for an order in that organisation's local system set of orders.Typically a local order identifier will be either a[placer identifier](https://confluence.hl7australia.com/display/OOADRM20181/5+Observation+Ordering#id-5ObservationOrdering-5.4.1.2ORC-2Placerordernumber(EI)00216)or a[filler identifier](https://confluence.hl7australia.com/display/OOADRM20181/5+Observation+Ordering#id-5ObservationOrdering-5.4.1.3ORC-3Fillerordernumber(EI)00217)(sometimes known as filler order number). A placer identifier is an identifier for a request or group of requests where the identifier is issued by the entity making the request. A filler identifier is an identifier for a request or group of requests where the identifier is issued by the entity that produces the observations or fulfills the request. |
| [AU Local Prescription Identifier](StructureDefinition-au-localprescriptionidentifier.md) | This identifier profile defines a local prescription identifier (sometimes referred to as prescription number) in an Australian context. A local prescription identifier is an organisation's identifier for a prescription in that organisation's local system set of prescriptions. A local prescription identifier allows linking of a prescription to a system's local identifier. |
| [AU Local Report Identifier](StructureDefinition-au-localreportidentifier.md) | This identifier profile defines a local report identifier in an Australian context. A local report identifier is an organisation's identifier for a report in that organisation's local system set of reports. A report identifier must uniquely identify the report from all other reports in a particular system (e.g. diagnostic imaging system, clinical laboratory system, document management system, referral systems). In some laboratory systems, the report identifier may be a concatenation of a lab number and report panel code (e.g. 19P123456-FBC), where the panel code makes the identifier unique from other reports under the same lab number. |
| [AU Location Specific Practice Number](StructureDefinition-au-locationspecificpracticenumber.md) | This identifier profile defines a Location Specific Practice Number (LSPN) in an Australian context (see[Services Australia](https://www.servicesaustralia.gov.au/organisations/health-professionals/services/medicare/medicare-eligibility-provide-diagnostic-imaging-and-radiation-oncology-services#a2)and[Department of Health and Aged Care](https://www1.health.gov.au/internet/main/publishing.nsf/Content/stage-two-diag-img-acc-scheme-loc-spec-prac-num-fact-sheet)for further information). An LSPN is an identifier assigned to a specific location by Services Australia under the Medicare program and identifies an accredited practice site that provides diagnostic imaging and radiation oncology services. |
| [AU Medical Record Number](StructureDefinition-au-medicalrecordnumber.md) | This identifier profile defines a (MRN) (sometimes referred to as unit record number (URN) or (UR)) in an Australian context. An MRN is an institution's identifier for a patient's record at that institution. A patient may have more than one MRN for a single institution due to organisational restructures. |
| [AU Medicare Card Number](StructureDefinition-au-medicarecardnumber.md) | This identifier profile defines a Medicare card number in an Australian context. A Medicare card is provided to individuals who are enrolled in[Medicare](https://www.servicesaustralia.gov.au/individuals/medicare). This definition supports sending either the 10 digit Medicare card number or the 11 digit number (includes the individual reference number (IRN)). |
| [AU Medicare Provider Number](StructureDefinition-au-medicareprovidernumber.md) | This identifier profile defines a Medicare provider number assigned by Services Australia to practitioners who provide services covered by the Medicare Benefits Schedule (MBS) at a specific location. A practitioner may have more than one Medicare provider number if they deliver health services in different locations or are registered in multiple health professions. |
| [AU NATA Accreditation Number](StructureDefinition-au-nataaccreditationnumber.md) | This identifier profile defines a National Association of Testing Authorities (NATA) accreditation number in an Australian context (see[NATA](https://www.nata.com.au/)for further information). |
| [AU NATA Site Number](StructureDefinition-au-natasitenumber.md) | This identifier profile defines a National Association of Testing Authorities (NATA) site number in an Australian context (see[NATA](https://www.nata.com.au/)for further information). |
| [AU National Provider Identifier At Organisation](StructureDefinition-au-nationalprovideridentifieratorganisation.md) | This identifier profile defines a National Provider Identifier at Organisation (NPIO) in an Australian context. An NPIO identifies an individual practitioner at an organisation using the practitioner's HPI-I and organisation's HPI-O to form the NPIO. |
| [AU PAI-D Identifier](StructureDefinition-au-paididentifier.md) | This identifier profile defines a My Health Record Assigned Identity - Device (PAI-D) identifier in an Australian context. A PAI-D is typically used to identify a device that plays a role, for example an authoring or observing, in the exchange of digital health data with the My Health Record system. |
| [AU PAI-O Identifier](StructureDefinition-au-paioidentifier.md) | This identifier profile defines a My Health Record Assigned Identity - Organisation (PAI-O) identifier in an Australian context. A PAI-O may be issued to organisations who wish to participate in the My Health Record and who are not eligible for a Healthcare Provider Identifier - Organisation (HPI-O). |
| [AU PBS Prescriber Number](StructureDefinition-au-pbsprescribernumber.md) | This identifier profile defines a Pharmaceutical Benefits Scheme (PBS) prescriber number in an Australian context (see[PBS](https://www.pbs.gov.au/info/healthpro/explanatory-notes/section1/Section_1_2_Explanatory_Notes)for further information). A PBS prescriber number, previously referred to as Medicare prescriber number in earlier versions of this implementation guide, is assigned by Services Australia under the Pharmaceutical Benefits Scheme to practitioners who are approved to prescribe PBS medicines under the National Health Act 1953. |
| [AU Patient Internal Identifier](StructureDefinition-au-pi.md) | This identifier profile defines a patient internal identifier in an Australian context. A patient internal identifier is assigned to a patient by an application (e.g. practice management system or a cloud-based electronic medical record) to uniquely identify a patient within that application.While a patient internal identifier can be exchanged with other applications, its scope for sharing is limited and typically occurs for context-specific patient matching (e.g. a patient internal identifier included in a pathology request can be returned in the associated pathology report). This identifier is only unique within the assigning application and is not suitable for broader use as a persistent identifier, unlike a Medical Record Number (MRN), which is unique within an institution. |
| [AU Pensioner Concession Card Number](StructureDefinition-au-pensionerconcessioncardnumber.md) | This identifier profile defines a Pensioner Concession Card number in an Australian context (see[Services Australia](https://www.servicesaustralia.gov.au/individuals/services/centrelink/pensioner-concession-card)or[Department of Veterans' Affairs](https://www.dva.gov.au/health-and-treatment/veteran-healthcare-cards/pensioner-concession-card)).This definition supports sending the Centrelink Customer Reference Number (CRN) (also referred to as unique identifier number (UIN) in the Centrelink Confirmation eServices (CCeS)) as displayed on the individual's Pensioner Concession Card (see[Services Australia](https://www.servicesaustralia.gov.au/individuals/subjects/centrelink-customer-reference-number-crn)for further information). An individual's CRN is present as the primary identifier on different concession cards and is used to confirm concessions by most government agencies and utility providers.A Pensioner Concession Card may be issued by Services Australia or Department of Veterans' Affairs (DVA) to pensioners and selected benefit recipients to assist them with certain living costs, by allowing access to specific goods and services at a concessional rate. |
| [AU Pharmacy Approval Number](StructureDefinition-au-pharmacyapprovalnumber.md) | This identifier profile defines a pharmacy approval number in an Australian context (see[Department of Health and Aged Care](https://www1.health.gov.au/internet/main/publishing.nsf/Content/pharmaceutical-benefits-scheme-approved-supplier-administrative-functions)for further information). A pharmacy approval number, also known as a PBS approval number, is assigned by the Department of Health to pharmacies that are approved to supply pharmaceutical benefits at particular premises under the National Health Act 1953. |
| [AU Residential Aged Care Service Identifier](StructureDefinition-au-residentialagedcareserviceidentifier.md) | This identifier profile defines a residential aged care service identifier (RACS ID) in an Australian context. |
| [Australian Address](StructureDefinition-au-address.md) | This profile defines an address structure that localises core concepts, including identifiers and terminology, for use in an Australian context, to specifically represent an Australian (location) address. The purpose of this profile is to provide best practice guidance on Australian address representation, where some constraint on content is desirable to guarantee the quality of an Australian address. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Address Identifier](StructureDefinition-address-identifier.md) | This extension applies to the[Address](http://hl7.org/fhir/R4/datatypes.html#Address)data type and is used to represent an identifier for an address. An address identifier does not form part of the address itself, e.g. a street number. It is a unique identifier associated with a location address and may be used to look up an address, validate an address, or link to other data relating to an address. |
| [Ahpra Profession Details](StructureDefinition-ahpraprofession-details.md) | This extension applies to the Practitioner.qualification element and is used to represent Australian Health Practitioner Regulation Agency (Ahpra) profession details (see[Ahpra](https://www.ahpra.gov.au/Support/Glossary.aspx#Registration%20Number)for further information). This extension supports the inclusion of the Ahpra profession code and information about conditions, undertakings, reprimands and cautions in a qualification element instance representing a practitioner’s Ahpra profession. |
| [Ahpra Registration Details](StructureDefinition-ahpraregistration-details.md) | This extension applies to the Practitioner.qualification element and is used to represent Australian Health Practitioner Regulation Agency (Ahpra) registration details (see[Ahpra](https://www.ahpra.gov.au/Support/Glossary.aspx#Registration%20Number)for further information). This extension supports the inclusion of the Ahpra profession code and information about division, speciality, registration status, endorsements and notations in a qualification element instance representing a practitioner’s Ahpra registration. |
| [Associated Healthcare Service](StructureDefinition-associated-healthcareservice.md) | This extension applies to any resource and is used to represent a healthcare service relating to a resource, e.g. healthcare services under which the patient was managed during an encounter. |
| [Australian Indigenous Status](StructureDefinition-indigenous-status.md) | This extension applies to the Patient, Person, and RelatedPerson resources and is used to indicate whether a person identifies as being of Aboriginal or Torres Strait Islander origin. |
| [Australian Time Zone](StructureDefinition-au-timezone.md) | This extension applies to the[time](http://hl7.org/fhir/R4/datatypes.html#time)data type and is used to represent an Australian time zone. |
| [Australian Time Zone Usage](StructureDefinition-au-timezone-usage.md) | This profile defines specific usage of Australian time zones (states and territories) with the FHIR[Timezone Code extension](https://hl7.org/fhir/extensions/StructureDefinition-timezone.html). |
| [Australian Veteran Status](StructureDefinition-veteran-status.md) | This extension applies to the Patient resource and is used to indicate whether a person is serving, or has served, in the Australian Defence Force. |
| [Author as a RelatedPerson](StructureDefinition-author-related-person.md) | This extension applies to any resource and is used to represent an author who is a related person. |
| [Change Description](StructureDefinition-change-description.md) | This extension applies to the List resource and is used to represent a narrative description of the change to an item in a list entry. The narrative description may include the reason for the change to an item. |
| [Closing the Gap Registration](StructureDefinition-closing-the-gap-registration.md) | This extension applies to the Patient resource and provides an indicator of whether the patient is eligible for a Closing the Gap (CTG) co-payment. |
| [Contact Purpose](StructureDefinition-contact-purpose.md) | This extension applies to the[ContactPoint](http://hl7.org/fhir/datatypes.html#ContactPoint)data type and is used to represent the purpose for which a contact can be reached, e.g. after hours or billing. |
| [Date Accuracy Indicator](StructureDefinition-date-accuracy-indicator.md) | This extension applies to the[date](http://hl7.org/fhir/R4/datatypes.html#date)and[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)data types and is used to represent the accuracy of the associated date. |
| [Date of Arrival in Australia](StructureDefinition-date-of-arrival.md) | This extension applies to the Patient, RelatedPerson, and Practitioner resources and is used to represent a person's date of arrival in an Australian context (see[Australian Bureau of Statistics](https://www.abs.gov.au/AUSSTATS/abs@.nsf/Lookup/1200.0.55.007Main+Features12014,%20Version%201.5?OpenDocument)for further information). The date of arrival is when a person (born outside of Australia) first arrived in Australia, from another country, with the intention of living in Australia for one year or more. This date is recorded once for a person and is not subsequently updated with subsequent arrivals. This element is a part of Cultural and Linguistic Diversity (CALD) data set. It is an important indicator of cultural identity, and provides further information about a person's cultural values and practices which can be significant in determining service type, support required, and possible needs. |
| [Dispense Number](StructureDefinition-dispense-number.md) | This extension applies to the MedicationDispense resource and is used to represent the dispense number or sequence number that has been reached for a therapeutic good prescribed with repeats. |
| [Encounter Description](StructureDefinition-encounter-description.md) | This extension applies to the Encounter resource and is used to represent a narrative description of the healthcare event or encounter. The description may include a summary of the issues or problems, management strategies, outcomes or progress, possible prognosis, and the patient’s understanding of the healthcare event. The description may capture text about the encounter that is not captured in other fields. |
| [Encryption Certificate PEM X509](StructureDefinition-encryption-certificate-pem-x509.md) | This extension applies to the Endpoint resource and is used to support encrypted certificate content for use with an endpoint. This extension allows an endpoint entry to define a suitable certificate for use in communications on the associated channel. |
| [HL7 V2 Assigning Authority](StructureDefinition-au-assigningauthority.md) | This extension applies to the[Identifier](http://hl7.org/fhir/datatypes.html#identifier)data type and is used to represent HL7 V2 assigning authority details for HL7 V2 identification for routing. |
| [HL7 V2 Receiving Application](StructureDefinition-au-receivingapplication.md) | This extension applies to the Endpoint resource and is used to represent routing HL7 V2 message payload details associated with an endpoint. This content allows a sender using these endpoint details to include Receiving Application (MSH-5) information in HL7 V2 messages sent via this channel which allow correct delivery within the receiving system. |
| [HL7 V2 Receiving Facility](StructureDefinition-au-receivingfacility.md) | This extension applies to the Endpoint resource and is used to represent HL7 V2 receiving facility details for HL7 V2 routing purposes associated with an endpoint. This content allows a sender using these endpoint details to include Receiving Facility (MSH-6) information in HL7 V2 messages sent via this channel which allow correct delivery within the receiving system. |
| [IHI Record Status](StructureDefinition-ihi-record-status.md) | This extension applies to the[Identifier](http://hl7.org/fhir/datatypes.html#identifier)data type and is used to indicate whether verification of the Individual Healthcare Identifier (IHI) has occurred and is based on the evidence available for a person’s identity. |
| [IHI Status](StructureDefinition-ihi-status.md) | This extension applies to the[Identifier](http://hl7.org/fhir/datatypes.html#identifier)data type and is used to represent the status of the associated Individual Healthcare Identifier (IHI) and indicates whether the status of the IHI is active or otherwise. |
| [IHI Verification Date](StructureDefinition-ihi-verified-date.md) | This extension applies to the[Identifier](http://hl7.org/fhir/datatypes.html#identifier)data type and is used to represent the date, and optionally time, that the IHI was verified with HI Services. This is not the date that it was created by the HI Services, but when it was checked. This is often required to know how recently the identifier was checked, and if it must be re-verified before using it. |
| [Identifier Routability](StructureDefinition-identifier-routability.md) | This extension applies to the[Identifier](http://hl7.org/fhir/datatypes.html#identifier)data type. Identifier routability preferences for an asserter. |
| [Information Recipient](StructureDefinition-information-recipient.md) | This extension applies to the Composition resource and is used to represent an intended recipient of the composition. |
| [Long Term](StructureDefinition-medication-long-term.md) | This extension applies to the MedicationStatement resource and is used to indicate long term use of a medication. |
| [Medication Brand Name](StructureDefinition-medication-brand-name.md) | This extension applies to the Medication, MedicationRequest, MedicationDispense and MedicationStatement resources and is used to represent the brand name of a medication. This extension is not to be the sole representation of the medication concept; it shall not be used as a substitute for medication code (e.g. Medication.code or MedicationStatement.medicationCodeableConcept).If a system can only supply branded product information in text form, that information will be supplied in the text portion of that code e.g. code.text or medicationCodeableConcept.text. This extension only supports the name portion of a medication concept, not the branded product or product pack information. It is available for use for where a system needs to separate out the brand name string for handling or other processing. |
| [Medication Generic Drug Name](StructureDefinition-medication-generic-name.md) | This extension applies to the Medication, MedicationRequest, MedicationDispense and MedicationStatement resources and is used to represent the generic name of a medication. The generic medication text name may not be the same as the subject medication (prescribed, dispensed or stated) but may be used to provide an additional or equivalent drug name that is a generic medication concept. This extension is not to be the sole representation of the medication concept; it shall not be used as a substitute for medication code (e.g. Medication.code or MedicationStatement.medicationCodeableConcept).If a system can only supply generic product information, and only in text form, that information will be supplied in the text portion of that code e.g. code.text or medicationCodeableConcept.text. This extension only supports the name portion of a medication concept, not the generic product or product pack information. It is available for use for where a system needs to separate out the generic name string for handling or other processing. |
| [Medication Strength](StructureDefinition-medication-strength.md) | This extension applies to the Medication resource and is used to represent the strength of a medication as text. Use this extension for text representation of a medication strength as a whole. Coded representation of medication strength as a whole uses`Medication.code`. |
| [Medication Type](StructureDefinition-medication-type.md) | This extension applies to the[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)data type and is used to indicate the type of information covered by the code e.g. branded product with no strength or form. This is useful when there are multiple codings from the same coding system at different levels/classifications. |
| [Name Context](StructureDefinition-name-context.md) | This extension applies to the[HumanName](http://hl7.org/fhir/R4/datatypes.html#HumanName)data type, in the context of Patient, Person, Practitioner or RelatedPerson resources and is used to indicate a suitable use of the associated name. The usage described may be varied in nature including suitability for a particular purpose e.g. IHI validation, or highlighting (in)appropriate use when referring to an individual e.g. deceased Aboriginal name, transgender deadname. |
| [No Fixed Address](StructureDefinition-no-fixed-address.md) | This extension applies to the[Address](http://hl7.org/fhir/R4/datatypes.html#Address)data type and is used to indicate that a location address is not a fixed address for an individual. |
| [Result Copies To](StructureDefinition-result-copies-to.md) | This extension applies to the ServiceRequest resource and is used to indicate an additional recipient to whom a copy of the outcome of the request (i.e. the results) should be sent. The service requester will typically receive a result as part of the normal processing from the filler of the request and this extension is only relevant for any additional result copy recipients indicated on the request. |
| [Subsidised Concurrent Supply](StructureDefinition-subsidised-concurrent-supply.md) | This extension applies to the MedicationRequest or MedicationDispense resources and is used to represent the grounds (e.g.[Regulation 49](https://www.pbs.gov.au/info/healthpro/explanatory-notes/section1/Section_1_2_Explanatory_Notes#Regulation-49)) that authorise a PBS or RPBS subsidy for the concurrent supply of an item specified in a prescription and all of its repeats (see[PBS](https://www.pbs.gov.au/info/healthpro/explanatory-notes/section1/Section-1-3-Explanatory-Notes)for further information). |
| [Vaccine Vial Serial Number](StructureDefinition-vaccine-serial-number.md) | This extension applies to the Immunization resource and is used to represent the serial number of the vial of vaccine. Vial serial number is part of the[Australian Immunisation Register Rule 2015](https://www.legislation.gov.au/Latest/F2021C00234)data elements to report for COVID-19 vaccines. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AMT Medicinal Product and Substances](ValueSet-amt-mp-codes.md) | The AMT Medicinal Product and Substances value set includes values that may be used to identify a substance or a medicinal product that is an ingredient of a medication. |
| [AU Recorded Sex or Gender (RSG) Source](ValueSet-rsg-source.md) | The AU Recorded Sex or Gender (RSG) Source value set includes codes that can be used to represent the non-document source where the sex or gender value is recorded. |
| [AU Recorded Sex or Gender (RSG) Source Document Type](ValueSet-rsg-source-document-type.md) | The AU Recorded Sex or Gender (RSG) Source Document Type value set includes codes that can be used to represent the type of document where this sex or gender value is recorded. |
| [AU Recorded Sex or Gender Type](ValueSet-rsg-type.md) | The AU Recorded Sex or Gender Type value set includes codes that can be used to represent the type or category of sex or gender that is recorded. |
| [AU Time Zone](ValueSet-au-timezone.md) | Australian time zones. |
| [Accession Number Type](ValueSet-accession-number-type.md) | Identifier types that may be associated with an accession number in an Australian context. |
| [ActEncounterCode - AU Extended](ValueSet-au-v3-ActEncounterCode-extended.md) | v3 Act Encounter Code extended for use in an Australian context. Includes HL7 international codes plus Australian additions to create a complete set. |
| [Contact Purpose](ValueSet-contact-purpose.md) | The purpose for which an associated contact can be reached. |
| [Coverage Type and Self-Pay Codes - AU Extended](ValueSet-au-coverage-type-extended.md) | Coverage type codes extended for use in an Australian context. Includes HL7 international codes plus Australian additions to create a complete set. |
| [DVA Entitlement](ValueSet-dva-entitlement.md) | Entitlement types that may be associated with an individual's Department of Veterans’ Affairs (DVA) File Number on a DVA issued health card in an Australian context. |
| [Jurisdiction ValueSet - AU Extended](ValueSet-au-jurisdiction-extended.md) | Jurisdiction ValueSet extended for use in an Australian context. Includes HL7 international codes plus Australian additions to create a complete set. |
| [Location Type (Physical) - AU Extended](ValueSet-au-location-physical-type-extended.md) | Location type (physical) extended for use in an Australian context. Includes HL7 international codes plus Australian additions to create a complete set. |
| [MIMS](ValueSet-mims.md) | The MIMS value set includes all values from the Monthly Index of Medical Specialties (MIMS) published by MIMS Australia. Further details can be found at https://www.mims.com.au/. |
| [Medication Type](ValueSet-medication-type.md) | The Medication Type value set may be used to classify the nature of properties defined by the code e.g. branded product with no strength or form. This allows the distinction between codes provided containing container, pack, strength and form explicitly especially where terminologies supplied are unknown or terminology services are unavailable. |
| [Medicine Item Change](ValueSet-medicine-item-change.md) | The Medicine Item Change value set includes values that may be used to identify that a change that has been made, or is recommended to be made, to a medicine item. |
| [Name Context](ValueSet-name-context.md) | The Name Context value set may be used to classify suitable uses or purposes of names. |
| [Order Identifier Type](ValueSet-order-identifier-type.md) | Identifier types that may be associated with an order identifier in an Australian context. |
| [PBS Item Codes](ValueSet-pbs-item.md) | The PBS Item Codes value set includes all values from Australian Pharmaceutical Benefits Scheme (PBS) schedule published by the Department of Health. Further details can be found at https://www.pbs.gov.au/pbs/. |
| [Service Provision Conditions Australian Concepts](ValueSet-service-provision-conditions.md) | The Service Provision Conditions Australian Concepts value set includes values that may be used to identify the type of service provision conditions in an Australian context. |
| [ServiceDeliveryLocationRoleType - AU Extended](ValueSet-au-v3-ServiceDeliveryLocationRoleType-extended.md) | ServiceDeliveryLocationRoleType extended for use in an Australian context. Includes HL7 international codes plus Australian additions to create a complete set. |
| [hl7VS-degreeLicenseCertificate - AU Extended](ValueSet-au-v2-0360-extended.md) | hl7VS-degreeLicenseCertificate extended for use in an Australian context. Includes HL7 international codes plus Australian additions to create a complete set. |
| [hl7VS-identifierType - AU Extended](ValueSet-au-v2-0203-extended.md) | Extended value set of identifier types for use in an Australian context. Includes HL7 international codes plus Australian additions to create a complete set. NOTE: codes contained LACN Laboratory Accession ID and ACN Accession ID are exclusive concepts and not consider related in this terminology. |
| [hl7VS-providerRole - AU Extended](ValueSet-au-v2-0443-extended.md) | hl7VS-providerRole extended for use in an Australian context. Includes HL7 international codes plus Australian additions to create a complete set. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AU Recorded Sex or Gender Source Document Type](CodeSystem-rsg-source-document-type.md) | The AU Recorded Sex or Gender Source Document Type code system defines concepts that represent the type of document where this sex or gender value is recorded. |
| [AU Recorded Sex or Gender Type](CodeSystem-rsg-type.md) | The AU Recorded Sex or Gender Type code system defines concepts that represent the type or category of sex or gender that is recorded. |
| [ActCode AU](CodeSystem-au-v3-ActCode.md) | Additional concept codes for act coding defined for use in an Australian context. These codes are used as extensions to the HL7 International code set. |
| [Australian Digital Health Source System](CodeSystem-au-digital-health-source-system.md) | The Australian Digital Health Source System code system defines concepts that represent Australian digital health sources. These concepts may be used to represent which system clinical and/or administrative information is sourced. |
| [Communication Request Category](CodeSystem-communication-request-category.md) | The Communication Request Category code system defines concepts that represent the category for a communication request. |
| [Contact Purpose](CodeSystem-contact-purpose.md) | Purpose for associated contact information. |
| [DegreeLicenseCertificate AU](CodeSystem-au-v2-0360.md) | Additional concept codes for qualification defined for use in an Australian context. These codes are used as extensions to the HL7 International code set. |
| [IdentifierType AU](CodeSystem-au-v2-0203.md) | Additional concept codes for identifier type defined for use in an Australian context. These are additional identifier type codes to the HL7 International code set and suitable for use with Australian identifiers and may be used in HL7 V2.x identifier representations. |
| [Location Type (Physical) AU](CodeSystem-au-location-physical-type.md) | Additional concept codes for location physical type defined for use in Australian context. These codes are used as extensions to the HL7 International code set. |
| [Location Type AU](CodeSystem-au-location-type.md) | Additional concept codes for location type defined for use in an Australian context. These codes are used as extensions to the HL7 International code set. |
| [Medication Type](CodeSystem-medication-type.md) | The Medication Type code system defines concepts in a classification scheme for medication coding. The classification scheme defines the nature of the properties defined by the code e.g. branded product with no strength or form. This allows the distinction between codes provided containing container, pack, strength and form explicitly especially where terminologies supplied are unknown or terminology services are unavailable. |
| [Medicine Item Change](CodeSystem-medicine-item-change.md) | The Medicine Item Change code system defines concepts that identify a change that has been made, or is recommended to be made, to a medicine item. |
| [Monthly Index of Medical Specialties (MIMS)](CodeSystem-mims-external.md) | This CodeSystem resource represents the Monthly Index of Medical Specialties (MIMS) code system published by MIMS Australia. The intended use of MIMS data is to fully specify the product as a combination of product code, form code, and pack code. For example, when providing a MIMS Code within a Clinical Document Architecture (CDA) document, the MIMS code will be a minimum of 5 digits (in most cases, will be 8 digits).This is not the canonical publication of this code system nor it is intended to be publication on behalf of the MIMS Australia. For the complete content of the code system contact the publisher. |
| [Name Context](CodeSystem-name-context.md) | The Name Context code system defines concepts describing usage of names. This provides well known concepts that can be used to indicate usage to achieve an associated purpose e.g. identifier validation. |
| [PBS Item Codes](CodeSystem-pbs-item-external.md) | This CodeSystem resource represents the items listed on the Australian Pharmaceutical Benefits Scheme (PBS) schedule published by the Department of Health. Codes are represented as five or six characters in format (n)nnnna and the display is the PBS prescribing rule preferred term. This is not the canonical publication of this code system nor it is intended to be publication on behalf of the Department of Health. For the complete content of the code system contact the publisher. |
| [Resource Tag](CodeSystem-resource-tag.md) | The Resource Tag code system defines concepts that represent tag values for labelling resources. |
| [Service Provision Conditions Australian Concepts](CodeSystem-service-provision-conditions.md) | The Service Provision Conditions Australian Concepts code system defines concepts that identify the conditions under which a healthcare service is available/offered. |
| [Task Business Status](CodeSystem-task-business-status.md) | The Task Business Status code system defines concepts that represent business status values for a task. |
| [providerRole AU](CodeSystem-au-v2-0443.md) | Additional concept codes for specifying the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.) defined for use in an Australian context. These codes are used as extensions to the HL7 International code set. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [AllergyIntolerance - ibuprofen allergy](AllergyIntolerance-example0.md) | Shows an example of an Ibuprofen allergy with the reaction manifestation as urticaria for the**AU Base AllergyIntolerance**profile. Patient: Harry Dan. |
| [AllergyIntolerance - no known allergy](AllergyIntolerance-example3.md) | Shows an example of an AllergyIntolerance resource indicating the patient has no known allergies for the**AU Base AllergyIntolerance**profile. Patient: John Smith. |
| [AllergyIntolerance - self-reported allergy to eggs](AllergyIntolerance-example1.md) | Shows an example of an allergy to egg protein with reaction manifestations of hives, nausea, and vomiting for the**AU Base AllergyIntolerance**profile. Patient: Sally Grant. |
| [AllergyIntolerance - self-reported intolerance to lactose](AllergyIntolerance-example2.md) | Shows an example of lactose intolerance with reaction manifestations of abdominal pain, abdominal bloating, and diarrhoea for the**AU Base AllergyIntolerance**profile. Patient: Suzanne Simmons. |
| [BodyStructure - Blister of right foot](BodyStructure-example1.md) | Shows an example of a body structure for the**AU Base BodyStructure**profile, representing a blister on the right foot. Patient: Stella Franklin. |
| [BodyStructure - Bone tissue of left shoulder](BodyStructure-example0.md) | Shows an example of a body structure resource for the**AU Base BodyStructure**profile, representing bone tissue in the left shoulder region. Patient: Stella Franklin. |
| [Bundle - Medicine list in a bundle](Bundle-example0.md) | Shows an example of a FHIR Bundle containing resources related to the**AU Medicine List**profile. Patient: Nicholas Jones. |
| [Composition - Patient’s preference upon death](Composition-example0.md) | Shows an example of a composition representing patient goals, preferences, and priorities upon death, including a related person as the author and attester, for the**AU Base Composition**profile. Patient: Stella Franklin. |
| [Composition - with multiple information recipients](Composition-multiple-information-recipients.md) | Shows an example of a composition with multiple information recipients for the**AU Base Composition**profile. Patient: Stella Franklin. |
| [Condition - with evidence and onset date-time](Condition-example0.md) | Shows an example of a condition of Type 2 diabetes mellitus for the**AU Base Condition**profile. Patient: Stella Franklin. |
| [Coverage - DVA Gold Card](Coverage-dva.md) | Shows an example of a coverage record for the**AU Base Coverage**profile, demonstrating a veteran health program under the Department of Veterans' Affairs. Beneficiary: Harry Dan. |
| [Coverage - private health insurer](Coverage-private.md) | Shows an example of a private health insurance coverage record for the**AU Base Coverage**profile, demonstrating a plan under the payor HCF PTY LTD. Beneficiary: Stella Franklin. |
| [Device - as a registered repository service](Device-example1.md) | Shows an example of a Device resource representing a registered repository service. The resource includes the PAI-D identifier, device name, type and owner identifier (PAI-O). |
| [Encounter - Annual check up](Encounter-example1.md) | Shows an example of an encounter for the**AU Base Encounter**profile, representing an annual check up encounter. Patient: Suzanne Simmons. |
| [Encounter - with description](Encounter-example0.md) | Shows an example of an encounter with an encounter description for the**AU Base Encounter**profile. |
| [Endpoint - a secure messaging endpoint example](Endpoint-example0.md) | Shows an example of a secure messaging endpoint using the Endpoint resource. |
| [HealthcareService - Honourable Mark's Home For Aged Men](HealthcareService-example5.md) | Shows an example of an aged care residential service, Honourable Mark's Home For Aged Men, for the**AU Base HealthcareService**profile. |
| [HealthcareService - Leafy Grove Home for the Aged](HealthcareService-example4.md) | Shows an example of an aged care residential service, Leafy Grove Home for the Aged, for the**AU Base HealthcareService**profile. |
| [HealthcareService - a typical Healthcare Service the Radiologist belongs to](HealthcareService-example1.md) | Shows an example of a radiology service, Albion Hospital Radiology Service, for the**AU Base HealthcareService**profile. |
| [HealthcareService - general practice](HealthcareService-example3.md) | Shows an example of a healthcare service, General Practitioner services, for the**AU Base HealthcareService**profile. |
| [HealthcareService - of a Pathologist](HealthcareService-example2.md) | Shows an example of a pathology service, Albion Hospital Pathology Service, for the**AU Base HealthcareService**profile. |
| [HealthcareService - with HPI-O with varied contact details](HealthcareService-example0.md) | Shows an example of a cardiothoracic surgery healthcare service for the**AU Base HealthcareService**profile, with a HPI-O, service name, specialty details, and multiple contact details. |
| [Immunization - Administration of Pfizer Comirnaty dose 1 for Sarah Simmons](Immunization-example3.md) | Shows an example of a completed immunisation record for the**AU Base Immunization**profile, demonstrating the administration of Pfizer Comirnaty for COVID-19. Patient: Sarah Simmons. |
| [Immunization - Administration of a vaccine - record compliant with Australian Immunisation Register (AIR)](Immunization-example1.md) | Shows an example of a completed immunisation record for the**AU Base Immunization**profile, demonstrating the administration of Infanrix-Hep B. The record is compliant with Australian Immunisation Register (AIR). Patient: Sally Grant. |
| [Immunization - Administration of a vaccine with administering provider and protocol](Immunization-example2.md) | Shows an example of a completed immunisation record for the**AU Base Immunization**profile, demonstrating the administration of Infanrix Hexa. Patient: Sally Grant. |
| [Immunization - Non-administration of varicella-zoster live vaccine due to refusal](Immunization-example0.md) | Shows an example of an immunisation record for the**AU Base Immunization**profile, where the administration of the varicella-zoster live vaccine was not completed due to patient objection. Patient: Harry Dan. |
| [List - Medicine list authored by a related person](List-example3.md) | Shows an example of a medication list authored by a related person for the**AU Medicine List**profile. Patient: Suzanne Simmons |
| [List - Medicine list with changes](List-example2.md) | Shows an example of a medication list for the**AU Medicine List**profile, representing a snapshot of a patient's current, amended, and ceased medications. Patient: David Goodpatient. |
| [List - Medicine list with no known current medicine](List-example1.md) | Shows an example of a medication list with no current medications for the**AU Medicine List**profile. Patient: Stella Franklin. |
| [List - Medicine list with referenced entries](List-example0.md) | Shows an example of a medication list for the**AU Medicine List**profile, representing a snapshot of a patient's current medications. Patient: Stella Franklin. |
| [Location - Leafy Grove Home for the Aged](Location-example8.md) | Shows an example of a location for the**AU Base Location**profile, representing a nursing home 'Leafy Grove Home for the Aged' as a location. |
| [Location - Leafy Grove Home for the Not Very Aged](Location-example9.md) | Shows an example of a location for the**AU Base Location**profile, representing a nursing home 'Honourable Mark's Home For Aged Men' as a location. |
| [Location - a hospital location with managing organisation of example0](Location-example0.md) | Shows an example of a hospital location for the**AU Base Location**profile. The resource includes the location details and a reference to the managing organisation, Downunder Hospital. |
| [Location - for mobile services that can be delivered in a person's house, apartment, or unit](Location-example5.md) | Shows an example of a mobile, home-based service location for the**AU Base Location**profile. |
| [Location - for mobile services that can be delivered in residential care facilities](Location-example7.md) | Shows an example of a mobile, residential-care-based service location for the**AU Base Location**profile. |
| [Location - for mobile services that can be delivered in schools](Location-example6.md) | Shows an example of a mobile, school-based service location for the**AU Base Location**profile. |
| [Location - for services delivered by phone, video or online](Location-example4.md) | Shows an example of a virtual telehealth service location for the**AU Base Location**profile. |
| [Location - of a Practitioner as a General Practitioner](Location-example3.md) | Shows an example of a location, Family Medicine Clinic, at which the General Practitioner provides care for the**AU Base Location**profile. |
| [Location - of a Practitioner as a Pathologist](Location-example2.md) | Shows an example of a location at a specific level within a hospital for the**AU Base Location**profile. |
| [Location - of a Practitioner as a Radiologist](Location-example1.md) | Shows an example of a Location resource for the**AU Base Location**profile. |
| [Medication - Branded Pack With Single Active Ingredient](Medication-BrandedPackSingleActiveIngredient0.md) | Shows an example of a medication, Chlorsig (chloramphenicol 0.5%, eye drops), defined by its branded product, single active ingredient, strength, and form for the**AU Base Medication**profile. |
| [Medication - Branded Pack of Nexium HP7 20;500;500](Medication-BrandedPack0.md) | Shows an example of a medication, Nexium HP7 (14 esomeprazole 20 mg tablets, 28 amoxicillin 500 mg capsules, 14 clarithromycin 500 mg tablets, 1 pack), defined by its branded packaging, manufacturer, and form for the**AU Base Medication**profile. |
| [Medication - Branded Pack with Batch Details](Medication-BrandProductwithBatchDetails0.md) | Shows an example of a branded medication, Norvasc, containing the active ingredient amlodipine (10 mg) as a tablet, with batch details including lot number and expiration date, for the**AU Base Medication**profile |
| [Medication - Generic Pack of paracetamol 500mg (100)](Medication-GenericPack0.md) | Shows an example of a medication, Paracetamol 500 mg tablet (100 tablets per pack), defined by its generic packaging, form, and coding for the**AU Base Medication**profile. |
| [Medication - Unbranded Product of clarithromycin 500mg tablet](Medication-UnbrandedProduct0.md) | Shows an example of a medication, Clarithromycin 500mg tablet, defined by dose, form, and strength for the**AU Base Medication**profile. |
| [Medication - Unbranded Product of esomeprazole 20mg tablet](Medication-UnbrandedProduct1.md) | Shows an example of an unbranded product, Esomeprazole 20mg tablet, defined by dose, form, and strength for the**AU Base Medication**profile. |
| [Medication - Unbranded product of amoxicillin 500mg capsule](Medication-UnbrandedProduct2.md) | Shows an example of an unbranded product, Amoxicillin 500mg capsule, defined by dose, form, and strength for the**AU Base Medication**profile. |
| [Medication - branded pack](Medication-BrandedPack1.md) | Shows an example of a medication, Nexium Hp7 (14 x Nexium tablets, 28 x Amoxil capsules, 14 x Klacid tablets) in a single pack, defined by its branded and unbranded package information, manufacturer, and form for the**AU Base Medication**profile. |
| [Medication - dose based](Medication-DoseBased.md) | Shows an example of a medication, Fluconazole-containing product, injection, 200 mg/100 mL, defined by dose, form, and strength for the**AU Base Medication**profile. |
| [Medication - uncoded medicinal product information](Medication-UncodedProduct0.md) | Shows an example of a medication with uncoded medicinal product information, Crestor (Rosuvastatin) 20mg tablet in a 30-pack, defined by its brand and generic names, manufacturer, dose, form, and strength for the**AU Base Medication**profile. |
| [Medication - with Generic Name and Medication Strength Extensions](Medication-StrengthExtension0.md) | Shows an example of a medication, Panadeine, as a caplet, with the generic name and medication strength specified in extensions, for the**AU Base Medication**profile |
| [Medication - with Medication Strength Extension](Medication-StrengthExtension1.md) | Shows an example of a medication, Zolgensma, as a solution for infusion, with the medication strength specified in an extension, for the**AU Base Medication**profile |
| [Medication - with backported R5 Ingredient Strength Element](Medication-IngredientStrengthExtension0.md) | Shows an example of a medication, Tadim, containing the ingredient colistimethate (1 Million IU) as a powder, with ingredient strength specified using the preadopted R5 element strengthCodeableConcept, for the**AU Base Medication**profile |
| [Medication - with four or more active ingredients](Medication-FourOrMoreActiveIngredientsProduct0.md) | Shows an example of a branded medication, Stribild, containing four active ingredients and defined as a tablet for the**AU Base Medication**profile. |
| [Medication - with two active ingredients product](Medication-TwoActiveIngredientsProduct0.md) | Shows an example of a medication with two active ingredients, perindopril arginine (10 mg) and amlodipine (10 mg), defined as a tablet for the**AU Base Medication**profile. |
| [MedicationAdministration - Administration of Chlorsig eye drops](MedicationAdministration-example0.md) | Shows an example of administration of Chlorsig to a patient for the**AU Base MedicationAdministration**profile, administered by a related person. Patient: Harry Dan. |
| [MedicationAdministration - Self-administration of lantus 100 units/mL injection](MedicationAdministration-example1.md) | Shows an example of a medication administration that is a self-administration of lantus 100 units/mL injection for the**AU Base MedicationAdministration**profile. Patient: Sarah Simmons. |
| [MedicationDispense - First dispense for Reaptan](MedicationDispense-example0.md) | Shows an example of a medication dispense for the**AU Base MedicationDispense**profile, representing the first dispensing of Reaptan 10 mg/10 mg (perindopril arginine/amlodipine) tablets. Patient: Stella Franklin. |
| [MedicationDispense - Second dispense for Reaptan](MedicationDispense-example1.md) | Shows an example of a medication dispense for the**AU Base MedicationDispense**profile, representing the second dispensing of Reaptan 10 mg/10 mg (perindopril arginine/amlodipine) tablets. Patient: Stella Franklin. |
| [MedicationRequest - Prescription with brand and generic name extensions](MedicationRequest-example2.md) | Shows an example of a medication request for the**AU Base MedicationRequest**profile, representing a practitioner's order for the patient to take Reaptan for pain management, with detailed dosage instructions and dispensing information. Patient: Stella Franklin. |
| [MedicationRequest - a prescription for Stribild tablet](MedicationRequest-example1.md) | Shows an example of a medication request for the**AU Base MedicationRequest**profile, representing a practitioner's order for a patient to take Stribild daily for human immunodeficiency virus (HIV) infection, with all repeats supplied concurrently for overseas travel. Patient: Stella Franklin. |
| [MedicationRequest - a prescription for codeine with paracetamol](MedicationRequest-example0.md) | Shows an example of a medication request for the**AU Base MedicationRequest**profile, representing a practitioner's order for a patient to take paracetamol 500 mg + codeine phosphate hemihydrate 30 mg tablets for pain management. Patient: Stella Franklin. |
| [MedicationStatement - Practitioner reports patient has taken Diflucan in the past but is not taking it any more](MedicationStatement-example2.md) | Shows an example of a medication statement for the**AU Base MedicationStatement**profile, representing a practitioner reporting that the patient has taken Diflucan in the past but is not taking it anymore. Patient: Stella Franklin. |
| [MedicationStatement - of a record of a patient's long-term use of medication](MedicationStatement-example1.md) | Shows an example of a medication statement for the**AU Base MedicationStatement**profile, including informative record of a patient's long-term use of medication. Patient: Stella Franklin. |
| [MedicationStatement - of a record of a patient's use of medication](MedicationStatement-example0.md) | Shows an example of a medication statement for the**AU Base MedicationStatement**profile, representing a patient's active use of a branded medication with specific timing and dosage details. Patient: Stella Franklin. |
| [Observation - Measurement of Hepatitis B surface antibody](Observation-specimen-hepatitis-b-serology.md) | Shows an example of a laboratory observation for the**AU Base Pathology Result**profile, demonstrating a final serology result for Hepatitis B surface antibody. Patient: Stella Franklin. |
| [Observation - of no relevant finding of immunisations](Observation-norelevantfinding-example1.md) | Shows an example of an observation asserting no history of immunisation for the**AU Assertion of No Relevant Finding**profile. Patient: Stella Franklin. |
| [Observation - of no relevant finding of known history of conditions](Observation-norelevantfinding-example2.md) | Shows an example of an observation asserting no known history of conditions for the**AU Assertion of No Relevant Finding**profile. Patient: Stella Franklin. |
| [Observation - of no relevant finding of patient taking any medications](Observation-norelevantfinding-example3.md) | Shows an example of an observation asserting that the patient is not taking any medications for the**AU Assertion of No Relevant Finding**profile. Patient: Stella Franklin. |
| [Observation - of no relevant finding of procedure](Observation-norelevantfinding-example0.md) | Shows an example of an observation asserting no history of procedure for the**AU Assertion of No Relevant Finding**profile. Patient: Stella Franklin. |
| [Organization - Holistic Medical Pty Ltd with ABN and HPI-O](Organization-example2.md) | Shows an example of an organisation, Holistic Medical Pty Ltd as trustee for Smith Family Trust, for the**AU Base Organization**profile, with HPI-O and ABN identifiers, and contact details including a work email address and a physical address. |
| [Organization - The Corporation of the Council of the Ward of Nundah](Organization-example5.md) | Shows an example of a religious institution, The Corporation of the Synod of the Diocese of Nundah, for the**AU Base Organization**profile, with an ABN, address and contact details. |
| [Organization - a Pathology organisation with HPI-O and is a parent organization](Organization-5-8631-1.md) | Shows an example of a parent pathology and diagnostic imaging organisation with a HPI-O identifier, Test Org - DigitalHealth 5, for the**AU Base Organization**profile. |
| [Organization - a Pathology organisation with NATA Number, ARBN, ABN, ACN, HPI-O and PAI-O](Organization-example6.md) | Shows an example of a pathology organisation, ACME Pathology, for the**AU Base Organization**profile, with multiple identifiers such as HPI-O, NATA Accreditation Number, ABN, ACN, and PAI-O, and a reference to its parent organisation. |
| [Organization - a hospital with an HPIO](Organization-example4.md) | Shows an example of a hospital organisation, Downunder Hospital, for the**AU Base Organization**profile, with a HPI-O. |
| [Organization - a typical Organisation the General Practitioner belongs to](Organization-example3.md) | Shows an example of an organisation, Devonport Family Medicine Clinic, to which the General Practitioner belongs for the**AU Base Organization**profile. |
| [Organization - a typical Organisation the Radiologist belongs to](Organization-example1.md) | Shows an example of an organisation, Albion Hospital, for the**AU Base Organization**profile, with an ABN identifier, type as Private Hospital, and contact details including phone numbers and email addresses. |
| [Organization - with HPI-O](Organization-example0.md) | Shows an example of an organisation, Downunder Hospital, for the**AU Base Organization**profile, with a HPI-O, name, contact details, and address. |
| [Patient - Australian No Fixed Address](Patient-address-example2.md) | Shows an example of an anonymous patient with no fixed address for the**AU Base Patient**profile, indicating a temporary address. |
| [Patient - Australian address with identifiers](Patient-address-example3.md) | Shows an example of a patient address for the**AU Base Patient**profile, with identifiers |
| [Patient - as a Culturally and linguistically diverse (CALD) patient 1](Patient-example6.md) | Shows an example of a patient, William Rigny, who requires an interpreter for healthcare communication, with their preferred communication language specified, for the**AU Base Patient**profile. |
| [Patient - as a Culturally and linguistically diverse (CALD) patient 2](Patient-example7.md) | Shows an example of a patient, Alejandro Hernández, born in Mexico and requiring an interpreter for healthcare communication, for the**AU Base Patient**profile. The example also includes Alejandro's gender identity and their date of arrival in Australia. |
| [Patient - as a child born in 2008](Patient-example4.md) | Shows an example of a child patient, Suzanne Simmons, for the**AU Base Patient**profile. |
| [Patient - as a mother for the patient in example 4](Patient-example5.md) | Shows an example of a patient, Sarah Simmons, as the mother of Suzanne Simmons in example 4, for the**AU Base Patient**profile. |
| [Patient - as transgender person with sex and gender and sex parameter for clinical use](Patient-example-sex-and-gender.md) | Shows an example of a patient, Patricia Roth, for**AU Base Patient**profile that demonstrates the adopted extensions for sex and gender. This example is taken and adapted from the R5 Transgender Person Example. |
| [Patient - male born in 1949 with address and contact details](Patient-example8.md) | Shows an example of a patient, Nicholas Jones, for the**AU Base Patient**profile. The resource includes an IHI, Australian Indigenous Status extension, and contact details and address. |
| [Patient - structured Australian Address](Patient-address-example0.md) | Shows an example of a patient with structured work addresses, including a postal address and a physical address, for the**AU Base Patient**profile. |
| [Patient - unstructured Australian Address](Patient-address-example1.md) | Shows an example of a patient with an unstructured physical address for the**AU Base Patient**profile. |
| [Patient - with Birth Date Accuracy Indicator of AAA](Patient-DateAccuracyIndicatorAAAexample0.md) | Shows an example of a patient for the**AU Base Patient**profile with Date Accuracy Indicator extension Accurate Year, Accurate Month and Accurate Date. |
| [Patient - with Birth Date Accuracy Indicator of AAU](Patient-DateAccuracyIndicatorAAUexample1.md) | Shows an example of a patient for the**AU Base Patient**profile with Date Accuracy Indicator extension Accurate Year, Accurate Month and Unknown Date |
| [Patient - with Birth Date Accuracy Indicator of UAA](Patient-DateAccuracyIndicatorUAAexample2.md) | Shows an example of a patient for the**AU Base Patient**profile with Date Accuracy Indicator extension Unknown Year, Accurate Month and Accurate Date. |
| [Patient - with Birth Date Accuracy Indicator of UEA](Patient-DateAccuracyIndicatorUEAexample3.md) | Shows an example of a patient for the**AU Base Patient**profile with Date Accuracy Indicator extension Unknown Year, Estimated Month and Accurate Date. |
| [Patient - with Birth Date Accuracy Indicator of UUU](Patient-DateAccuracyIndicatorUUUexample4.md) | Shows an example of a patient for the**AU Base Patient**profile with Date Accuracy Indicator extension Unknown Year, Unknown Month and Unknown Date. |
| [Patient - with IHI, DVA Number (with specific card colour) and the extension for Indigenous Status](Patient-example1.md) | Shows an example of a patient, Harry Dan, for the**AU Base Patient**profile. The resource includes IHI (expired) and DVA Gold Card Number, extension for Australian Veteran Status and Indigenous Status. |
| [Patient - with IHI, Medicare Card Number, patient internal identifier and the extension for Indigenous Status](Patient-example0.md) | Shows an example of a patient, Stella Franklin, for the**AU Base Patient**profile. The resource includes IHI, Medicare Card Number, Health Card Number, patient internal identifier and extensions for Australian Indigenous Status, IHI validation name context, and gender identity. |
| [Patient - with birth date and birth time](Patient-example3.md) | Shows an example of a patient, John Smith, for the**AU Base Patient**profile. The resource includes a name, email contact, birth details (date and time with an extension for date accuracy), and residential address. |
| [Patient - with no birth date, and is eligible for Closing the Gap registration](Patient-example2.md) | Shows an example of a patient, Sally Grant, for the**AU Base Patient**profile. The resource includes a Medicare Number, extensions for Australian Indigenous Status and Closing the Gap registration, with unknown date of birth. |
| [Practitioner - a typical Ahpra registered professional](Practitioner-example4.md) | Shows an example of a practitioner, Dr. Robert Smith, with multiple identifiers (HPI-I and Ahpra Registration Number), qualifications and communication language for the**AU Base Practitioner**profile. |
| [Practitioner - a typical Practitioner as a General Practitioner](Practitioner-example3.md) | Shows an example of a practitioner, Dr. Francis Fernando, with a HPI-I and Ahpra Registration Number for the**AU Base Practitioner**profile. |
| [Practitioner - as a Pathologist](Practitioner-example2.md) | Shows an example of a Pathologist, Dr. Peter Winslow, for the**AU Base Practitioner**profile, with an Ahpra Registration Number. |
| [Practitioner - as a Radiologist](Practitioner-example1.md) | Shows an example of a Radiologist, Dr. Steve Smith, for the**AU Base Practitioner**profile, with an Ahpra Registration Number. |
| [Practitioner - sex and gender](Practitioner-example-sex-and-gender.md) | Shows an example of a practitioner for the**AU Base Practitioner**profile that demonstrates the adopted extensions for sex and gender. |
| [Practitioner - with HPI-I and Prescriber Number](Practitioner-example0.md) | Shows an example of a practitioner, Dr. Helen Mayo, with multiple identifiers including HPI-I, Prescriber Number, Ahpra Registration Number, and Care Agency Employee Identifier and use of HPI-I validation name context extension for the**AU Base Practitioner**profile. |
| [PractitionerRole - a typical Practitioner Role as a General Practitioner](PractitionerRole-example3.md) | Shows an example of a General Practitioner role for the**AU Base Practitioner**profile, including a Medicare Provider Number identifier, contact details, references to the associated Practitioner, Organization, Location, and HealthcareService, as well as availability on weekdays and unavailability on weekends. |
| [PractitionerRole - a typical Practitioner Role as a Radiologist](PractitionerRole-example1.md) | Shows an example of a Radiologist role for the**AU Base PractitionerRole**profile, including a National Provider Identifier at Organisation (NPIO) identifier, contact details, references to the associated Practitioner, Organization, Location, and HealthcareService, as well as availability exceptions for public holidays. |
| [PractitionerRole - as a Pathologist](PractitionerRole-example2.md) | Shows an example of a General pathologist role for the**AU Base PractitionerRole**profile, including an Employee Number identifier, specialty in General Pathology, contact details, references to the associated Practitioner, Organization, Location, and HealthcareService, as well as availability times. |
| [PractitionerRole - with Provider Number and ANZSCO coded role](PractitionerRole-example0.md) | Shows an example of a Cardiologist role for the**AU Base PractitionerRole**profile, including a Medicare Provider Number identifier, specialty in Cardiology, contact details for work and after-hours purposes, and references to the associated Practitioner, Organization, and Location. |
| [PractitionerRole - with assigning authority](PractitionerRole-example4.md) | Shows an example of a Cardiologist role for the**AU Base PractitionerRole**profile, including identifiers for Medicare Provider Number and Vendor Directory, an active status, contact details, references to the associated Practitioner, Organization, Location, and an Endpoint for secure messaging. |
| [Procedure - Cardiac catheterisation](Procedure-example1.md) | Shows an example of a completed cardiac catheterisation procedure for the**AU Base Procedure**profile. Patient: Harry Dan. |
| [Procedure - Cryotherapy](Procedure-example0.md) | Shows an example of a completed cryotherapy procedure for the**AU Base Procedure**profile. Patient: William Rigny. |
| [Procedure - Stent placement](Procedure-example2.md) | Shows an example of a completed procedure for the**AU Base Procedure**profile. Patient: Harry Dan. |
| [RelatedPerson - as a carer for an older patient](RelatedPerson-example1.md) | Shows an example of a related person, Mary Smith, who is a caregiver for Harry Dan, for the**AU Base RelatedPerson**profile. |
| [RelatedPerson - as a mother for the patient in example 4](RelatedPerson-example2.md) | Shows an example of a related person, Sarah Simmons, who is the mother of Suzanne Simmons, for the**AU Base RelatedPerson**profile. |
| [RelatedPerson - as attester party](RelatedPerson-example0.md) | Shows an example of a related person, Benedicte du Marche, who is the next-of-kin for Stella Franklin, for the**AU Base RelatedPerson**profile. |
| [RelatedPerson - as family member with sex and gender](RelatedPerson-example-sex-and-gender.md) | Shows an example of a related person, Alex Baker, for the**AU Base RelatedPerson**profile, demonstrating the adopted extensions for sex and gender. |
| [RelatedPerson - as father](RelatedPerson-example3.md) | Shows an example of a related person, Bill Simmons, who is the father of Alejandro Hernández, for the**AU Base RelatedPerson**profile. |
| [ServiceRequest - for Hepatitis B surface antibody measurement](ServiceRequest-hepatitis-b-antibody.md) | Shows an example of a completed request for Hepatitis B surface antibody measurement for the**AU Base ServiceRequest**profile. Patient: Stella Franklin. |
| [ServiceRequest - full blood count, and sex parameter for clinical use](ServiceRequest-path-example0.md) | Shows an example of an active request for a full blood count for the**AU Base ServiceRequest**profile with Sex Parameter for Clinical Use. Patient: Harry Dan. |
| [Specimen - Serum sample](Specimen-serum.md) | Shows an example of a serum sample specimen for the**AU Base Specimen**profile. Patient: Stella Franklin. |
| [Substance - body substance of epiglottic mucus](Substance-example0.md) | Shows an example for a body substance of epiglottic mucus for the AU Base Substance profile. |
| [Substance - medication substance with two active ingredients](Substance-example2.md) | Shows an example for a medication substance with two active ingredients for the**AU Base Substance**profile. |
| [Substance - peanuts as an allergen](Substance-example1.md) | Shows an example for an allergen substance of peanuts for the**AU Base Substance**profile. |
| [​Composition - with some sections having a different section author to the composition author](Composition-different-authors.md) | Shows an example of a composition with sections authored by different individuals for the**AU Base Composition**profile. Patient: Stella Franklin. |

