# AU Time Zone - AU Base Implementation Guide v6.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU Time Zone**

## ValueSet: AU Time Zone 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org.au/ValueSet/au-timezone | *Version*:6.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](generalguidance.md#maturity-levels): 1 | *Computable Name*:AUTimeZone |
| *Other Identifiers:*OID:2.16.840.1.113883.2.3.4.2.4.27 | | |
| **Copyright/Legal**: HL7 Australia© 2018+; Licensed Under Creative Commons No Rights Reserved. | | |

 
Australian time zones. 

 **References** 

* [Australian Time Zone](StructureDefinition-au-timezone.md)
* [Australian Time Zone Usage](StructureDefinition-au-timezone-usage.md)

**Changes since version 5.0.0:**

* No changes

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "au-timezone",
  "meta" : {
    "profile" : [
      "https://healthterminologies.gov.au/fhir/StructureDefinition/composed-value-set-4"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ImplementationGuide/hl7.fhir.au.base"
          }
        ]
      }
    }
  ],
  "url" : "http://terminology.hl7.org.au/ValueSet/au-timezone",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.2.3.4.2.4.27"
    }
  ],
  "version" : "6.0.0",
  "name" : "AUTimeZone",
  "title" : "AU Time Zone",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-15T22:19:01+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia FHIR Working Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Australian time zones.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "HL7 Australia© 2018+; Licensed Under Creative Commons No Rights Reserved.",
  "compose" : {
    "include" : [
      {
        "system" : "https://www.iana.org/time-zones",
        "concept" : [
          {
            "code" : "Australia/Adelaide",
            "display" : "Australia/Adelaide"
          },
          {
            "code" : "Australia/Brisbane",
            "display" : "Australia/Brisbane"
          },
          {
            "code" : "Australia/Broken_Hill",
            "display" : "Australia/Broken_Hill"
          },
          {
            "code" : "Australia/Darwin",
            "display" : "Australia/Darwin"
          },
          {
            "code" : "Australia/Eucla",
            "display" : "Australia/Eucla"
          },
          {
            "code" : "Australia/Hobart",
            "display" : "Australia/Hobart"
          },
          {
            "code" : "Australia/Lord_Howe",
            "display" : "Australia/Lord_Howe"
          },
          {
            "code" : "Australia/Melbourne",
            "display" : "Australia/Melbourne"
          },
          {
            "code" : "Australia/Perth",
            "display" : "Australia/Perth"
          },
          {
            "code" : "Australia/Sydney",
            "display" : "Australia/Sydney"
          },
          {
            "code" : "Pacific/Norfolk",
            "display" : "Pacific/Norfolk"
          },
          {
            "code" : "Indian/Christmas",
            "display" : "Indian/Christmas"
          },
          {
            "code" : "Indian/Cocos",
            "display" : "Indian/Cocos"
          }
        ]
      }
    ]
  }
}

```
