# IdentifierType AU - AU Base Implementation Guide v6.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **IdentifierType AU**

## CodeSystem: IdentifierType AU 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org.au/CodeSystem/v2-0203 | *Version*:6.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](generalguidance.md#maturity-levels): 2 | *Computable Name*:IdentifierTypeAU |
| *Other Identifiers:*OID:2.16.840.1.113883.2.3.4.1.3.203 | | |
| **Copyright/Legal**: HL7 Australia© 2018+; Licensed Under Creative Commons No Rights Reserved. | | |

 
Additional concept codes for identifier type defined for use in an Australian context. These are additional identifier type codes to the HL7 International code set and suitable for use with Australian identifiers and may be used in HL7 V2.x identifier representations. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [DVAEntitlement](ValueSet-dva-entitlement.md)
* [Hl7VSIdentifierTypeAUExtended](ValueSet-au-v2-0203-extended.md)

**Changes since version 5.0.0:**

* The resource metadata has changed (versionNeeded)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "au-v2-0203",
  "meta" : {
    "profile" : [
      "https://healthterminologies.gov.au/fhir/StructureDefinition/complete-code-system-4"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ImplementationGuide/hl7.fhir.au.base"
          }
        ]
      }
    }
  ],
  "url" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.2.3.4.1.3.203"
    }
  ],
  "version" : "6.0.0",
  "name" : "IdentifierTypeAU",
  "title" : "IdentifierType AU",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-15T22:19:01+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia FHIR Working Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Additional concept codes for identifier type defined for use in an Australian context. These are additional identifier type codes to the HL7 International code set and suitable for use with Australian identifiers and may be used in HL7 V2.x identifier representations.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "HL7 Australia© 2018+; Licensed Under Creative Commons No Rights Reserved.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org.au/ValueSet/v2-0203",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "count" : 27,
  "concept" : [
    {
      "code" : "AHPRA",
      "display" : "Australian Health Practitioner Regulation Agency Registration Number",
      "definition" : "An Australian Health Practitioner Regulation Authority (Ahpra) registration number assigned to a practitioner for each profession in which they are registered. Practitioners registered in more than one profession have one registration number for each profession."
    },
    {
      "code" : "CAEI",
      "display" : "Care Agency Employee Identifier",
      "definition" : "A My Health Record assigned Care Agency Employee Identifier is issued to an employee of, or person under contracted arrangement with, a Care Agency that participates in the My Health Record."
    },
    {
      "code" : "CSPRN",
      "display" : "Contracted Service Provider Registration Number",
      "definition" : "A Contracted Service Provider (CSP) Registration Number is issued to organisations that participate in the My Health Record and/or the Healthcare Identifiers Service as a CSP."
    },
    {
      "code" : "DPID",
      "display" : "Australia Post Delivery Point Identifier",
      "definition" : "An Australia Post Delivery Point Identifier (DPID) allocated to an address. A DPID enables each delivery point in Australia to be uniquely identified."
    },
    {
      "code" : "DVAU",
      "display" : "DVA Number",
      "definition" : "An individual's state-based Department of Veterans’ Affairs (DVA) File number. Entitlement is not specified with the use of this code."
    },
    {
      "code" : "DVG",
      "display" : "DVA Number (Gold Card)",
      "definition" : "An individual's state-based Department of Veterans’ Affairs (DVA) File number as displayed on a Veteran Gold Card (the new name for a DVA Gold card). A Veteran Gold Card issued by Department of Veterans’ Affairs (DVA) to an eligible individual provides access to benefits associated with that card."
    },
    {
      "code" : "DVL",
      "display" : "DVA Number (Lilac Card)",
      "definition" : "An individual's state-based Department of Veterans’ Affairs (DVA) File number as displayed on a DVA Lilac card). DVA Lilac Cards are no longer in use and were issued by Department of Veterans’ Affairs (DVA) to eligible individuals 1987-1996."
    },
    {
      "code" : "DVO",
      "display" : "DVA Number (Orange Card)",
      "definition" : "An individual's state-based Department of Veterans’ Affairs (DVA) File number as displayed on a Veteran Orange Card (the new name for a DVA Orange card). A Veteran Orange Card issued by Department of Veterans’ Affairs (DVA) to an eligible individual provides access to benefits associated with that card."
    },
    {
      "code" : "DVW",
      "display" : "DVA Number (White Card)",
      "definition" : "An individual's state-based Department of Veterans’ Affairs (DVA) File number as displayed on a Veteran White Card (the new name for a DVA White card). A Veteran White Card issued by Department of Veterans’ Affairs (DVA) to an eligible individual provides access to benefits associated with that card."
    },
    {
      "code" : "ETP",
      "display" : "Electronic Transfer of Prescription Identifier",
      "definition" : "An identifier allocated by an Electronic Transfer of Prescription (ETP) supplier, sometimes related to a barcode."
    },
    {
      "code" : "GNAF",
      "display" : "Geocoded National Address File Identifier",
      "definition" : "A Geocoded National Address File (G-NAF) Identifier assigned to a location address in the G-NAF. The PSMA G-NAF is Australia’s authoritative, geocoded address file."
    },
    {
      "code" : "LDI",
      "display" : "Local Dispense Identifier",
      "definition" : "An identifier unique to a dispense within the local system set of dispense records."
    },
    {
      "code" : "LPN",
      "display" : "Local Prescription Number",
      "definition" : "An identifier unique to a prescription within the local system set of prescriptions."
    },
    {
      "code" : "LRI",
      "display" : "Local Report Identifier",
      "definition" : "An identifier unique to a report within the local system set of reports."
    },
    {
      "code" : "LSPN",
      "display" : "Location Specific Practice Number",
      "definition" : "An identifier assigned under the Medicare program to uniquely identify practice sites that provide diagnostic imaging and radiation oncology services."
    },
    {
      "code" : "NATAA",
      "display" : "NATA Accreditation Number",
      "definition" : "A National Association of Testing Authorities (NATA) accreditation number associated with an accredited facility. A NATA accreditation number is associated with an organisation."
    },
    {
      "code" : "NATAS",
      "display" : "NATA Site Number",
      "definition" : "A National Association of Testing Authorities (NATA) site number associated with an accredited facility. A NATA site number represents a specific location associated with an accredited facility, i.e. an organisation with a NATA accreditation number."
    },
    {
      "code" : "NDI",
      "display" : "National Device Identifier",
      "definition" : "An identifier unique to a device assigned by an identifier scheme managed at a national level, this is commonly a My Health Record Assigned Identity - Device (PAI-D) identifier."
    },
    {
      "code" : "NOI",
      "display" : "National Organisation Identifier",
      "definition" : "An identifier unique to an organisation assigned by an identifier scheme managed at a national level, this is commonly a Healthcare Provider Identifier - Organisation (HPI-O) but may be a My Health Record Assigned Identity - Organisation (PAI-O) identifier."
    },
    {
      "code" : "NPIO",
      "display" : "National provider at organisation identifier",
      "definition" : "A National Provider Identifier at Organisation (NPIO) uniquely identifies an individual practitioner at an organisation using the practitioner’s HPI-I and organisation’s HPI-O to form the NPIO."
    },
    {
      "code" : "NRI",
      "display" : "National Repository Identifier",
      "definition" : "An identifier unique to a repository assigned by an identifier scheme managed at a national level, this is commonly a My Health Record Assigned Identity - Repository (PAI-R) identifier."
    },
    {
      "code" : "PAN",
      "display" : "Pharmacy Approval Number",
      "definition" : "An identifier unique to a pharmacy that is approved to supply pharmaceutical benefits at particular premises under the the National Health Act 1953."
    },
    {
      "code" : "PRES",
      "display" : "Prescriber Number",
      "definition" : "A Pharmaceutical Benefits Scheme (PBS) prescriber identifier assigned to an individual that identifies the right to act as a prescriber under that scheme."
    },
    {
      "code" : "RACSI",
      "display" : "Residential Aged Care Service Identifier",
      "definition" : "A residential aged care service identifier, commonly known as RACS ID or RACF ID, assigned by the Department of Health to a residential aged care service subsidised by the Australian Government. An organisation may provide more than one residential aged care service."
    },
    {
      "code" : "SEN",
      "display" : "Commonwealth Seniors Health Card",
      "definition" : "An identifier unique to an individual, used to confirm concessions by most government agencies and utility providers, as displayed on a Commonwealth Seniors Healthcare Card. A Commonwealth Seniors Healthcare Card may be issued by Services Australia or Department of Veterans’ Affairs (DVA) to an eligible individual to provide access to certain benefits."
    },
    {
      "code" : "UPIN",
      "display" : "Medicare Provider Number",
      "definition" : "A Medicare provider number, assigned by Services Australia under the Medicare program, to practitioners who provide services that are eligible for a Medicare benefit. This is a location-specific identifier, a practitioner may hold more than one."
    },
    {
      "code" : "VDI",
      "display" : "Vendor Directory Identifier",
      "definition" : "A unique vendor identifier allocated to a provider directory entry (PractitionerRole or HealthcareService)."
    }
  ]
}

```
