# Terminology - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* **Terminology**

## Terminology

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This page lists all ValueSets and CodeSystems supported as part of AU eRequesting.

Terminology supported in AU eRequesting is published in AU eRequesting, [AU Base](https://hl7.org.au/fhir/6.0.0/terminology.html), the FHIR standard, [HL7 Terminology (THO)](https://terminology.hl7.org/), or the [National Clinical Terminology Service (NCTS)](https://www.healthterminologies.gov.au/).

Implementers are advised to take note that expansions of value sets visible in this guide may differ from expansions returned with a server using
[HL7 Terminology (THO)](http://terminology.hl7.org)version 6.0.0 or higher.

### Value Sets

The following value sets are supported in AU eRequesting, i.e bound as [preferred](https://hl7.org/fhir/R4/terminologies.html#preferred) or stronger to a supported element, element slice, or extension in an AU eRequesting profile.

Work is underway within [RANZCR](https://www.ranzcr.com/) to finalise the development of the Radiology Referral Set (RRS) with the aim of including all radiology procedures performed in Australia. The [RANZCR Radiology Referral](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/ranzcr-radiology-referral-1) value set published in the [NCTS](https://www.healthterminologies.gov.au/integration/R4/fhir) is an evolving draft that is derived from the latest agreed set of concepts from the RRS. Implementers are advised to take note that concepts within the value set will continue to expand and evolve when further iterations of the Radiology Referral Set are available.

Column attribute descriptions are as follows:

* **ValueSet:** The title of the value set.
* **Profiles and Extensions where used:** The profiles and extensions that reference the value set.
* **Available from:** Where the value set is published.

| | | |
| :--- | :--- | :--- |
| [ActEncounterCode - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v3-ActEncounterCode-extended.html) | [AU Core Encounter](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-encounter.html),[AU eRequesting Encounter](StructureDefinition-au-erequesting-encounter.md) | AU Base |
| [AdministrativeGender](https://hl7.org/fhir/R4/valueset-administrative-gender.html) | [AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md),[Patient (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Patient-uv-ips.html) | FHIR |
| [AddressUse](http://hl7.org/fhir/ValueSet/address-use) | [AU Core Organization](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-organization.html),[AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html),[AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md) | FHIR |
| [AddressType](http://hl7.org/fhir/ValueSet/address-type) | [AU Core Organization](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-organization.html),[AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html),[AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md) | FHIR |
| [AU eRequesting CommunicationRequest Category](ValueSet-au-erequesting-communicationrequest-category.md) | [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md),[AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md),[AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md),[AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md) | AU eRequesting |
| [AU eRequesting CommunicationRequest Patient Medium](ValueSet-au-erequesting-communicationrequest-patientmedium.md) | [AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md) | AU eRequesting |
| [AU eRequesting Coverage Type and Self-Pay Codes](ValueSet-au-erequesting-coverage-type.md) | [AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md) | AU eRequesting |
| [AU eRequesting Fulfilment Task Tags](ValueSet-au-erequesting-fulfilment-task-tags.md) | [AU eRequesting Task](StructureDefinition-au-erequesting-task.md) | AU eRequesting |
| [AU eRequesting RequestStatus](ValueSet-au-erequesting-request-status.md) | [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md),[AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md),[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | AU eRequesting |
| [AU eRequesting Task Business Status](ValueSet-au-erequesting-task-businessstatus.md) | [AU eRequesting Task](StructureDefinition-au-erequesting-task.md),[AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md),[AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md),[AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md) | AU eRequesting |
| [AU eRequesting Task Status](ValueSet-au-erequesting-task-status.md) | [AU eRequesting Task](StructureDefinition-au-erequesting-task.md),[AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md),[AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md),[AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md) | AU eRequesting |
| [Australian Indigenous Status](https://healthterminologies.gov.au/fhir/ValueSet/australian-indigenous-status-1) | [AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md) | NCTS |
| [Australian Pronouns](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/australian-pronouns-1) | [Individual Pronouns](http://hl7.org/fhir/StructureDefinition/individual-pronouns) | NCTS |
| [Australian States and Territories](https://healthterminologies.gov.au/fhir/ValueSet/australian-states-territories-2) | [AU Core Organization](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-organization.html),[AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html),[AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md) | NCTS |
| [Body Site](https://healthterminologies.gov.au/fhir/ValueSet/body-site-1) | [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md),[AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md),[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | NCTS |
| [Clinical Condition](https://healthterminologies.gov.au/fhir/ValueSet/clinical-condition-1) | [AU Core Condition](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-condition.html) | NCTS |
| [Clinical Specialty](https://healthterminologies.gov.au/fhir/ValueSet/clinical-specialty-1) | [AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md) | NCTS |
| [Common Languages in Australia](https://healthterminologies.gov.au/fhir/ValueSet/common-languages-australia-2) | [AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md) | NCTS |
| [Condition Category Codes](https://hl7.org/fhir/R4/valueset-condition-category.html) | [AU Core Condition](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-condition.html) | FHIR |
| [Condition Clinical Status Codes](https://hl7.org/fhir/R4/valueset-condition-clinical.html) | [AU Core Condition](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-condition.html) | FHIR |
| [Condition/Diagnosis Severity](https://hl7.org/fhir/R4/valueset-condition-severity.html) | [AU Core Condition](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-condition.html) | FHIR |
| [ConditionVerificationStatus](https://hl7.org/fhir/R4/valueset-condition-ver-status.html) | [AU Core Condition](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-condition.html) | FHIR |
| [ContactPointSystem](http://hl7.org/fhir/ValueSet/contact-point-system) | [AU Core Organization](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-organization.html),[AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html),[AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md),[AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md) | FHIR |
| [ContactPointUse](http://hl7.org/fhir/ValueSet/contact-point-use) | [AU Core Organization](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-organization.html),[AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html),[AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md),[AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md) | FHIR |
| [Coverage Type and Self-Pay Codes - AU Extended](https://hl7.org.au/fhir/ValueSet-au-coverage-type-extended.html) | [AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md) | AU Base |
| [DocumentReferenceStatus](https://hl7.org/fhir/R4/valueset-document-reference-status.html) | [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md) | FHIR |
| [DVA Entitlement](https://hl7.org.au/fhir/ValueSet-dva-entitlement.html) | [AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md) | AU Base |
| [EncounterStatus](https://hl7.org/fhir/R4/valueset-encounter-status.html) | [AU Core Encounter](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-encounter.html),[AU eRequesting Encounter](StructureDefinition-au-erequesting-encounter.md) | FHIR |
| [EventStatus](https://hl7.org/fhir/R4/valueset-event-status.html) | [AU Core Procedure](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-procedure.html) | FHIR |
| [Gender Identity Response](https://healthterminologies.gov.au/fhir/ValueSet/gender-identity-response-1) | [Individual Gender Identity](http://hl7.org/fhir/StructureDefinition/individual-genderIdentity) | NCTS |
| [Healthcare Organisation Role Type](https://healthterminologies.gov.au/fhir/ValueSet/healthcare-organisation-role-type-1) | [AU Core Organization](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-organization.html),[AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md) | NCTS |
| [hl7VS-identifierType - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v2-0203-extended.html) | [AU Core Organization](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-organization.html),[AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md) | AU Base |
| [IdentifierUse](https://hl7.org/fhir/R4/valueset-identifier-use.html) | [AU Core Organization](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-organization.html),[AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html),[AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md),[AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md),[AU Local Order Identifier](https://hl7.org.au/fhir/StructureDefinition-au-localorderidentifier.html) | FHIR |
| [Imaging Procedure](https://healthterminologies.gov.au/fhir/ValueSet/imaging-procedure-1) | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | NCTS |
| [Individual Healthcare Identifier Status](https://healthterminologies.gov.au/fhir/ValueSet/ihi-status-1) | [AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md) | NCTS |
| [Location Type (Physical) - AU Extended](https://hl7.org.au/fhir/ValueSet-au-location-physical-type-extended.html) | [AU Core Location](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-location.html) | AU Base |
| [Mime Types](https://hl7.org/fhir/R4/valueset-mimetypes.html) | [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md) | FHIR |
| [NameUse](https://hl7.org/fhir/R4/valueset-name-use.html) | [AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html),[AU Core RelatedPerson](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-relatedperson.html),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md),[Patient (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Patient-uv-ips.html) | FHIR |
| [Order Identifier Type](https://hl7.org.au/fhir/ValueSet-order-identifier-type.html) | [AU Local Order Identifier](https://hl7.org.au/fhir/StructureDefinition-au-localorderidentifier.html) | AU Base |
| [Participant type](https://hl7.org/fhir/R4/valueset-encounter-participant-type.html) | [AU Core Encounter](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-encounter.html),[AU eRequesting Encounter](StructureDefinition-au-erequesting-encounter.md) | FHIR |
| [Pathology Fasting Status](https://healthterminologies.gov.au/fhir/ValueSet/pathology-fasting-status-1) | [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md),[AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md),[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | NCTS |
| [Pathology Procedure](https://healthterminologies.gov.au/fhir/ValueSet/pathology-procedure-1) | [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | NCTS |
| [Procedure](https://healthterminologies.gov.au/fhir/ValueSet/procedure-1) | [AU Core Procedure](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-procedure.html) | NCTS |
| [Practitioner Role](https://healthterminologies.gov.au/fhir/ValueSet/practitioner-role-1) | [AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md) | NCTS |
| [Pregnancy Expected Delivery Date Method - IPS](https://hl7.org/fhir/uv/ips/STU2/ValueSet-edd-method-uv-ips.html) | [Observation Pregnancy - Expected Delivery Date (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-pregnancy-edd-uv-ips.html) | IPS |
| [Pregnancy Status - IPS](https://hl7.org/fhir/uv/ips/STU2/ValueSet-pregnancy-status-uv-ips.html) | [Observation Pregnancy - Status (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-pregnancy-status-uv-ips.html) | IPS |
| [RANZCR Radiology Referral](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/ranzcr-radiology-referral-1) | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | NCTS |
| [RCPA - SPIA Requesting Pathology Terminology Reference Set](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/spia-requesting-refset-3) | [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | NCTS |
| [Reason For Encounter](https://healthterminologies.gov.au/fhir/ValueSet/reason-for-encounter-1) | [AU Core Encounter](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-encounter.html),[AU eRequesting Encounter](StructureDefinition-au-erequesting-encounter.md) | NCTS |
| [Reason for Request](https://healthterminologies.gov.au/fhir/ValueSet/reason-for-request-1) | [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md),[AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md),[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | NCTS |
| [Related Person Relationship Type](https://healthterminologies.gov.au/fhir/ValueSet/related-person-relationship-type-1) | [AU Core RelatedPerson](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-relatedperson.html) | NCTS |
| [Request priority](https://hl7.org/fhir/R4/valueset-request-priority.html) | [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md),[AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md),[AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md),[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md),[AU eRequesting Task](StructureDefinition-au-erequesting-task.md),[AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md),[AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md),[AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md) | FHIR |
| [RequestStatus](http://hl7.org/fhir/ValueSet/request-status) | [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md),[AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md),[AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md),[AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md) | FHIR |
| [ServiceDeliveryLocationRoleType - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v3-ServiceDeliveryLocationRoleType-extended.html) | [AU Core Location](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-location.html) | AU Base |
| [Service Type](https://healthterminologies.gov.au/fhir/ValueSet/service-type-1) | [AU Core Encounter](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-encounter.html),[AU eRequesting Encounter](StructureDefinition-au-erequesting-encounter.md) | NCTS |
| [Sex Parameter For Clinical Use](http://terminology.hl7.org/ValueSet/sex-parameter-for-clinical-use) | [Patient Sex Parameter for Clinical Use](https://hl7.org/fhir/extensions/StructureDefinition-patient-sexParameterForClinicalUse.html) | HL7 Terminology (THO) |
| [TaskIntent](http://hl7.org/fhir/R4/valueset-task-intent.html) | [AU eRequesting Task](StructureDefinition-au-erequesting-task.md),[AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md),[AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md),[AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md) | FHIR |

### Code Systems

See the [FHIR terminology section](http://hl7.org/fhir/R4/terminologies-systems.html) for a complete discussion on code systems and a list of code system names used in FHIR.

The following code systems are referenced by the value sets listed above or are the code system for a fixed value in an AU eRequesting profile.

Column attribute descriptions are as follows:

* **CodeSystem:** The title of a code system.
* **ValueSet where used:** The value set(s) that reference the code system or the profile where a fixed value is applied.
* **Available from:** Where the code system is published.
* **Publisher:** Identifies the organisation responsible for maintaining the code system.

| | | | |
| :--- | :--- | :--- | :--- |
| [ActCode](https://terminology.hl7.org/5.3.0/CodeSystem-v3-ActCode.html) | [ActEncounterCode - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v3-ActEncounterCode-extended.html),[AU eRequesting Coverage Type and Self-Pay Codes](ValueSet-au-erequesting-coverage-type.md),[Coverage Type and Self-Pay Codes - AU Extended](https://hl7.org.au/fhir/ValueSet-au-coverage-type-extended.html) | HL7 Terminology (THO) | Health Level Seven International |
| [ActCode AU](https://hl7.org.au/fhir/CodeSystem-au-v3-ActCode.html) | [ActEncounterCode - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v3-ActEncounterCode-extended.html),[Coverage Type and Self-Pay Codes - AU Extended](https://hl7.org.au/fhir/ValueSet-au-coverage-type-extended.html) | AU Base | HL7 Australia |
| [AdministrativeGender](https://hl7.org/fhir/R4/codesystem-administrative-gender.html) | [AdministrativeGender](https://hl7.org/fhir/R4/valueset-administrative-gender.html) | FHIR | Health Level Seven International |
| [AddressUse](http://hl7.org/fhir/address-use) | [AddressUse](http://hl7.org/fhir/ValueSet/address-use) | FHIR | Health Level Seven International |
| [AddressType](http://hl7.org/fhir/address-type) | [AddressType](http://hl7.org/fhir/ValueSet/address-type) | FHIR | Health Level Seven International |
| [Australian Indigenous Status](https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1) | [Australian Indigenous Status](https://healthterminologies.gov.au/fhir/ValueSet/australian-indigenous-status-1) | NCTS | Australian Digital Health Agency |
| [Australian States and Territories](https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1) | [Australian States and Territories](https://healthterminologies.gov.au/fhir/ValueSet/australian-states-territories-2) | NCTS | Australian Digital Health Agency |
| [BCP-13](http://tools.ietf.org/html/bcp13) | [Mime Types](https://hl7.org/fhir/R4/valueset-mimetypes.html) | Internet Assigned Numbers Authority | Internet Assigned Numbers Authority |
| [Communication Request Category](https://hl7.org.au/fhir/CodeSystem-communication-request-category.html) | [AU eRequesting CommunicationRequest Category](ValueSet-au-erequesting-communicationrequest-category.md) | AU Base | HL7 Australia |
| [Condition Category Codes](https://hl7.org/fhir/R4/codesystem-condition-category.html) | [Condition Category Codes](https://hl7.org/fhir/R4/valueset-condition-category.html) | FHIR | Health Level Seven International |
| [Condition Clinical Status Codes](https://hl7.org/fhir/R4/codesystem-condition-clinical.html) | [Condition Clinical Status Codes](https://hl7.org/fhir/R4/valueset-condition-clinical.html) | FHIR | Health Level Seven International |
| [ConditionVerificationStatus](https://hl7.org/fhir/R4/codesystem-condition-ver-status.html) | [ConditionVerificationStatus](https://hl7.org/fhir/R4/valueset-condition-ver-status.html) | FHIR | Health Level Seven International |
| [ContactPointSystem](http://hl7.org/fhir/contact-point-system) | [ContactPointSystem](http://hl7.org/fhir/ValueSet/contact-point-system) | FHIR | Health Level Seven International |
| [ContactPointUse](http://hl7.org/fhir/contact-point-use) | [ContactPointUse](http://hl7.org/fhir/ValueSet/contact-point-use) | FHIR | Health Level Seven International |
| [contactRole2](http://terminology.hl7.org/CodeSystem/v2-0131) | [Related Person Relationship Type](https://healthterminologies.gov.au/fhir/ValueSet/related-person-relationship-type-1) | HL7 Terminology (THO) | Health Level Seven International |
| [Coverage SelfPay Codes](http://terminology.hl7.org/CodeSystem/coverage-selfpay) | [AU eRequesting Coverage Type and Self-Pay Codes](ValueSet-au-erequesting-coverage-type.md),[Coverage Type and Self-Pay Codes - AU Extended](https://hl7.org.au/fhir/ValueSet-au-coverage-type-extended.html) | HL7 Terminology (THO) | Health Level Seven International |
| [DataAbsentReason](https://terminology.hl7.org/CodeSystem-data-absent-reason.html) | [Australian Pronouns](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/australian-pronouns-1),[Gender Identity Response](https://healthterminologies.gov.au/fhir/ValueSet/gender-identity-response-1),[Sex Parameter For Clinical Use](http://terminology.hl7.org/ValueSet/sex-parameter-for-clinical-use) | HL7 Terminology (THO) | Health Level Seven International |
| [DocumentReferenceStatus](https://hl7.org/fhir/R4/codesystem-document-reference-status.html) | [DocumentReferenceStatus](https://hl7.org/fhir/R4/valueset-document-reference-status.html) | FHIR | Health Level Seven International |
| [EncounterStatus](https://hl7.org/fhir/R4/codesystem-encounter-status.html) | [EncounterStatus](https://hl7.org/fhir/R4/valueset-encounter-status.html) | FHIR | Health Level Seven International |
| [EventStatus](https://hl7.org/fhir/R4/codesystem-event-status.html) | [EventStatus](https://hl7.org/fhir/R4/valueset-event-status.html) | FHIR | Health Level Seven International |
| [IdentifierType AU](https://hl7.org.au/fhir/CodeSystem-au-v2-0203.html) | [DVA Entitlement](https://hl7.org.au/fhir/ValueSet-dva-entitlement.html),[hl7VS-identifierType - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v2-0203-extended.html) | AU Base | HL7 Australia |
| [identifierType](http://terminology.hl7.org/CodeSystem/v2-0203) | [Order Identifier Type](https://hl7.org.au/fhir/ValueSet-order-identifier-type.html) | HL7 Terminology (THO) | Health Level Seven International |
| [IdentifierUse](https://hl7.org/fhir/R4/codesystem-identifier-use.html) | [IdentifierUse](https://hl7.org/fhir/R4/valueset-identifier-use.html) | FHIR | Health Level Seven International |
| [Location Type (Physical) AU](https://hl7.org.au/fhir/CodeSystem-au-location-physical-type.html) | [Location Type (Physical) - AU Extended](https://hl7.org.au/fhir/ValueSet-au-location-physical-type-extended.html) | AU Base | HL7 Australia |
| [LOINC](https://www.healthterminologies.gov.au/access-clinical-terminology/access-fhir-terminology-resources/code-systems/?ui:filter=loinc) | [Australian Pronouns](https://healthterminologies.gov.au/fhir/ValueSet/australian-pronouns-1),[Pregnancy Expected Delivery Date Method - IPS](https://hl7.org/fhir/uv/ips/STU2/ValueSet-edd-method-uv-ips.html) | NCTS | Regenstrief Institute, Inc |
| [NameUse](https://hl7.org/fhir/R4/codesystem-name-use.html) | [NameUse](https://hl7.org/fhir/R4/valueset-name-use.html) | FHIR | Health Level Seven International |
| [Participant type](https://hl7.org/fhir/R4/codesystem-encounter-participant-type.html) | [Participant type](https://hl7.org/fhir/R4/valueset-encounter-participant-type.html) | FHIR | Health Level Seven International |
| [ParticipationMode](https://terminology.hl7.org/CodeSystem-v3-ParticipationMode.html) | [AU eRequesting CommunicationRequest Patient Medium](ValueSet-au-erequesting-communicationrequest-patientmedium.md) | FHIR | HL7 Terminology (THO) |
| [ParticipationType](https://terminology.hl7.org/CodeSystem-v3-ParticipationType.html) | [Related Person Relationship Type](https://healthterminologies.gov.au/fhir/ValueSet/related-person-relationship-type-1) | FHIR | HL7 Terminology (THO) |
| [RequestStatus](https://hl7.org/fhir/R4/codesystem-request-status.html) | [AU eRequesting RequestStatus](ValueSet-au-erequesting-request-status.md),[RequestStatus](http://hl7.org/fhir/ValueSet/request-status) | FHIR | Health Level Seven International |
| [RequestPriority](https://hl7.org/fhir/R4/codesystem-request-priority.html) | [Request priority](https://hl7.org/fhir/R4/valueset-request-priority.html) | FHIR | Health Level Seven International |
| [Resource Tag](https://hl7.org.au/fhir/CodeSystem-resource-tag.html) | [AU eRequesting Fulfilment Task Tags](ValueSet-au-erequesting-fulfilment-task-tags.md) | AU Base | HL7 Australia |
| [RoleClass](http://terminology.hl7.org/CodeSystem/v3-RoleClass) | [Related Person Relationship Type](https://healthterminologies.gov.au/fhir/ValueSet/related-person-relationship-type-1) | HL7 Terminology (THO) | Health Level Seven International |
| [RoleCode](http://terminology.hl7.org/CodeSystem/v3-RoleCode) | [Related Person Relationship Type](https://healthterminologies.gov.au/fhir/ValueSet/related-person-relationship-type-1) | HL7 Terminology (THO) | Health Level Seven International |
| [Sex Parameter For Clinical Use](http://terminology.hl7.org/CodeSystem/sex-parameter-for-clinical-use) | [Sex Parameter For Clinical Use](http://terminology.hl7.org/ValueSet/sex-parameter-for-clinical-use) | HL7 Terminology (THO) | Health Level Seven International |
| [SNOMED Clinical Terms (Australian extension)](https://www.healthterminologies.gov.au/access-clinical-terminology/access-snomed-ct-au/) | [Body Site](https://healthterminologies.gov.au/fhir/ValueSet/body-site-1),[Clinical Specialty](https://healthterminologies.gov.au/fhir/ValueSet/clinical-specialty-1),[Condition/Diagnosis Severity](https://hl7.org/fhir/R4/valueset-condition-severity.html),[Gender Identity Response](https://healthterminologies.gov.au/fhir/ValueSet/gender-identity-response-1),[Healthcare Organisation Role Type](https://healthterminologies.gov.au/fhir/ValueSet/healthcare-organisation-role-type-1),[Pathology Fasting Status](https://healthterminologies.gov.au/fhir/ValueSet/pathology-fasting-status-1),[Practitioner Role](https://healthterminologies.gov.au/fhir/ValueSet/practitioner-role-1),[Pregnancy Status - IPS](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-pregnancy-status-uv-ips.html),[Procedure](https://healthterminologies.gov.au/fhir/ValueSet/procedure-1),[RANZCR Radiology Referral](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/ranzcr-radiology-referral-1),[Reason For Encounter](https://healthterminologies.gov.au/fhir/ValueSet/reason-for-encounter-1),[Reason for Request](https://healthterminologies.gov.au/fhir/ValueSet/reason-for-request-1),[Related Person Relationship Type](https://healthterminologies.gov.au/fhir/ValueSet/related-person-relationship-type-1),[Service Type](https://healthterminologies.gov.au/fhir/ValueSet/service-type-1) | NCTS | Australian Digital Health Agency |
| [Tags for the Identification of Languages](https://terminology.hl7.org/ECS_MR-v3-ietf3066.html) | [Common Languages in Australia](https://healthterminologies.gov.au/fhir/ValueSet/common-languages-australia-2) | HL7 Terminology (THO) | Internet Engineering Task Force |
| [Task Business Status](https://hl7.org.au/fhir/CodeSystem-task-business-status.html) | [AU eRequesting Task Business Status](ValueSet-au-erequesting-task-businessstatus.md) | AU Base | HL7 Australia |
| [TaskStatus](https://hl7.org/fhir/R4/codesystem-task-status.html) | [AU eRequesting Task Status](ValueSet-au-erequesting-task-status.md) | FHIR | Health Level Seven International |

