# hl7.fhir.au.ereq#1.0.0: AU eRequesting Implementation Guide

## Pages

* [Home](index.md)
* [AU eRequesting Workflow Guidance](workflow.md)
* [](ActorDefinition-au-erequesting-actor-patient.change.history.md)
* [](ActorDefinition-au-erequesting-actor-server.change.history.md)
* [Security and Privacy](security.md)
* [AU eRequesting Patient - JSON Representation](ActorDefinition-au-erequesting-actor-patient.json.md)
* [Guidance](guidance.md)
* [Profiles and Extensions](profiles-and-extensions.md)
* [AU Variance Statement](variance.md)
* [AU eRequesting Filler - JSON Representation](ActorDefinition-au-erequesting-actor-filler.json.md)
* [AU eRequesting Filler - TTL Representation](ActorDefinition-au-erequesting-actor-filler.ttl.md)
* [Support](support.md)
* [AU eRequesting Placer - XML Representation](ActorDefinition-au-erequesting-actor-placer.xml.md)
* [Future of AU eRequesting](future.md)
* [AU eRequesting Server - Testing](ActorDefinition-au-erequesting-actor-server-testing.md)
* [AU eRequesting Placer - Testing](ActorDefinition-au-erequesting-actor-placer-testing.md)
* [Downloads](downloads.md)
* [AU eRequesting Patient - TTL Representation](ActorDefinition-au-erequesting-actor-patient.ttl.md)
* [AU eRequesting Filler - XML Representation](ActorDefinition-au-erequesting-actor-filler.xml.md)
* [AU eRequesting Patient - Testing](ActorDefinition-au-erequesting-actor-patient-testing.md)
* [Conformance](conformance.md)
* [AU eRequesting Filler](ActorDefinition-au-erequesting-actor-filler.md)
* [](ActorDefinition-au-erequesting-actor-placer.change.history.md)
* [AU eRequesting Patient - XML Representation](ActorDefinition-au-erequesting-actor-patient.xml.md)
* [AU eRequesting Data for Interoperability Mappings](auereqdi.md)
* [AU eRequesting Patient](ActorDefinition-au-erequesting-actor-patient.md)
* [License and Legal](license.md)
* [Change Log](changes.md)
* [Terminology](terminology.md)
* [Artefacts Summary](artifacts.md)
* [Use Cases](use-cases.md)
* [AU eRequesting Server](ActorDefinition-au-erequesting-actor-server.md)
* [Examples](examples.md)
* [AU eRequesting Placer - TTL Representation](ActorDefinition-au-erequesting-actor-placer.ttl.md)
* [](ActorDefinition-au-erequesting-actor-filler.change.history.md)
* [AU eRequesting Placer - JSON Representation](ActorDefinition-au-erequesting-actor-placer.json.md)
* [AU eRequesting Server - TTL Representation](ActorDefinition-au-erequesting-actor-server.ttl.md)
* [Actors and Capabilities](capability-statements.md)
* [FHIR Artefacts](fhirartifacts.md)
* [Sex and Gender](sex-and-gender.md)
* [Relationships to Other Specifications](relationship.md)
* [General Guidance](general-guidance.md)
* [AU eRequesting Filler - Testing](ActorDefinition-au-erequesting-actor-filler-testing.md)
* [AU eRequesting Server - JSON Representation](ActorDefinition-au-erequesting-actor-server.json.md)
* [AU eRequesting Placer](ActorDefinition-au-erequesting-actor-placer.md)
* [AU eRequesting Server - XML Representation](ActorDefinition-au-erequesting-actor-server.xml.md)

## Resources

### ValueSets

* [AU eRequesting CommunicationRequest Category](ValueSet-au-erequesting-communicationrequest-category.md)
* [AU eRequesting CommunicationRequest Patient Medium](ValueSet-au-erequesting-communicationrequest-patientmedium.md)
* [AU eRequesting Coverage Type and Self-Pay Codes](ValueSet-au-erequesting-coverage-type.md)
* [AU eRequesting Fulfilment Task Tags](ValueSet-au-erequesting-fulfilment-task-tags.md)
* [AU eRequesting RequestStatus](ValueSet-au-erequesting-request-status.md)
* [AU eRequesting Task Business Status](ValueSet-au-erequesting-task-businessstatus.md)
* [AU eRequesting Task Status](ValueSet-au-erequesting-task-status.md)

### Resource Profiles

* [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md)
* [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md)
* [AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md)
* [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md)
* [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md)
* [AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md)
* [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)
* [AU eRequesting Encounter](StructureDefinition-au-erequesting-encounter.md)
* [AU eRequesting MHR Consent Withdrawal](StructureDefinition-au-erequesting-mhrconsentwithdrawal.md)
* [AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md)
* [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md)
* [AU eRequesting Practitioner](StructureDefinition-au-erequesting-practitioner.md)
* [AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md)
* [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md)
* [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md)
* [AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md)
* [AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md)
* [AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md)
* [AU eRequesting Task](StructureDefinition-au-erequesting-task.md)

### Extensions

* [AU eRequesting Display Sequence](StructureDefinition-au-erequesting-displaysequence.md)
* [AU eRequesting Fasting Precondition](StructureDefinition-au-erequesting-fastingprecondition.md)

### Basics

* [au-erequesting-actor-filler](Basic-au-erequesting-actor-filler.md)
* [au-erequesting-actor-patient](Basic-au-erequesting-actor-patient.md)
* [au-erequesting-actor-placer](Basic-au-erequesting-actor-placer.md)
* [au-erequesting-actor-server](Basic-au-erequesting-actor-server.md)

### CapabilityStatements

* [AU eRequesting Filler CapabilityStatement](CapabilityStatement-au-erequesting-filler.md)
* [AU eRequesting Patient CapabilityStatement](CapabilityStatement-au-erequesting-patient.md)
* [AU eRequesting Placer CapabilityStatement](CapabilityStatement-au-erequesting-placer.md)
* [AU eRequesting Server CapabilityStatement](CapabilityStatement-au-erequesting-server.md)

### ImplementationGuides

* [AU eRequesting Implementation Guide](index.md)

### Examples

* [communicationrequest-copyto-gp (CommunicationRequest)](CommunicationRequest-communicationrequest-copyto-gp.md)
* [communicationrequest-donotperform (CommunicationRequest)](CommunicationRequest-communicationrequest-donotperform.md)
* [communicationrequest-patient-instruction (CommunicationRequest)](CommunicationRequest-communicationrequest-patient-instruction.md)
* [communicationrequest-urgent-results-to-provider (CommunicationRequest)](CommunicationRequest-communicationrequest-urgent-results-to-provider.md)
* [mhr-consent-withdrawal (Consent)](Consent-mhr-consent-withdrawal.md)
* [coverage-concession (Coverage)](Coverage-coverage-concession.md)
* [coverage-dva (Coverage)](Coverage-coverage-dva.md)
* [documentreference-clinical-context (DocumentReference)](DocumentReference-documentreference-clinical-context.md)
* [gp-consult-finger-pain (Encounter)](Encounter-gp-consult-finger-pain.md)
* [gp-consultation (Encounter)](Encounter-gp-consultation.md)
* [obsgynaeclinic (Encounter)](Encounter-obsgynaeclinic.md)
* [Barney View Private Hospital (Location)](Location-barney-view-private-hospital.md)
* [observation-pregnancy-status (Observation)](Observation-observation-pregnancy-status.md)
* [Barney View Private Hospital (Organization)](Organization-barney-view-private-hospital.md)
* [Elimbah Medical Centre (Organization)](Organization-elimbah-medical-centre.md)
* [Kioma Pathology (Organization)](Organization-kioma-pathology.md)
* [Mount Charlton Radiology (Organization)](Organization-mount-charlton-radiology.md)
* [belger-remedios (Patient)](Patient-belger-remedios.md)
* [roberts-fred (Patient)](Patient-roberts-fred.md)
* [scott-elijah-ken (Patient)](Patient-scott-elijah-ken.md)
* [herbert-aimee (Practitioner)](Practitioner-herbert-aimee.md)
* [losch-sallie (Practitioner)](Practitioner-losch-sallie.md)
* [mclaughlin-kimberlee (Practitioner)](Practitioner-mclaughlin-kimberlee.md)
* [practitioner-guthridge-jarred (Practitioner)](Practitioner-practitioner-guthridge-jarred.md)
* [diagnostic-mclaughlin-kimberlee (PractitionerRole)](PractitionerRole-diagnostic-mclaughlin-kimberlee.md)
* [generalpractitioner-guthridge-jarred (PractitionerRole)](PractitionerRole-generalpractitioner-guthridge-jarred.md)
* [obstetrician-losch-sallie (PractitionerRole)](PractitionerRole-obstetrician-losch-sallie.md)
* [pathologist-herbert-aimee (PractitionerRole)](PractitionerRole-pathologist-herbert-aimee.md)
* [order-bg-abs (ServiceRequest)](ServiceRequest-order-bg-abs.md)
* [order-fbc-1 (ServiceRequest)](ServiceRequest-order-fbc-1.md)
* [order-glu-1 (ServiceRequest)](ServiceRequest-order-glu-1.md)
* [order-ironstudies (ServiceRequest)](ServiceRequest-order-ironstudies.md)
* [order-obsus-1 (ServiceRequest)](ServiceRequest-order-obsus-1.md)
* [order-urinemcs-1 (ServiceRequest)](ServiceRequest-order-urinemcs-1.md)
* [order-xray-1 (ServiceRequest)](ServiceRequest-order-xray-1.md)
* [order-xray-2 (ServiceRequest)](ServiceRequest-order-xray-2.md)
* [task-communicationrequest-urgent-results-to-provider (Task)](Task-task-communicationrequest-urgent-results-to-provider.md)
* [taskfulfilment-imaging-1 (Task)](Task-taskfulfilment-imaging-1.md)
* [taskfulfilment-pathology-1 (Task)](Task-taskfulfilment-pathology-1.md)
* [taskgroup-imaging-1 (Task)](Task-taskgroup-imaging-1.md)
* [taskgroup-pathology-1 (Task)](Task-taskgroup-pathology-1.md)
