# AU eRequesting Encounter - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU eRequesting Encounter**

## Resource Profile: AU eRequesting Encounter 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-encounter | *Version*:1.0.0 | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://build.fhir.org/ig/hl7au/au-fhir-base/generalguidance.html#maturity-levels): 1 | *Computable Name*:AUeRequestingEncounter |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile sets minimum expectations for an Encounter resource that is used to record, search, and fetch basic encounter information for a patient. It is based on the [AU Core Encounter](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-encounter.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the Encounter resource when conforming to this profile. 

### Profile Specific Implementation Guidance

* See the general guidance on implementing the Encounter resource in [AU Core Encounter](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-encounter.html#profile-specific-implementation-guidance).

Obligations for AU Core actors ([AU Core Requester](https://hl7.org.au/fhir/core/2.0.0/ActorDefinition-au-core-actor-requester.html) and [AU Core Responder](https://hl7.org.au/fhir/core/2.0.0/ActorDefinition-au-core-actor-responder.html)) inherited from [AU Core Encounter](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-encounter.html) currently render in the profile view. This is a tooling limitation, and only the AU eRequesting actor obligations should be applied. See [Zulip discussion](https://chat.fhir.org/#narrow/channel/215610-shorthand/topic/Sushi.20merging.20profile.20extension.20with.20parent.20content/with/545567478) for more information.

**Usages:**

* Refer to this Profile: [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)
* Examples for this Profile: [Encounter/gp-consult-finger-pain](Encounter-gp-consult-finger-pain.md), [Encounter/gp-consultation](Encounter-gp-consultation.md) and [Encounter/obsgynaeclinic](Encounter-obsgynaeclinic.md)
* CapabilityStatements using this Profile: [AU eRequesting Filler CapabilityStatement](CapabilityStatement-au-erequesting-filler.md), [AU eRequesting Patient CapabilityStatement](CapabilityStatement-au-erequesting-patient.md), [AU eRequesting Placer CapabilityStatement](CapabilityStatement-au-erequesting-placer.md) and [AU eRequesting Server CapabilityStatement](CapabilityStatement-au-erequesting-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.ereq|current/StructureDefinition/au-erequesting-encounter)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-erequesting-encounter.csv), [Excel](StructureDefinition-au-erequesting-encounter.xlsx), [Schematron](StructureDefinition-au-erequesting-encounter.sch) 

### Notes:

Below is an overview of the mandatory and optional search parameters and combined search parameters. See the [AU eRequesting CapabilityStatements](capability-statements.md) for a complete list of supported RESTful interactions for this IG.

FHIR search operations are described [here](http://hl7.org/fhir/R4/search.html) and the syntax used to describe AU eRequesting interactions is defined [here](https://hl7.org.au/fhir/core/2.0.0/general-guidance.html#readsearch-syntax).

Any search parameter defined in FHIR may be 'allowed' by the system unless explicitly marked as "**SHALL NOT**".

* Parameter(s): _id
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 

#### Search Parameters:

The following search parameters and search parameter combinations are supported. Conformance obligations are detailed in the table above.

1. **[`_id`](https://hl7.org/fhir/R4/encounter.html#search)** search parameter`GET [base]/Encounter?_id=[id]`Example:
1. GET [base]/Encounter?_id=987654

**Implementation Notes:** Fetches a bundle with the requested Encounter, instead of just the resource itself, and allows for the inclusion of additional search parameters such as _include, _revinclude, or _lastUpdated ([how to search by id of the resource](https://hl7.org/fhir/r4/search.html#id))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-erequesting-encounter",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ereq/ImplementationGuide/hl7.fhir.au.ereq"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-encounter",
  "version" : "1.0.0",
  "name" : "AUeRequestingEncounter",
  "title" : "AU eRequesting Encounter",
  "status" : "active",
  "date" : "2026-02-11T06:15:07+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG"
        }
      ]
    },
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for an Encounter resource that is used to record, search, and fetch basic encounter information for a patient. It is based on the [AU Core Encounter](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-encounter.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the Encounter resource when conforming to this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter"
      },
      {
        "id" : "Encounter.status",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.status"
      },
      {
        "id" : "Encounter.class",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.class"
      },
      {
        "id" : "Encounter.serviceType",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.serviceType"
      },
      {
        "id" : "Encounter.subject",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-patient"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.participant",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.participant"
      },
      {
        "id" : "Encounter.participant.type",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.participant.type"
      },
      {
        "id" : "Encounter.participant.individual",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.participant.individual",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-practitioner",
              "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-practitionerrole",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-relatedperson"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.period",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.period"
      },
      {
        "id" : "Encounter.reasonCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.reasonCode"
      },
      {
        "id" : "Encounter.reasonReference",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.reasonReference"
      },
      {
        "id" : "Encounter.location",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.location"
      },
      {
        "id" : "Encounter.location.location",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.location.location"
      },
      {
        "id" : "Encounter.serviceProvider",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter|2.0.0"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.serviceProvider",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-organization"
            ]
          }
        ]
      }
    ]
  }
}

```
