# AU eRequesting Coverage - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU eRequesting Coverage**

## Resource Profile: AU eRequesting Coverage 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-coverage | *Version*:1.0.0 | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://build.fhir.org/ig/hl7au/au-fhir-base/generalguidance.html#maturity-levels): 1 | *Computable Name*:AUeRequestingCoverage |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile sets minimum expectations for a Coverage resource that is used to record, search, and fetch information about insurance or medical plan or a payment agreement for a patient. It is based on the [AU Base Coverage](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-coverage.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the Coverage when conforming to this profile. 

### Profile Specific Implementation Guidance

* See guidance on the construction of identifiers in each Identifier profile and the section on [Business Identifiers](https://hl7.org.au/fhir/6.0.0/generalguidance.html#business-identifiers) in AU Base.
* See guidance on populating `Coverage.type` in [AU Base Coverage Profile Specific Implementation Guidance](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-coverage.html#usage-notes).
* When using one of the below Coverage types, at least one of the corresponding identifiers **SHOULD** be populated:

| | | |
| :--- | :--- | :--- |
| Medicare | PUBLICPOL | [AU Medicare Card Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-medicarecardnumber.html) |
| Department of Veterans Affairs (DVA) | VET | [AU DVA Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-dvanumber.html) |
| Concession | payconc | [AU Pensioner Concession Card Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-pensionerconcessioncardnumber.html),[AU Commonwealth Seniors Health Card Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-cwlthseniorshealthcardnumber.html),[AU Health Care Card Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-healthcarecardnumber.html) |
| Private health insurance | HIP | [AU Insurance Member Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-insurancemembernumber.html) |
| Private (self funded) | pay | N/A |

**Usages:**

* Refer to this Profile: [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)
* Examples for this Profile: [Coverage/coverage-concession](Coverage-coverage-concession.md) and [Coverage/coverage-dva](Coverage-coverage-dva.md)
* CapabilityStatements using this Profile: [AU eRequesting Filler CapabilityStatement](CapabilityStatement-au-erequesting-filler.md), [AU eRequesting Patient CapabilityStatement](CapabilityStatement-au-erequesting-patient.md), [AU eRequesting Placer CapabilityStatement](CapabilityStatement-au-erequesting-placer.md) and [AU eRequesting Server CapabilityStatement](CapabilityStatement-au-erequesting-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.ereq|current/StructureDefinition/au-erequesting-coverage)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-erequesting-coverage.csv), [Excel](StructureDefinition-au-erequesting-coverage.xlsx), [Schematron](StructureDefinition-au-erequesting-coverage.sch) 

### Notes:

Below is an overview of the mandatory and optional search parameters and combined search parameters. See the [AU eRequesting CapabilityStatements](capability-statements.md) for a complete list of supported RESTful interactions for this IG.

FHIR search operations are described [here](http://hl7.org/fhir/R4/search.html) and the syntax used to describe AU eRequesting interactions is defined [here](https://hl7.org.au/fhir/core/2.0.0/general-guidance.html#readsearch-syntax).

Any search parameter defined in FHIR may be 'allowed' by the system unless explicitly marked as "**SHALL NOT**".

* Parameter(s): _id
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 

#### Search Parameters:

The following search parameters and search parameter combinations are supported. Conformance obligations are detailed in the table above.

1. **[`_id`](https://hl7.org/fhir/R4/coverage.html#search)** search parameter`GET [base]/Coverage?_id=[id]`Example:
1. GET [base]/Coverage?_id=10045786

**Implementation Notes:** Fetches a bundle with the requested Coverage, instead of just the resource itself, and allows for the inclusion of additional search parameters such as _include, _revinclude, or _lastUpdated ([how to search by id of the resource](https://hl7.org/fhir/r4/search.html#id))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-erequesting-coverage",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ereq/ImplementationGuide/hl7.fhir.au.ereq"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-coverage",
  "version" : "1.0.0",
  "name" : "AUeRequestingCoverage",
  "title" : "AU eRequesting Coverage",
  "status" : "active",
  "date" : "2026-02-11T06:15:07+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG"
        }
      ]
    },
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for a Coverage resource that is used to record, search, and fetch information about insurance or medical plan or a payment agreement for a patient. It is based on the [AU Base Coverage](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-coverage.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the Coverage when conforming to this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cdanetv4",
      "uri" : "http://www.cda-adc.ca/en/services/cdanet/",
      "name" : "Canadian Dental Association eclaims standard"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "cpha3pharm",
      "uri" : "http://www.pharmacists.ca/",
      "name" : "Canadian Pharmacy Associaiton eclaims standard"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Coverage",
  "baseDefinition" : "http://hl7.org.au/fhir/StructureDefinition/au-coverage",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Coverage",
        "path" : "Coverage"
      },
      {
        "id" : "Coverage.identifier",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Coverage.identifier",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.status",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Coverage.status",
        "short" : "Status of the coverage",
        "fixedCode" : "active",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.type",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Coverage.type",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "adb-cov-type-min"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "minimum"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://terminology.hl7.org.au/ValueSet/au-erequesting-coverage-type"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "The minimum set of codes that any conformant system SHALL support."
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org.au/ValueSet/au-coverage-type-extended"
        }
      },
      {
        "id" : "Coverage.beneficiary",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Coverage.beneficiary",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Coverage.payor",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Coverage.payor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-patient",
              "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-organization",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-relatedperson"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
