# Patient - Fred Roberts - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Patient - Fred Roberts**

## Example Patient: Patient - Fred Roberts

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md)

Fred Roberts Male, DoB: 1961-06-16 ( IHI: Austalian Healthcare Identifier - Individual#8003608500314661)

-------

| | |
| :--- | :--- |
| Contact Detail | * ph: 0491570158(Mobile)
* ph: 0770109298(Home)
* [fred.roberts@myownpersonaldomain.com](mailto:fred.roberts@myownpersonaldomain.com)
* 33 Southern Cl Westbrook QLD 4350 AU 
 |
| [Australian Indigenous Status](http://hl7.org.au/fhir/6.0.0/StructureDefinition-indigenous-status.html) | australian-indigenous-status-1: 4 (Neither Aboriginal nor Torres Strait Islander origin) |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "roberts-fred",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-patient"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/StructureDefinition/indigenous-status",
      "valueCoding" : {
        "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1",
        "code" : "4",
        "display" : "Neither Aboriginal nor Torres Strait Islander origin"
      }
    }
  ],
  "identifier" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-status",
          "valueCoding" : {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-status-1",
            "code" : "active"
          }
        },
        {
          "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-record-status",
          "valueCoding" : {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-record-status-1",
            "code" : "verified",
            "display" : "verified"
          }
        },
        {
          "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-verified-date",
          "valueDateTime" : "2024-02-13"
        }
      ],
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NI"
          }
        ],
        "text" : "IHI"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/ihi/1.0",
      "value" : "8003608500314661"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Roberts",
      "given" : ["Fred"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0491570158",
      "use" : "mobile"
    },
    {
      "system" : "phone",
      "value" : "0770109298",
      "use" : "home"
    },
    {
      "system" : "email",
      "value" : "fred.roberts@myownpersonaldomain.com"
    }
  ],
  "gender" : "male",
  "birthDate" : "1961-06-16",
  "address" : [
    {
      "line" : ["33 Southern Cl"],
      "city" : "Westbrook",
      "state" : "QLD",
      "postalCode" : "4350",
      "country" : "AU"
    }
  ]
}

```
