# Organization - Kioma Pathology Laboratory - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Organization - Kioma Pathology Laboratory**

## Example Organization: Organization - Kioma Pathology Laboratory

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md)

**identifier**: HPI-O/8003621566705995

**type**: Pathology laboratory

**name**: Kioma Pathology

**telecom**: [info@kiomapathology.example.net](mailto:info@kiomapathology.example.net), ph: (07) 5550 5000(Work)

**address**: 15 Hazlett Est Kioma QLD 4498 AU (work)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "kioma-pathology",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-organization"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "NOI",
            "display" : "National Organisation Identifier"
          }
        ],
        "text" : "HPI-O"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/hpio/1.0",
      "value" : "8003621566705995"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://www.abs.gov.au/ausstats/abs@.nsf/mf/1292.0",
          "code" : "8520",
          "display" : "Pathology and Diagnostic Imaging Services"
        }
      ],
      "text" : "Pathology laboratory"
    }
  ],
  "name" : "Kioma Pathology",
  "telecom" : [
    {
      "system" : "email",
      "value" : "info@kiomapathology.example.net",
      "use" : "work"
    },
    {
      "system" : "phone",
      "value" : "(07) 5550 5000",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "use" : "work",
      "type" : "physical",
      "line" : ["15 Hazlett Est"],
      "city" : "Kioma",
      "state" : "QLD",
      "postalCode" : "4498",
      "country" : "AU"
    }
  ]
}

```
