# Encounter - Finger Pain Consultation - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Encounter - Finger Pain Consultation**

## Example Encounter: Encounter - Finger Pain Consultation

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Encounter](StructureDefinition-au-erequesting-encounter.md)

**status**: Finished

**class**: [ActCode: AMB](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-AMB) (ambulatory)

**serviceType**: General practice service

**subject**: [Elijah KEN SCOTT (official) Male, DoB: 1986-11-28 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647204)](Patient-scott-elijah-ken.md)

### Participants

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Individual** |
| * | primary performer | [PractitionerRole General practitioner](PractitionerRole-generalpractitioner-guthridge-jarred.md) |

**period**: 2024-05-12 10:15:00+1000 --> 2024-05-12 10:30:00+1000

**reasonCode**: Finger pain

**serviceProvider**: [Organization Elimbah Medical Centre](Organization-elimbah-medical-centre.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "gp-consult-finger-pain",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-encounter"
    ]
  },
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB",
    "display" : "ambulatory"
  },
  "serviceType" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "788007007",
        "display" : "General practice service"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/scott-elijah-ken"
  },
  "participant" : [
    {
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "PPRF",
              "display" : "primary performer"
            }
          ]
        }
      ],
      "individual" : {
        "reference" : "PractitionerRole/generalpractitioner-guthridge-jarred"
      }
    }
  ],
  "period" : {
    "start" : "2024-05-12T10:15:00+10:00",
    "end" : "2024-05-12T10:30:00+10:00"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "18876004",
          "display" : "Finger pain"
        }
      ]
    }
  ],
  "serviceProvider" : {
    "reference" : "Organization/elimbah-medical-centre"
  }
}

```
