# AU eRequesting Data for Interoperability Mappings - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Guidance**](guidance.md)
* **AU eRequesting Data for Interoperability Mappings**

## AU eRequesting Data for Interoperability Mappings

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

[Australian eRequesting Data for Interoperability (AUeReqDI)](https://sparked.csiro.au/index.php/products-resources/auereqdi/) is the product of a national clinician focused requirements gathering project operating as part of the [Sparked AU FHIR Accelerator](https://sparked.csiro.au/). AUeReqDI outputs form a set of data requirements to be considered and referred to as part of the development and definition of AU eRequesting.

The primary intent of AUeReqDI is to design and govern a collection of coherent, reusable building blocks known as ‘data groups’. These data groups define what clinical information is required to support eRequests. However, they do not specify how the data is exchanged; this is the role of the FHIR standard. AUeReqDI is not required to be implemented as a whole single product. AUeReqDI builds upon and complements the foundational [Australian Clinical Data for Interoperability (AUCDI)](https://sparked.csiro.au/index.php/products-resources/aucdi/) and focuses on the specific use case of eRequesting.

AUeReqDI Release 1 (R1) is focused on an agreement of the minimum data required to support standardised eRequesting within the Australian health context, and forms a common language foundation that allows systems to exchange semantically accurate data for eRequests. It incorporates and builds upon prior work from national and international programs and initiatives, including the Royal College of Pathologists of Australasia (RCPA)'s Pathology information, Terminology and Units Standardisation (PITUS) framework and the Royal Australian New Zealand College of Radiology (RANZCR's) Radiology Referral Set.

AU eRequesting is intended to provide an implementable standard for FHIR based interfaces for diagnostic requesting in Australia, providing:

* an exchange standard for AUeReqDI (the underpinning clinical data model)
* data model and RESTful API interactions that set minimum expectations for a system to create, update, search, and retrieve electronic diagnostic requests
* a foundation focused on pathology and medical imaging requests in community-based care provision, with consideration for future eRequesting use cases beyond this scope

With AUeReqDI defining clinical data requirements and FHIR AU eRequesting providing the Implementation Guide for FHIR-based electronic requesting of diagnostic imaging and pathology services, an interpretation of AUeReqDI is necessary which is undertaken through the community.

### AU eRequesting, AUeReqDI and AUCDI Versions

AU eRequesting, AUeReqDI and AUCDI are updated periodically. AUeReqDI R1 contains data groups required to facilitate the exchange of a pathology test and medical imaging request, and reuses data groups from AUCDI where relevant.

AUeReqDI R1 is aligned with AUCDI R1.

AUCDI R2 was published after AUeReqDI R1, introducing additional and expanded data groups to support different use cases. These are not reflected in AUeReqDI R1.

The following table shows the version alignment between AU eRequesting, AUeReqDI and AUCDI:

* AU eRequesting Version: 1.0.0
  * AUeReqDI Version: R1
  * AUCDI Version: R1

### AUeReqDI Mappings Into AU eRequesting

The table below shows the relationship between AUeReqDI and AUCDI Data Groups and Elements and AU eRequesting and AU Core profiles.
 Column attribute descriptions are as follows:

* **AUeReqDI/AUCDI Data Group**: Represents a grouping of one or more AUeReqDI or AUCDI Data Elements.
* **AUeReqDI/AUCDI Data Element**: Represents a single, discrete clinical concept defined by AUeReqDI or AUCDI.
* **AU eRequesting Profile(s)/AU Core Profile(s)**: Represents the mapping of AUeReqDI or AUCDI Data Groups and Data Elements to AU eRequesting or AU Core FHIR artefacts.
* **FHIR Path**: The specific path in the FHIR standards for each AUeReqDI or AUCDI Data Element within, showing where and how to implement these elements in FHIR-based systems.
* **Comment**: Additional information about the mapping including an explanation of where an element or group is not yet mapped.

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Service request | Service name | [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) | `ServiceRequest.code` |  |
| Clinical indication | [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) | `ServiceRequest.reasonCode` |  | |
| Clinical context | [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) | `ServiceRequest.supportingInfo:clinicalContext` |  | |
| Urgency | [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) | `ServiceRequest.priority` |  | |
| Service timing | [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) | `ServiceRequest.occurrence[x]` | This element is choice between occurrenceTiming | occurrenceDateTime | occurrencePeriod. | |
| Comment | [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) | `ServiceRequest.note` |  | |
| Distribution list | [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md) | `CommunicationRequest.recipient` |  | |
| Urgent contact | [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md) | `CommunicationRequest.recipient` |  | |
| Billing guidance | [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)[AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md) | `ServiceRequest.insurance``Coverage` | `ServiceRequest.insurance`references a Coverage resource. | |
| Medical imaging request | Test name | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | `ServiceRequest.code` |  |
| Modality | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | `ServiceRequest.code` |  | |
| Target body site | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | `ServiceRequest.code`|`ServiceRequest.bodySite` |  | |
| Contrast use | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | `ServiceRequest.code` |  | |
| Clinical indication | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | `ServiceRequest.reasonCode` |  | |
| Clinical context | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | `ServiceRequest.supportingInfo:clinicalContext` |  | |
| Urgency | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | `ServiceRequest.priority` |  | |
| Service timing | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | `ServiceRequest.occurrence[x]` | This element is choice between occurrenceTiming | occurrenceDateTime | occurrencePeriod. | |
| Comment | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | `ServiceRequest.note` |  | |
| Distribution list | [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md) | `CommunicationRequest.recipient` |  | |
| Urgent contact | [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md) | `CommunicationRequest.recipient` |  | |
| Billing guidance | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md)[AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md) | `ServiceRequest.insurance``Coverage` | `ServiceRequest.insurance`references a Coverage resource. | |
| Pathology test request | Test name | [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | `ServiceRequest.code` |  |
| Fasting status | [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | `ServiceRequest.extension:fastingPrecondition` |  | |
| Clinical indication | [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | `ServiceRequest.reasonCode` |  | |
| Clinical context | [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | `ServiceRequest.supportingInfo.clinicalContext` |  | |
| Urgency | [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | `ServiceRequest.priority` |  | |
| Service timing | [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | `ServiceRequest.occurrence[x]` | This element is choice between occurrenceTiming | occurrenceDateTime | occurrencePeriod. | |
| Comment | [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | `ServiceRequest.note` |  | |
| Distribution list | [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md) | `CommunicationRequest.recipient` |  | |
| Urgent contact | [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md) | `CommunicationRequest.recipient` |  | |
| Billing guidance | [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md)[AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md) | `ServiceRequest.insurance``Coverage` | `ServiceRequest.insurance`references a Coverage resource. | |
| Implanted medical device summary | Device type name | Device | `Device.type` | This AUeReqDI Data Group is a[Future Candidate Requirement Under Consideration](future.md#future-candidate-requirements-under-consideration). Future versions of AU eRequesting will develop and test approaches to addressing Implanted medical device summary. |
| Current status | Device | `Device.status` | | |
| Overall comment | Device | `Device.note` | | |
| Last updated | - | - | | |
| Pregnancy summary (AUCDI R3+ backlog) | TBD | [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) | `ServiceRequest.supportingInfo:pregnancyStatus` | Proposed to correspond to a future AUCDI pregnancy summary concept (in the AUCDI R3+ backlog), which is expected to describe pregnancy status within a single pregnancy and potentially include more granular states to encompass a continuum of pregnancy states. In AU eRequesting R1, the pregnancy status is constrained to Pregnant only, as advised by AUCDI authors, to ensure future compatibility. |
| Adverse reaction risk summary | Substance name | [AU Core AllergyIntolerance](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-allergyintolerance.html) | `AllergyIntolerance.code` | This AUCDI Data Group is a[Future Candidate Requirement Under Consideration](future.md#future-candidate-requirements-under-consideration). Future versions of AU eRequesting will develop and test approaches to addressing Adverse reaction risk summary. |
| Manifestation | [AU Core AllergyIntolerance](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-allergyintolerance.html) | `AllergyInterolance.reaction` | | |
| Comment | [AU Core AllergyIntolerance](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-allergyintolerance.html) | `AllergyIntolerance.note` | | |
| Last updated | - | - | | |
| Problem/Diagnosis summary | Problem / Diagnosis name | [AU Core Condition](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-condition.html) | `Condition.code` | This AUCDI Data Group is a[Future Candidate Requirement Under Consideration](future.md#future-candidate-requirements-under-consideration). Future versions of AU eRequesting will develop and test approaches to addressing Problem/Diagnosis summary. |
| Body site/laterality | [AU Core Condition](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-condition.html) | `Condition.code` | | |
| Status | [AU Core Condition](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-condition.html) | `Condition.clinicalStatus` | | |
| Comment | [AU Core Condition](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-condition.html) | `Condition.note` | | |
| Last updated | - | - | | |
| Sex and gender summary | Sex assigned at birth | [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md) | `Patient.extension.where(url='http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender')` | The[Person Recorded Sex or Gender extension](http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender)is profiled by[AU Core Sex Assigned At Birth (RSG)](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-rsg-sexassignedab.html)to represent the concept of Sex assigned at birth. |
| Gender identity | [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md) | `Patient.extension.where(url='http://hl7.org/fhir/StructureDefinition/individual-genderIdentity')` |  | |
| Pronoun/s | [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md) | `Patient.extension.where(url='http://hl7.org/fhir/StructureDefinition/individual-pronouns')` |  | |
| Last updated | - | - | This AUCDI element is a[Future Candidate Requirement Under Consideration](https://hl7.org.au/fhir/core/2.0.0/future.html#future-candidate-requirements-under-consideration)in AU Core. Future versions of AU Core will develop and test approaches to addressing Last Updated. | |

