# ServiceRequest - Hand X-ray (with coded body site) - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **ServiceRequest - Hand X-ray (with coded body site)**

## Example ServiceRequest: ServiceRequest - Hand X-ray (with coded body site)

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md)

**AU eRequesting Display Sequence**: 1

**identifier**: Placer Identifier/EMC4543344-1620-01

**requisition**: Placer Group Number/EMC4543344-1620

**status**: Active

**intent**: Order

**category**: Imaging

**code**: X-ray of left hand

**subject**: [Elijah KEN SCOTT (official) Male, DoB: 1986-11-28 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647204)](Patient-scott-elijah-ken.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); serviceType = General practice service; period = 2024-05-12 10:15:00+1000 --> 2024-05-12 10:30:00+1000; reasonCode = Finger pain](Encounter-gp-consult-finger-pain.md)

**authoredOn**: 2024-05-12

**requester**: [PractitionerRole General practitioner](PractitionerRole-generalpractitioner-guthridge-jarred.md)

**insurance**: [Coverage: identifier = DVA Number: QX521750; status = active; type = veteran health program](Coverage-coverage-dva.md)

**bodySite**: Left ring finger



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "order-xray-2",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-imag"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-displaysequence",
      "valueInteger" : 1
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PLAC",
            "display" : "Placer Identifier"
          }
        ]
      },
      "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
      "value" : "EMC4543344-1620-01",
      "assigner" : {
        "display" : "Elimbah Medical Centre"
      }
    }
  ],
  "requisition" : {
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "code" : "PGN",
          "display" : "Placer Group Number"
        }
      ]
    },
    "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
    "value" : "EMC4543344-1620",
    "assigner" : {
      "display" : "Elimbah Medical Centre"
    }
  },
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "363679005",
          "display" : "Imaging"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "3621000087107",
        "display" : "Plain X-ray of left hand"
      }
    ],
    "text" : "X-ray of left hand"
  },
  "subject" : {
    "reference" : "Patient/scott-elijah-ken"
  },
  "encounter" : {
    "reference" : "Encounter/gp-consult-finger-pain"
  },
  "authoredOn" : "2024-05-12",
  "requester" : {
    "reference" : "PractitionerRole/generalpractitioner-guthridge-jarred"
  },
  "insurance" : [
    {
      "reference" : "Coverage/coverage-dva"
    }
  ],
  "bodySite" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "770882009",
          "display" : "Structure of left ring finger"
        }
      ],
      "text" : "Left ring finger"
    }
  ]
}

```
