# ServiceRequest - Iron studies - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **ServiceRequest - Iron studies**

## Example ServiceRequest: ServiceRequest - Iron studies

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md)

> **Patient Sex Parameter For Clinical Use**
* value: Apply female-typical setting or reference range
* comment: Use female reference intervals when interpreting results

**Request status reason**: On-hold pending normal urine MCS or resolution of suspected UTI.

**AU eRequesting Display Sequence**: 4

**identifier**: Placer Identifier/EMC1552642-1110-04

**requisition**: Placer Group Number/EMC1552642-1110

**status**: On Hold

**intent**: Order

**category**: Laboratory procedure

**code**: Iron studies

**subject**: [Remedios BELGER (official) Female, DoB: 1989-01-04 ( IHI: Austalian Healthcare Identifier - Individual#8003608666976378)](Patient-belger-remedios.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 2025-02-21 07:50:00+1000 --> 2025-02-21 08:20:00+1000](Encounter-obsgynaeclinic.md)

**authoredOn**: 2025-02-21

**requester**: [PractitionerRole Obstetrician and Gynaecologist](PractitionerRole-obstetrician-losch-sallie.md)

**supportingInfo**: [Pregnancy status](Observation-observation-pregnancy-status.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "order-ironstudies",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-path"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/patient-sexParameterForClinicalUse",
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/sex-parameter-for-clinical-use",
                "code" : "female-typical",
                "display" : "Apply female-typical setting or reference range"
              }
            ]
          }
        },
        {
          "url" : "comment",
          "valueString" : "Use female reference intervals when interpreting results"
        }
      ]
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/request-statusReason",
      "valueCodeableConcept" : {
        "text" : "On-hold pending normal urine MCS or resolution of suspected UTI."
      }
    },
    {
      "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-displaysequence",
      "valueInteger" : 4
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PLAC",
            "display" : "Placer Identifier"
          }
        ]
      },
      "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
      "value" : "EMC1552642-1110-04",
      "assigner" : {
        "display" : "Elimbah Medical Centre"
      }
    }
  ],
  "requisition" : {
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "code" : "PGN",
          "display" : "Placer Group Number"
        }
      ]
    },
    "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
    "value" : "EMC1552642-1110",
    "assigner" : {
      "display" : "Elimbah Medical Centre"
    }
  },
  "status" : "on-hold",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "108252007",
          "display" : "Laboratory procedure"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "269820002"
      }
    ],
    "text" : "Iron studies"
  },
  "subject" : {
    "reference" : "Patient/belger-remedios"
  },
  "encounter" : {
    "reference" : "Encounter/obsgynaeclinic"
  },
  "authoredOn" : "2025-02-21",
  "requester" : {
    "reference" : "PractitionerRole/obstetrician-losch-sallie"
  },
  "supportingInfo" : [
    {
      "reference" : "Observation/observation-pregnancy-status",
      "display" : "Pregnancy status"
    }
  ]
}

```
