# Organization - Barney View Private Hospital - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Organization - Barney View Private Hospital**

## Example Organization: Organization - Barney View Private Hospital

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md)

**identifier**: HPI-O/8003626566706869, ABN/81193972254

**type**: Private acute care Hospital

**name**: Barney View Private Hospital

**telecom**: ph: 0755507777(Work), [info@barneyviewph.example.net](mailto:info@barneyviewph.example.net)

**address**: 195 Maple Cct Barney View QLD 4287 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "barney-view-private-hospital",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-organization"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "NOI"
          }
        ],
        "text" : "HPI-O"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/hpio/1.0",
      "value" : "8003626566706869"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "XX"
          }
        ],
        "text" : "ABN"
      },
      "system" : "http://hl7.org.au/id/abn",
      "value" : "81193972254"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://www.abs.gov.au/ausstats/abs@.nsf/mf/1292.0",
          "code" : "8401",
          "display" : "Hospitals (Except Psychiatric Hospitals)"
        },
        {
          "system" : "http://snomed.info/sct",
          "code" : "2421000175108",
          "display" : "Acute care inpatient service"
        }
      ],
      "text" : "Private acute care Hospital"
    }
  ],
  "name" : "Barney View Private Hospital",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0755507777",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@barneyviewph.example.net"
    }
  ],
  "address" : [
    {
      "line" : ["195 Maple Cct"],
      "city" : "Barney View",
      "state" : "QLD",
      "postalCode" : "4287"
    }
  ]
}

```
